/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.ActionToTake;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class OutboxTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("OutboxTestConfig.xml");
    }

    private void turnOnOutboxForUser(final String principalId) {
        new TransactionTemplate(KEWServiceLocator.getPlatformTransactionManager()).execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                KEWServiceLocator.getUserOptionsService().save(principalId, "USE_OUT_BOX", "yes");
                return null;
            }
        });
    }

    @Test
    public void testOutboxItemNotSavedOnSavedDocumentStatus() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(rkirkendPrincipalId);
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "qualRole", recipients);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("quickstart"), (String)"TestDocumentType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        document.saveDocument("");
        Collection outbox = KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter());
        Assert.assertEquals((String)"there should not be any outbox items", (long)0L, (long)outbox.size());
    }

    @Test
    public void testTakeActionsOnOutboxItem() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(rkirkendPrincipalId);
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "qualRole", recipients);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("quickstart"), (String)"TestDocumentType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        document.approve("");
        Collection outbox = KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter());
        Assert.assertEquals((String)"there should be an outbox item", (long)1L, (long)outbox.size());
        outbox = KEWServiceLocator.getActionListService().getOutboxItemsByDocumentType(document.getDocumentTypeName());
        Assert.assertEquals((String)"there should be an outbox item", (long)1L, (long)outbox.size());
        ArrayList<String> outBoxItemIds = new ArrayList<String>();
        ActionItem actionItem2 = null;
        for (ActionItem actionItem2 : outbox) {
            outBoxItemIds.add(actionItem2.getId());
        }
        KEWServiceLocator.getActionListService().removeOutboxItems(rkirkendPrincipalId, outBoxItemIds);
        outbox = KEWServiceLocator.getActionListService().getOutboxItemsByDocumentType(document.getDocumentTypeName());
        Assert.assertEquals((String)"there should be zero outbox item", (long)0L, (long)outbox.size());
        KEWServiceLocator.getActionListService().saveOutboxItem(actionItem2);
        outbox = KEWServiceLocator.getActionListService().getOutboxItemsByDocumentType(document.getDocumentTypeName());
        Assert.assertEquals((String)"there should be 1 outbox item", (long)1L, (long)outbox.size());
    }

    @Test
    public void testSingleOutboxItemPerDocument() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(rkirkendPrincipalId);
        recipients.add(user1PrincipalId);
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "qualRole", recipients);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("quickstart"), (String)"TestDocumentType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", user1PrincipalId, "", true);
        document.approve("");
        Collection outbox = KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter());
        Assert.assertEquals((String)"there should be an outbox item", (long)1L, (long)outbox.size());
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", rkirkendPrincipalId, "", true);
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        document.approve("");
        outbox = KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter());
        Assert.assertEquals((String)"there should be an outbox item", (long)1L, (long)outbox.size());
    }

    @Test
    public void testOnlyPersonWhoTookActionReceivesOutboxItem_Route() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(this.getPrincipalIdForName("rkirkend"));
        recipients.add(this.getPrincipalIdForName("user1"));
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "qualRole", recipients);
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        this.turnOnOutboxForUser(user1PrincipalId);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("quickstart"), (String)"TestDocumentType");
        document.route("");
        Assert.assertFalse((boolean)KEWServiceLocator.getActionListService().getActionList(rkirkendPrincipalId, new ActionListFilter()).isEmpty());
        Assert.assertFalse((boolean)KEWServiceLocator.getActionListService().getActionList(user1PrincipalId, new ActionListFilter()).isEmpty());
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((boolean)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).isEmpty());
        Assert.assertEquals((long)1L, (long)KEWServiceLocator.getActionListService().getOutbox(user1PrincipalId, new ActionListFilter()).size());
    }

    @Test
    public void testOnlyPersonWhoTookActionReceivesOutboxItem_BlanketApprove() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(rkirkendPrincipalId);
        recipients.add(user1PrincipalId);
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "qualRole", recipients);
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        this.turnOnOutboxForUser(user1PrincipalId);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.blanketApprove("");
        Assert.assertEquals((String)"Wrong number of outbox items found for rkirkend", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for user1", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(user1PrincipalId, new ActionListFilter()).size());
        document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.saveDocument("");
        Assert.assertEquals((String)"Wrong number of action items found for rkirkend", (long)1L, (long)KEWServiceLocator.getActionListService().getActionList(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for rkirkend", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for user1", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(user1PrincipalId, new ActionListFilter()).size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.blanketApprove("");
        Assert.assertEquals((String)"Wrong number of outbox items found for rkirkend", (long)1L, (long)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for user1", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(user1PrincipalId, new ActionListFilter()).size());
    }

    @Test
    public void testOnlyPersonWhoTookActionReceivesOutboxItem_Workgroup() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        this.turnOnOutboxForUser(user1PrincipalId);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user2"), (String)"OutboxTestDocumentType");
        document.route("");
        Assert.assertEquals((String)"Wrong number of action items found for rkirkend", (long)1L, (long)KEWServiceLocator.getActionListService().getActionList(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of action items found for ewestfal", (long)1L, (long)KEWServiceLocator.getActionListService().getActionList(ewestfalPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of action items found for user1", (long)1L, (long)KEWServiceLocator.getActionListService().getActionList(user1PrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for rkirkend", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for ewestfal", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(ewestfalPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for user1", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(user1PrincipalId, new ActionListFilter()).size());
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        document.approve("");
        Assert.assertEquals((String)"Wrong number of outbox items found for rkirkend", (long)1L, (long)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for ewestfal", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(ewestfalPrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((String)"Wrong number of outbox items found for user1", (long)0L, (long)KEWServiceLocator.getActionListService().getOutbox(user1PrincipalId, new ActionListFilter()).size());
    }

    @Test
    public void testOutBoxDefaultPreferenceOnConfigParam() throws Exception {
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        Preferences prefs = KewApiServiceLocator.getPreferencesService().getPreferences(user1PrincipalId);
        Assert.assertTrue((String)"By default the user's pref should be outbox on", (boolean)Truth.strToBooleanIgnoreCase((String)prefs.getUseOutbox()));
    }

    @Test
    public void testTakeMassActions() throws Exception {
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(rkirkendPrincipalId);
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "qualRole", recipients);
        this.turnOnOutboxForUser(rkirkendPrincipalId);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("quickstart"), (String)"TestDocumentType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"OutboxTestDocumentType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"approve should be requested", (boolean)document.isApprovalRequested());
        ArrayList actionList = new ArrayList(KEWServiceLocator.getActionListService().getActionList(rkirkendPrincipalId, new ActionListFilter()));
        ArrayList<ActionInvocation> invocations = new ArrayList<ActionInvocation>();
        ActionToTake actionToTake = new ActionToTake();
        ActionItem actionItem = new ActionItem();
        for (ActionItem actinItem : actionList) {
            actionToTake.setActionItemId(actinItem.getId());
            actionToTake.setActionTakenCd(actinItem.getActionRequestCd());
            invocations.add(ActionInvocation.create((ActionType)ActionType.fromCode((String)actionToTake.getActionTakenCd()), (String)actinItem.getId()));
        }
        KEWServiceLocator.getWorkflowDocumentService().takeMassActions(rkirkendPrincipalId, invocations);
        Assert.assertEquals((String)"Wrong number of outbox items found for rkirkendPrincipalId", (long)2L, (long)KEWServiceLocator.getActionListService().getOutbox(rkirkendPrincipalId, new ActionListFilter()).size());
    }
}

