/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.MovePoint;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class MoveDocumentTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testMoveDocumentSequential() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"MoveSequentialTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Bmcgough should have an approve.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Rkirkend should have an approve.", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Should be at the WorkflowDocument Node.", (Object)"WorkflowDocument", document.getNodeNames().iterator().next());
        document.move(MovePoint.create((String)"WorkflowDocument", (int)1), "");
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be only 1 pending approve request to pmckown.", (long)1L, (long)actionRequests.size());
        Assert.assertEquals((String)"Should be at the WorkflowDocument2 Node.", (Object)"WorkflowDocument2", document.getNodeNames().iterator().next());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Bmcgough should NOT have an approve.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Rkirkend should NOT have an approve.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Pmckown should have an approve.", (boolean)document.isApprovalRequested());
        ActionRequestValue pmckownRequest = (ActionRequestValue)actionRequests.get(0);
        document.move(MovePoint.create((String)"WorkflowDocument2", (int)0), "");
        Assert.assertTrue((String)"Pmckown should still have an approve.", (boolean)document.isApprovalRequested());
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be only 1 pending approve request to pmckown.", (long)1L, (long)actionRequests.size());
        Assert.assertEquals((String)"Should be at the WorkflowDocument2 Node.", (Object)"WorkflowDocument2", document.getNodeNames().iterator().next());
        Assert.assertFalse((String)"Action request ids should be different.", (boolean)pmckownRequest.getActionRequestId().equals(((ActionRequestValue)actionRequests.get(0)).getActionRequestId()));
        document.move(MovePoint.create((String)"WorkflowDocument2", (int)-1), "");
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be 2 pending requests.", (long)2L, (long)actionRequests.size());
        Assert.assertEquals((String)"Should be at the WorkflowDocument Node.", (Object)"WorkflowDocument", document.getNodeNames().iterator().next());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Bmcgough should have an approve.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Rkirkend should have an approve.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Doc should be ENROUTE.", (boolean)document.isEnroute());
        document.move(MovePoint.create((String)"WorkflowDocument", (int)2), "");
        Assert.assertTrue((String)"Doc should be PROCESSED.", (boolean)document.isProcessed());
    }

    @Test
    public void testMoveDocumentInsideProcess() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"MoveInProcessTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have approve", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have approve", (boolean)document.isApprovalRequested());
        document.approve("");
        WorkflowDocumentService workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
        List activeNodeInstances = workflowDocumentService.getActiveRouteNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 active node instance.", (long)1L, (long)activeNodeInstances.size());
        RouteNodeInstance node2 = (RouteNodeInstance)activeNodeInstances.get(0);
        Assert.assertEquals((String)"Should be at the WorkflowDocument2 node.", (Object)"WorkflowDocument2", (Object)node2.getName());
        Assert.assertTrue((String)"Node should be in a process.", (node2.getProcessId() != null ? 1 : 0) != 0);
        document.move(MovePoint.create((String)"WorkflowDocument2", (int)1), "");
        activeNodeInstances = workflowDocumentService.getActiveRouteNodeInstances(document.getDocumentId());
        RouteNodeInstance node3 = (RouteNodeInstance)activeNodeInstances.get(0);
        Assert.assertEquals((String)"Should be at the WorkflowDocument3 node.", (Object)"WorkflowDocument3", (Object)node3.getName());
        Assert.assertTrue((String)"Node should be in a process.", (node3.getProcessId() != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Node 2 and 3 should be in the same process.", (Object)node2.getProcessId(), (Object)node3.getProcessId());
        document.move(MovePoint.create((String)"WorkflowDocument3", (int)0), "");
        document.move(MovePoint.create((String)"WorkflowDocument3", (int)-1), "");
    }

    @Test
    public void testMoveDocumentParallel() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"BlanketApproveParallelTest");
        document.blanketApprove("", new String[]{"WorkflowDocument2-B2", "WorkflowDocument3-B1", "WorkflowDocument4-B3"});
        Set<String> nodeNames = TestUtilities.createNodeInstanceNameSet(KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId()));
        Assert.assertEquals((String)"There should be 3 active nodes.", (long)3L, (long)nodeNames.size());
        Assert.assertTrue((String)"Should be at WorkflowDocument3-B1", (boolean)nodeNames.contains("WorkflowDocument3-B1"));
        Assert.assertTrue((String)"Should be at WorkflowDocument2-B2", (boolean)nodeNames.contains("WorkflowDocument2-B2"));
        Assert.assertTrue((String)"Should be at WorkflowDocument4-B3", (boolean)nodeNames.contains("WorkflowDocument4-B3"));
        document.move(MovePoint.create((String)"WorkflowDocument3-B1", (int)-1), "");
        nodeNames = TestUtilities.createNodeInstanceNameSet(KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId()));
        Assert.assertEquals((String)"There should be 3 active nodes.", (long)3L, (long)nodeNames.size());
        Assert.assertTrue((String)"Should be at WorkflowDocument2-B1", (boolean)nodeNames.contains("WorkflowDocument2-B1"));
        Assert.assertTrue((String)"Should be at WorkflowDocument2-B2", (boolean)nodeNames.contains("WorkflowDocument2-B2"));
        Assert.assertTrue((String)"Should be at WorkflowDocument4-B3", (boolean)nodeNames.contains("WorkflowDocument4-B3"));
    }

    private class ParallelSetup {
        public static final String DOCUMENT_TYPE_NAME = "BlanketApproveParallelTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_B1_NODE = "WorkflowDocument2-B1";
        public static final String WORKFLOW_DOCUMENT_2_B2_NODE = "WorkflowDocument2-B2";
        public static final String WORKFLOW_DOCUMENT_3_B1_NODE = "WorkflowDocument3-B1";
        public static final String WORKFLOW_DOCUMENT_3_B2_NODE = "WorkflowDocument3-B2";
        public static final String WORKFLOW_DOCUMENT_4_B3_NODE = "WorkflowDocument4-B3";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";
        public static final String JOIN_NODE = "Join";
        public static final String SPLIT_NODE = "Split";
        public static final String WORKFLOW_DOCUMENT_FINAL_NODE = "WorkflowDocumentFinal";

        private ParallelSetup() {
        }
    }

    private class SeqSetup {
        public static final String DOCUMENT_TYPE_NAME = "MoveSequentialTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String WORKFLOW_DOCUMENT_3_NODE = "WorkflowDocument3";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private SeqSetup() {
        }
    }
}

