/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.doctype.service.impl.KimDocumentTypeAuthorizer;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.common.attribute.KimAttributeContract;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.common.template.TemplateContract;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class RecallActionTest
extends KEWTestCase {
    private static final String RECALL_TEST_DOC = "RecallTest";
    private static final String RECALL_TEST_RESTRICTED_DOC = "RecallTestRestricted";
    private static final String RECALL_TEST_NOROUTING_DOC = "RecallTestNoRouting";
    private static final String RECALL_TEST_ONLYADHOC_DOC = "RecallTestOnlyAdhoc";
    private static final String RECALL_NOTIFY_TEST_DOC = "RecallWithPrevNotifyTest";
    private static final String RECALL_NO_PENDING_NOTIFY_TEST_DOC = "RecallWithoutPendingNotifyTest";
    private static final String RECALL_NOTIFY_THIRDPARTY_TEST_DOC = "RecallWithThirdPartyNotifyTest";
    private String EWESTFAL = null;
    private String JHOPF = null;
    private String RKIRKEND = null;
    private String NATJOHNS = null;
    private String BMCGOUGH = null;
    private static final String PERM_APP_DOC_STATUS = "recallable by admins";
    private static final String ROUTE_NODE = "NotifyFirst";
    private static final String ROUTE_STATUS = "R";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        this.EWESTFAL = this.getPrincipalIdForName("ewestfal");
        this.JHOPF = this.getPrincipalIdForName("jhopf");
        this.RKIRKEND = this.getPrincipalIdForName("rkirkend");
        this.NATJOHNS = this.getPrincipalIdForName("natjohns");
        this.BMCGOUGH = this.getPrincipalIdForName("bmcgough");
        RecallTestPostProcessor.afterActionTakenType = null;
        RecallTestPostProcessor.afterActionTakenEvent = null;
    }

    protected void assertAfterActionTakenCalled(ActionType performed, ActionType taken) {
        Assert.assertEquals((Object)performed, (Object)RecallTestPostProcessor.afterActionTakenType);
        Assert.assertNotNull((Object)RecallTestPostProcessor.afterActionTakenEvent);
        Assert.assertEquals((Object)taken, (Object)RecallTestPostProcessor.afterActionTakenEvent.getActionTaken().getActionTaken());
    }

    @Test(expected=InvalidActionTakenException.class)
    public void testCantRecallUnroutedDoc() {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.recall("recalling", true);
    }

    @Test
    public void testRecallAsInitiatorBeforeAnyApprovals() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        document.recall("recalling", true);
        Assert.assertTrue((String)"Document should be recalled", (boolean)document.isRecalled());
        this.assertAfterActionTakenCalled(ActionType.RECALL, ActionType.RECALL);
        List requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should not have any active requests", (long)0L, (long)requests.size());
        Collection actionItems = KEWServiceLocator.getActionListService().findByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Should not have any action items", (long)0L, (long)actionItems.size());
    }

    @Test
    public void testRecallValidActionsTaken() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_RESTRICTED_DOC);
        document.route("routing");
        document.recall("recalling", true);
        document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_RESTRICTED_DOC);
        document.saveDocument("saving");
        document.route("routing");
        document.recall("recalling", true);
    }

    @Test
    public void testRecallInvalidActionsTaken() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_RESTRICTED_DOC);
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId());
        document.approve("");
        try {
            document.recall("recalling", true);
            Assert.fail((String)"Recall should NOT have succeeded.  Expected InvalidActionTakenException due to invalid 'APROVE' prior action taken.");
        }
        catch (InvalidActionTakenException iate) {
            Assert.assertTrue((boolean)iate.getMessage().contains("Invalid prior action taken: 'APPROVE'"));
        }
    }

    @Test
    public void testRecallOnlyAdhocRouting() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_ONLYADHOC_DOC);
        document.adHocToPrincipal(ActionRequestType.APPROVE, "adhoc approve to JHOPF", this.JHOPF, "adhocing to prevent finalization", true);
        document.route("routing");
        try {
            document.recall("recalling", true);
            Assert.fail((String)"Recall should NOT have succeeded.  Expected InvalidActionTakenException due to absence of non-adhoc route nodes.");
        }
        catch (InvalidActionTakenException iate) {
            Assert.assertTrue((boolean)iate.getMessage().contains("No non-adhoc route nodes defined"));
        }
    }

    @Test
    public void testRecallAsInitiatorAfterSingleApproval() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.EWESTFAL, (String)document.getDocumentId());
        document.recall("recalling", true);
        Assert.assertTrue((String)"Document should be recalled", (boolean)document.isRecalled());
        this.assertAfterActionTakenCalled(ActionType.RECALL, ActionType.RECALL);
        List requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should not have any active requests", (long)0L, (long)requests.size());
        Collection actionItems = KEWServiceLocator.getActionListService().findByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Should not have any action items", (long)0L, (long)actionItems.size());
        Assert.assertFalse((boolean)document.getValidActions().getValidActions().contains(ActionType.RECALL));
    }

    @Test(expected=InvalidActionTakenException.class)
    public void testRecallInvalidWhenProcessed() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        for (String user : new String[]{this.JHOPF, this.EWESTFAL, this.RKIRKEND, this.NATJOHNS, this.BMCGOUGH}) {
            document = WorkflowDocumentFactory.loadDocument((String)user, (String)document.getDocumentId());
            document.approve("");
        }
        document.refresh();
        Assert.assertTrue((String)"Document should be processed", (boolean)document.isProcessed());
        Assert.assertTrue((String)"Document should be approved", (boolean)document.isApproved());
        Assert.assertFalse((String)"Document should not be final", (boolean)document.isFinal());
        document = WorkflowDocumentFactory.loadDocument((String)this.EWESTFAL, (String)document.getDocumentId());
        document.recall("recalling when processed should fail", true);
    }

    @Test(expected=InvalidActionTakenException.class)
    public void testRecallInvalidWhenFinal() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        for (String user : new String[]{this.JHOPF, this.EWESTFAL, this.RKIRKEND, this.NATJOHNS, this.BMCGOUGH}) {
            document = WorkflowDocumentFactory.loadDocument((String)user, (String)document.getDocumentId());
            document.approve("");
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jthomas"), (String)document.getDocumentId());
        document.fyi();
        for (ActionRequest a : document.getRootActionRequests()) {
            System.err.println(a);
            if (!a.isAcknowledgeRequest() && !a.isFyiRequest()) continue;
            System.err.println(a.getPrincipalId());
            System.err.println(KimApiServiceLocator.getIdentityService().getPrincipal(a.getPrincipalId()).getPrincipalName());
        }
        Assert.assertFalse((String)"Document should not be processed", (boolean)document.isProcessed());
        Assert.assertTrue((String)"Document should be approved", (boolean)document.isApproved());
        Assert.assertTrue((String)"Document should be final", (boolean)document.isFinal());
        document = WorkflowDocumentFactory.loadDocument((String)this.EWESTFAL, (String)document.getDocumentId());
        document.recall("recalling when processed should fail", true);
    }

    @Test
    public void testRecallToActionListAsInitiatorBeforeAnyApprovals() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        document.recall("recalling", false);
        Assert.assertTrue((String)"Document should be saved", (boolean)document.isSaved());
        Assert.assertEquals((long)1L, (long)document.getCurrentNodeNames().size());
        Assert.assertTrue((boolean)document.getCurrentNodeNames().contains("AdHoc"));
        this.assertAfterActionTakenCalled(ActionType.RECALL, ActionType.COMPLETE);
        Assert.assertTrue((boolean)document.isCompletionRequested());
        Assert.assertFalse((boolean)document.getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertTrue((boolean)WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId()).isFYIRequested());
        document.complete("completing");
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        Assert.assertTrue((boolean)WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId()).isApprovalRequested());
    }

    protected Permission createRecallPermission(String docType, String appDocStatus, String routeNode, String routeStatus) {
        return this.createPermissionForTemplate("KR-WKFLW", "Recall Document", "KR-WKFLW", "Recall Document for test case", docType, appDocStatus, routeNode, routeStatus);
    }

    protected Permission createRouteDocumentPermission(String docType, String appDocStatus, String routeNode, String routeStatus) {
        return this.createPermissionForTemplate("KR-WKFLW", "Route Document", "KR-WKFLW", "Route Document for test case", docType, appDocStatus, routeNode, routeStatus);
    }

    protected Permission createPermissionForTemplate(String template_ns, String template_name, String permission_ns, String permission_name, String docType, String appDocStatus, String routeNode, String routeStatus) {
        Template permTmpl = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName(template_ns, template_name);
        Assert.assertNotNull((Object)permTmpl);
        Permission.Builder permission = Permission.Builder.create((String)permission_ns, (String)permission_name);
        permission.setDescription(permission_name);
        permission.setTemplate(Template.Builder.create((TemplateContract)permTmpl));
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("documentTypeName", docType);
        attrs.put("appDocStatus", appDocStatus);
        attrs.put("routeNodeName", routeNode);
        attrs.put("routeStatusCode", routeStatus);
        permission.setActive(true);
        permission.setAttributes(attrs);
        Permission perm = KimApiServiceLocator.getPermissionService().createPermission(permission.build());
        Assert.assertEquals((Object)perm.getTemplate().getId(), (Object)permTmpl.getId());
        int num = 1;
        if (appDocStatus != null) {
            ++num;
        }
        if (routeNode != null) {
            ++num;
        }
        if (routeStatus != null) {
            ++num;
        }
        Assert.assertEquals((long)num, (long)perm.getAttributes().size());
        Assert.assertEquals((Object)docType, perm.getAttributes().get("documentTypeName"));
        Assert.assertEquals((Object)appDocStatus, perm.getAttributes().get("appDocStatus"));
        Assert.assertEquals((Object)routeNode, perm.getAttributes().get("routeNodeName"));
        Assert.assertEquals((Object)routeStatus, perm.getAttributes().get("routeStatusCode"));
        return perm;
    }

    protected void disableInitiatorRecallPermission() {
        Permission p = KimApiServiceLocator.getPermissionService().findPermByNamespaceCodeAndName("KR-WKFLW", "Recall Document");
        Permission.Builder pb = Permission.Builder.create((PermissionContract)p);
        pb.setActive(false);
        KimApiServiceLocator.getPermissionService().updatePermission(pb.build());
    }

    protected void setKimPriorityOnDocumentTypeParameterValue(String parameterValue) {
        if (CoreFrameworkServiceLocator.getParameterService().parameterExists("KR-WKFLW", "All", "KIM_PRIORITY_ON_DOC_TYP_PERMS_IND").booleanValue()) {
            Parameter kimPriorityOverDocTypePolicyParameter = CoreFrameworkServiceLocator.getParameterService().getParameter("KR-WKFLW", "All", "KIM_PRIORITY_ON_DOC_TYP_PERMS_IND");
            Parameter.Builder b = Parameter.Builder.create((ParameterContract)kimPriorityOverDocTypePolicyParameter);
            b.setValue(parameterValue);
            CoreFrameworkServiceLocator.getParameterService().updateParameter(b.build());
        }
    }

    protected String getKimPriorityOnDocumentTypeParameterValue() {
        if (CoreFrameworkServiceLocator.getParameterService().parameterExists("KR-WKFLW", "All", "KIM_PRIORITY_ON_DOC_TYP_PERMS_IND").booleanValue()) {
            return CoreFrameworkServiceLocator.getParameterService().getParameter("KR-WKFLW", "All", "KIM_PRIORITY_ON_DOC_TYP_PERMS_IND").getValue();
        }
        return null;
    }

    @Test
    public void testRecallPermissionMatching() {
        this.disableInitiatorRecallPermission();
        this.createRecallPermission(RECALL_TEST_DOC, PERM_APP_DOC_STATUS, ROUTE_NODE, ROUTE_STATUS);
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("documentTypeName", RECALL_TEST_DOC);
        details.put("appDocStatus", PERM_APP_DOC_STATUS);
        details.put("routeNodeName", ROUTE_NODE);
        details.put("routeStatusCode", ROUTE_STATUS);
        for (Map.Entry entry : details.entrySet()) {
            HashMap testDetails = new HashMap(details);
            testDetails.put(entry.getKey(), (String)entry.getValue() + " BOGUS ");
            Assert.assertFalse((String)("non-matching " + (String)entry.getKey() + " detail should cause template to not match"), (boolean)KimApiServiceLocator.getPermissionService().isPermissionDefinedByTemplate("KR-WKFLW", "Recall Document", testDetails));
        }
        Assert.assertTrue((String)"template should match details", (boolean)KimApiServiceLocator.getPermissionService().isPermissionDefinedByTemplate("KR-WKFLW", "Recall Document", details));
    }

    @Test
    public void testRecallPermissionTemplate() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Permission perm = this.createRecallPermission(RECALL_TEST_DOC, PERM_APP_DOC_STATUS, ROUTE_NODE, ROUTE_STATUS);
        Role techadmin = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        KimApiServiceLocator.getRoleService().assignPermissionToRole(perm.getId(), techadmin.getId());
        document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_NOTIFY_TEST_DOC);
        document.route(PERM_APP_DOC_STATUS);
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId()).approve("");
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.route("");
        document.cancel("cancelled");
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        document = WorkflowDocumentFactory.createDocument((String)this.EWESTFAL, (String)RECALL_TEST_DOC);
        document.setApplicationDocumentStatus(PERM_APP_DOC_STATUS);
        document.route("");
        Assert.assertTrue((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
        Assert.assertTrue((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId()).getValidActions().getValidActions().contains(ActionType.RECALL));
    }

    @Test
    public void testRecallToActionListAsInitiatorAfterApprovals() throws Exception {
        this.testRecallToActionListAsInitiatorAfterApprovals(RECALL_TEST_DOC);
    }

    @Test
    public void testRecallToActionListAsInitiatorWithNotificationAfterApprovals() throws Exception {
        this.testRecallToActionListAsInitiatorAfterApprovals(RECALL_NOTIFY_TEST_DOC);
    }

    @Test
    public void testRecallToActionListAsInitiatorWithoutPendingNotificationAfterApprovals() throws Exception {
        this.testRecallToActionListAsInitiatorAfterApprovals(RECALL_NO_PENDING_NOTIFY_TEST_DOC);
    }

    @Test
    public void testRecallToActionListAsInitiatorWithThirdPartyNotificationAfterApprovals() throws Exception {
        this.testRecallToActionListAsInitiatorAfterApprovals(RECALL_NOTIFY_THIRDPARTY_TEST_DOC);
    }

    @Test
    public void testRecallToActionListAsThirdParty() throws Exception {
        Permission perm = this.createRecallPermission(RECALL_TEST_DOC, null, null, null);
        Role techadmin = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        KimApiServiceLocator.getRoleService().assignPermissionToRole(perm.getId(), techadmin.getId());
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, this.getPrincipalIdForName("admin"), RECALL_TEST_DOC);
    }

    protected void assignRoutePermissionToTechAdmin() {
        Permission routePerm = this.createRouteDocumentPermission(RECALL_TEST_DOC, null, null, null);
        Role techadmin = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        KimApiServiceLocator.getRoleService().assignPermissionToRole(routePerm.getId(), techadmin.getId());
    }

    protected void assignRecallPermissionToDocumentRouters() {
        Permission recallPerm = this.createRecallPermission(RECALL_TEST_DOC, null, null, null);
        Role documentRouterDerivedRole = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName("KR-WKFLW", "Document Router");
        KimApiServiceLocator.getRoleService().assignPermissionToRole(recallPerm.getId(), documentRouterDerivedRole.getId());
    }

    @Test
    public void testRoutePermissionAssignmentInsufficientForRouterToRecallDoc() throws Exception {
        this.assignRoutePermissionToTechAdmin();
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, this.getPrincipalIdForName("admin"), RECALL_TEST_DOC, false);
    }

    @Test
    public void testRecallPermissionAssignmentInsufficientForRouterToRecallDoc() throws Exception {
        this.assignRecallPermissionToDocumentRouters();
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, this.getPrincipalIdForName("admin"), RECALL_TEST_DOC, false);
    }

    @Test
    public void testRecallToActionListAsRouterDerivedRole() throws Exception {
        this.assignRoutePermissionToTechAdmin();
        this.assignRecallPermissionToDocumentRouters();
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, this.getPrincipalIdForName("admin"), RECALL_TEST_DOC);
    }

    protected Role createRoleWithRecallPermission(String ns, String name, Permission recallPerm, String kimTypeName, String roleQualifierName) {
        KimAttribute.Builder attribute = KimAttribute.Builder.create((String)"org.kuali.rice.kim.bo.impl.KimAttributes", (String)roleQualifierName, (String)"KR-SYS");
        attribute.setAttributeLabel(roleQualifierName);
        attribute.setActive(true);
        KimAttributeBo customAttribute = (KimAttributeBo)KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)KimAttributeBo.from((KimAttribute)attribute.build()));
        KimType.Builder kimType = KimType.Builder.create();
        kimType.setNamespaceCode("KR-SYS");
        kimType.setName(kimTypeName);
        kimType.setActive(true);
        KimTypeAttribute.Builder kimTypeAttribute = KimTypeAttribute.Builder.create();
        kimTypeAttribute.setKimAttribute(KimAttribute.Builder.create((KimAttributeContract)customAttribute));
        kimTypeAttribute.setActive(true);
        kimType.setAttributeDefinitions(Collections.singletonList(kimTypeAttribute));
        KimTypeBo customKimType = (KimTypeBo)KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)KimTypeBo.from((KimType)kimType.build()));
        Role.Builder role = Role.Builder.create();
        role.setActive(true);
        role.setDescription("RecallTest custom recall role");
        role.setName(ns);
        role.setNamespaceCode(name);
        role.setKimTypeId(customKimType.getId());
        Role customRole = KimApiServiceLocator.getRoleService().createRole(role.build());
        KimApiServiceLocator.getRoleService().assignPermissionToRole(recallPerm.getId(), customRole.getId());
        List recallCapableRoleIds = KimApiServiceLocator.getPermissionService().getRoleIdsForPermission(recallPerm.getNamespaceCode(), recallPerm.getName());
        junit.framework.Assert.assertFalse((String)"No recall-capable roles found", (boolean)recallCapableRoleIds.isEmpty());
        junit.framework.Assert.assertTrue((String)"New role is not associated with Recall permission", (boolean)recallCapableRoleIds.contains(customRole.getId()));
        return customRole;
    }

    protected void assignUserQualifiedRole(String principalId, Role role, String roleQualifierName, String roleQualifierValue) {
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put(roleQualifierName, roleQualifierValue);
        KimApiServiceLocator.getRoleService().assignPrincipalToRole(this.getPrincipalIdForName("arh14"), role.getNamespaceCode(), role.getName(), qualifications);
        Collection ids = KimApiServiceLocator.getRoleService().getRoleMemberPrincipalIds(role.getNamespaceCode(), role.getName(), qualifications);
        junit.framework.Assert.assertTrue((String)"Qualified role assignment failed", (boolean)ids.contains(principalId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecallWithCustomDocumentTypeAuthorizer() throws Exception {
        String ARH14 = this.getPrincipalIdForName("arh14");
        this.disableInitiatorRecallPermission();
        RecallTestDocumentTypeAuthorizer.buildPermissionDetailsInvoked = false;
        RecallTestDocumentTypeAuthorizer.buildRoleQualifiersInvoked = false;
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, this.getPrincipalIdForName("arh14"), RECALL_TEST_DOC, false);
        String RECALL_ROLE_NM = "CustomRecall";
        String RECALL_ROLE_NS = "KR-SYS";
        Permission recallPerm = this.createRecallPermission(RECALL_TEST_DOC, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_DETAIL_VALUE, null, null);
        Role recallRole = this.createRoleWithRecallPermission("CustomRecall", "KR-SYS", recallPerm, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_KIM_TYPE_NAME, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_NAME);
        this.assignUserQualifiedRole(ARH14, recallRole, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_NAME, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_VALUE);
        HashMap<String, String> d = new HashMap<String, String>();
        d.put(RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_DETAIL_NAME, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_DETAIL_VALUE);
        d.put("documentTypeName", RECALL_TEST_DOC);
        d.put("routeNodeName", ROUTE_NODE);
        d.put("routeStatusCode", ROUTE_STATUS);
        HashMap<String, String> q = new HashMap<String, String>();
        q.put(RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_NAME, RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_VALUE);
        List permissions = KimApiServiceLocator.getPermissionService().getAuthorizedPermissionsByTemplate(ARH14, "KR-WKFLW", "Recall Document", d, q);
        junit.framework.Assert.assertEquals((int)1, (int)permissions.size());
        junit.framework.Assert.assertEquals((String)recallPerm.getId(), (String)((Permission)permissions.get(0)).getId());
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, ARH14, RECALL_TEST_DOC, false);
        DocumentType dt = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(RECALL_TEST_DOC);
        DocumentType.Builder b = DocumentType.Builder.create((DocumentTypeContract)dt);
        b.setAuthorizer(RecallTestDocumentTypeAuthorizer.class.getName());
        KEWServiceLocator.getDocumentTypeService().save(org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)b));
        junit.framework.Assert.assertEquals((String)RecallTestDocumentTypeAuthorizer.class.getName(), (String)KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(RECALL_TEST_DOC).getAuthorizer());
        junit.framework.Assert.assertFalse((boolean)RecallTestDocumentTypeAuthorizer.buildPermissionDetailsInvoked);
        junit.framework.Assert.assertFalse((boolean)RecallTestDocumentTypeAuthorizer.buildRoleQualifiersInvoked);
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, ARH14, RECALL_TEST_DOC);
        junit.framework.Assert.assertTrue((boolean)RecallTestDocumentTypeAuthorizer.buildPermissionDetailsInvoked);
        junit.framework.Assert.assertTrue((boolean)RecallTestDocumentTypeAuthorizer.buildRoleQualifiersInvoked);
        String orig = RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_VALUE;
        try {
            RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_VALUE = "I will not match";
            this.testRecallToActionListAfterApprovals(this.EWESTFAL, ARH14, RECALL_TEST_DOC, false);
        }
        finally {
            RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_QUALIFIER_VALUE = orig;
        }
        orig = RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_DETAIL_VALUE;
        try {
            RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_DETAIL_VALUE = "I won't match either";
            this.testRecallToActionListAfterApprovals(this.EWESTFAL, ARH14, RECALL_TEST_DOC, false);
        }
        finally {
            RecallTestDocumentTypeAuthorizer.CUSTOM_RECALL_DETAIL_VALUE = orig;
        }
    }

    protected void testRecallToActionListAsInitiatorAfterApprovals(String doctype) {
        this.testRecallToActionListAfterApprovals(this.EWESTFAL, this.EWESTFAL, doctype);
    }

    protected void testRecallToActionListAfterApprovals(String initiator, String recaller, String doctype) {
        this.testRecallToActionListAfterApprovals(initiator, recaller, doctype, true);
    }

    protected void testRecallToActionListAfterApprovals(String initiator, String recaller, String doctype, boolean expect_recall_success) {
        Object[] objectArray;
        boolean notifyPendingRecipients;
        boolean notifyPreviousRecipients = !RECALL_TEST_DOC.equals(doctype);
        boolean bl = notifyPendingRecipients = !RECALL_NO_PENDING_NOTIFY_TEST_DOC.equals(doctype);
        if (RECALL_NOTIFY_THIRDPARTY_TEST_DOC.equals(doctype)) {
            String[] stringArray = new String[2];
            stringArray[0] = "quickstart";
            objectArray = stringArray;
            stringArray[1] = "admin";
        } else {
            objectArray = new String[]{};
        }
        Object[] thirdPartiesNotified = objectArray;
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)initiator, (String)doctype);
        document.route("");
        WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId()).approve("");
        WorkflowDocumentFactory.loadDocument((String)initiator, (String)document.getDocumentId()).approve("");
        WorkflowDocumentFactory.loadDocument((String)this.RKIRKEND, (String)document.getDocumentId()).approve("");
        document = WorkflowDocumentFactory.loadDocument((String)recaller, (String)document.getDocumentId());
        System.err.println(document.getValidActions().getValidActions());
        if (!expect_recall_success) {
            Assert.assertFalse((String)("recaller '" + recaller + "' should NOT be able to RECALL"), (boolean)document.getValidActions().getValidActions().contains(ActionType.RECALL));
            return;
        }
        Assert.assertTrue((String)("recaller '" + recaller + "' should be able to RECALL"), (boolean)document.getValidActions().getValidActions().contains(ActionType.RECALL));
        document.recall("recalling", false);
        Assert.assertTrue((String)"Document should be saved", (boolean)document.isSaved());
        this.assertAfterActionTakenCalled(ActionType.RECALL, ActionType.COMPLETE);
        Assert.assertTrue((boolean)document.isCompletionRequested());
        Assert.assertEquals((Object)notifyPendingRecipients, (Object)WorkflowDocumentFactory.loadDocument((String)this.NATJOHNS, (String)document.getDocumentId()).isFYIRequested());
        Assert.assertEquals((Object)notifyPreviousRecipients, (Object)WorkflowDocumentFactory.loadDocument((String)this.RKIRKEND, (String)document.getDocumentId()).isFYIRequested());
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)initiator, (String)document.getDocumentId()).isFYIRequested());
        Assert.assertEquals((Object)notifyPreviousRecipients, (Object)WorkflowDocumentFactory.loadDocument((String)this.JHOPF, (String)document.getDocumentId()).isFYIRequested());
        if (!ArrayUtils.isEmpty((Object[])thirdPartiesNotified)) {
            for (Object object : thirdPartiesNotified) {
                Assert.assertTrue((String)("Expected FYI to be sent to: " + (String)object), (boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName((String)object), (String)document.getDocumentId()).isFYIRequested());
            }
        }
        for (String string : new String[]{this.RKIRKEND, this.NATJOHNS}) {
            WorkflowDocumentFactory.loadDocument((String)string, (String)document.getDocumentId()).fyi();
        }
        document.complete("completing");
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        for (String string : new String[]{this.JHOPF, this.RKIRKEND, this.NATJOHNS}) {
            document = WorkflowDocumentFactory.loadDocument((String)string, (String)document.getDocumentId());
            Assert.assertFalse((String)(this.getPrincipalNameForId(string) + " should not have an FYI"), (boolean)document.isFYIRequested());
        }
        for (String string : new String[]{this.JHOPF, initiator, this.RKIRKEND, this.NATJOHNS, this.BMCGOUGH}) {
            document = WorkflowDocumentFactory.loadDocument((String)string, (String)document.getDocumentId());
            Assert.assertTrue((String)(this.getPrincipalNameForId(string) + " should have approval request"), (boolean)document.isApprovalRequested());
            document.approve("approving");
        }
        Assert.assertTrue((String)"Document should be processed", (boolean)document.isProcessed());
        Assert.assertTrue((String)"Document should be approved", (boolean)document.isApproved());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jthomas"), (String)document.getDocumentId());
        document.fyi();
        Assert.assertTrue((String)"Document should be approved", (boolean)document.isApproved());
        Assert.assertTrue((String)"Document should be final", (boolean)document.isFinal());
    }

    public static class RecallTestDocumentTypeAuthorizer
    extends KimDocumentTypeAuthorizer {
        public static String CUSTOM_RECALL_KIM_TYPE_NAME = "Dynamic Type";
        public static String CUSTOM_RECALL_QUALIFIER_NAME = "Dynamic Qualifier";
        public static String CUSTOM_RECALL_QUALIFIER_VALUE = "Dynamic Qualifier Value";
        public static String CUSTOM_RECALL_DETAIL_NAME = "appDocStatus";
        public static String CUSTOM_RECALL_DETAIL_VALUE = "Dynamic Recall Permission Detail Value";
        public static boolean buildPermissionDetailsInvoked = false;
        public static boolean buildRoleQualifiersInvoked = false;

        protected Map<String, String> buildDocumentTypePermissionDetails(org.kuali.rice.kew.doctype.bo.DocumentType documentType, String documentStatus, String actionRequestedCode, String routeNodeName) {
            buildPermissionDetailsInvoked = true;
            Map details = super.buildDocumentTypePermissionDetails(documentType, documentStatus, actionRequestedCode, routeNodeName);
            details.put(CUSTOM_RECALL_DETAIL_NAME, CUSTOM_RECALL_DETAIL_VALUE);
            return details;
        }

        protected Map<String, String> buildDocumentRoleQualifiers(DocumentRouteHeaderValue document, String routeNodeName) {
            buildRoleQualifiersInvoked = true;
            Map qualifiers = super.buildDocumentRoleQualifiers(document, routeNodeName);
            qualifiers.put(CUSTOM_RECALL_QUALIFIER_NAME, CUSTOM_RECALL_QUALIFIER_VALUE);
            return qualifiers;
        }
    }

    public static class RecallTestPostProcessor
    extends DefaultPostProcessor {
        public static ActionType afterActionTakenType;
        public static ActionTakenEvent afterActionTakenEvent;

        public ProcessDocReport afterActionTaken(ActionType performed, ActionTakenEvent event) throws Exception {
            afterActionTakenType = performed;
            afterActionTakenEvent = event;
            return super.afterActionTaken(performed, event);
        }
    }
}

