/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.test.KEWTestCase;

public class SuperUserDisapproveTest
extends KEWTestCase {
    private static final String DOC_TYPE = "NotificationTest";
    private static final String DOC_TYPE_WITH_NOTIFY = "SUDisapproveWithNotificationTest";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testSuperUserDisapprove() throws Exception {
        this.superUserDisapprove(false);
    }

    @Test
    public void testSuperUserDisapproveWithNotification() throws Exception {
        this.superUserDisapprove(true);
    }

    protected void superUserDisapprove(boolean notify) throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)(notify ? DOC_TYPE_WITH_NOTIFY : DOC_TYPE));
        document.route("");
        WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId()).approve("");
        WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId()).approve("");
        WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId()).approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"WorkflowDocument should indicate jhopf as SuperUser", (boolean)document.isValidAction(ActionType.SU_DISAPPROVE));
        document.superUserDisapprove("");
        Assert.assertTrue((String)"Document should be final after Super User Disapprove", (boolean)document.isDisapproved());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)document.getInitiatorPrincipalId(), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId()).isAcknowledgeRequested());
    }

    @Test
    public void testSuperUserInitiatorDisapprove() throws Exception {
        this.superUserInitiatorDisapprove(false);
    }

    @Test
    public void testSuperUserInitiatorDisapproveWithNotification() throws Exception {
        this.superUserInitiatorDisapprove(true);
    }

    protected void superUserInitiatorDisapprove(boolean notify) throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)(notify ? DOC_TYPE_WITH_NOTIFY : DOC_TYPE));
        document.route("");
        WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId()).approve("");
        WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId()).approve("");
        WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId()).approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"WorkflowDocument should indicate ewestfal as SuperUser", (boolean)document.isValidAction(ActionType.SU_DISAPPROVE));
        document.superUserDisapprove("");
        Assert.assertTrue((String)"Document should be final after Super User Disapprove", (boolean)document.isDisapproved());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)document.getInitiatorPrincipalId(), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertEquals((Object)notify, (Object)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId()).isAcknowledgeRequested());
    }

    @Test
    public void testSuperUserInitiatorImmediateDisapprove() throws Exception {
        this.superUserInitiatorImmediateDisapprove(false);
    }

    @Test
    public void testSuperUserInitiatorImmediateDisapproveWithNotification() throws Exception {
        this.superUserInitiatorImmediateDisapprove(true);
    }

    protected void superUserInitiatorImmediateDisapprove(boolean notify) throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)(notify ? DOC_TYPE_WITH_NOTIFY : DOC_TYPE));
        Assert.assertTrue((String)"WorkflowDocument should indicate ewestfal as SuperUser", (boolean)document.isValidAction(ActionType.SU_DISAPPROVE));
        document.superUserDisapprove("");
        Assert.assertTrue((String)"Document should be final after Super User Disapprove", (boolean)document.isDisapproved());
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)document.getInitiatorPrincipalId(), (String)document.getDocumentId()).isAcknowledgeRequested());
        Assert.assertFalse((boolean)WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId()).isAcknowledgeRequested());
    }

    @Test
    public void testSuperUserDisapproveInvalidUser() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOC_TYPE);
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId());
        try {
            Assert.assertFalse((String)"WorkflowDocument should not indicate quickstart as SuperUser", (boolean)document.isValidAction(ActionType.SU_DISAPPROVE));
            document.superUserDisapprove("");
            Assert.fail((String)"invalid user attempted to SuperUserApprove");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

