/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.edl.impl.xml.export.EdlExportDataSet;
import org.kuali.rice.kew.batch.XmlPollerServiceImpl;
import org.kuali.rice.kew.test.KEWTestCase;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class XmlIngestionTest
extends KEWTestCase {
    private static final Logger LOG = Logger.getLogger(XmlIngestionTest.class);
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"), "XmlIngestionTest_dir");
    private static final File PENDING_DIR = new File(TMP_DIR, "pending");
    private static final File LOADED_DIR = new File(TMP_DIR, "loaded");
    private static final File PROBLEM_DIR = new File(TMP_DIR, "problem");

    public void setUp() throws Exception {
        super.setUp();
        this.deleteDirectories();
        TMP_DIR.mkdirs();
        PENDING_DIR.mkdirs();
        LOADED_DIR.mkdirs();
        PROBLEM_DIR.mkdirs();
    }

    private void deleteContentsOfDir(File dir, int depth) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() && depth > 0) {
                this.deleteContentsOfDir(file, depth - 1);
            }
            boolean success = file.delete();
            LOG.info((Object)("deleting: " + file + "..." + (success ? "succeeded" : "failed")));
        }
    }

    public void tearDown() throws Exception {
        try {
            this.deleteDirectories();
        }
        finally {
            super.tearDown();
        }
    }

    protected void deleteDirectories() {
        this.deleteContentsOfDir(PENDING_DIR, 0);
        this.deleteContentsOfDir(LOADED_DIR, 2);
        this.deleteContentsOfDir(PROBLEM_DIR, 2);
        this.deleteContentsOfDir(TMP_DIR, 0);
        TMP_DIR.delete();
    }

    protected boolean verifyFileExists(File dir, File file) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(dir.toURL() + "/**/" + file.getName());
        if (resources == null) {
            return false;
        }
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].exists()) continue;
            return true;
        }
        return false;
    }

    @Ignore
    public void testXmlReIngestion() throws Exception {
        String relativeFolder = "/src/test/resources/org/kuali/rice/kew/batch/data/";
        String filePath = this.getBaseDir() + relativeFolder + "widgetsTest.xml";
        File ingestedFile = new File(filePath);
        ArrayList<FileXmlDocCollection> collections = new ArrayList<FileXmlDocCollection>();
        FileXmlDocCollection fileDoc = new FileXmlDocCollection(ingestedFile);
        collections.add(fileDoc);
        Collection ingestedXmlFile = null;
        try {
            ingestedXmlFile = CoreApiServiceLocator.getXmlIngesterService().ingest(collections);
        }
        catch (Exception e) {
            LOG.error((Object)"Error ingesting data", (Throwable)e);
        }
        EdlExportDataSet dataSet = new EdlExportDataSet();
        List edla = EdlServiceLocator.getEDocLiteService().getEDocLiteAssociations();
        String style = null;
        for (EDocLiteAssociation edl : edla) {
            if (edl == null || !"widgetsTest".equals(style = edl.getStyle())) continue;
            dataSet.getEdocLites().add(edl);
        }
        byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
        File reingestFile = File.createTempFile("widgetsTestOutput", ".xml");
        FileUtils.writeByteArrayToFile((File)reingestFile, (byte[])xmlBytes);
        String ingestedString = FileUtils.readFileToString((File)ingestedFile);
        String reingestedString = FileUtils.readFileToString((File)reingestFile);
    }

    @Test
    public void testXmlIngestion() throws IOException {
        XmlPollerServiceImpl poller = new XmlPollerServiceImpl();
        poller.setPollIntervalSecs(1);
        poller.setXmlParentDirectory(TMP_DIR.toString());
        poller.setXmlPendingLocation(PENDING_DIR.toString());
        poller.setXmlCompletedLocation(LOADED_DIR.toString());
        poller.setXmlProblemLocation(PROBLEM_DIR.toString());
        Properties filesToIngest = new Properties();
        filesToIngest.load(((Object)((Object)this)).getClass().getResourceAsStream("XmlIngestionTest.txt"));
        LinkedList<File> pendingFiles = new LinkedList<File>();
        LinkedList<File> shouldPass = new LinkedList<File>();
        LinkedList<File> shouldFail = new LinkedList<File>();
        Iterator<Map.Entry<Object, Object>> entries = filesToIngest.entrySet().iterator();
        int i = 0;
        while (entries.hasNext()) {
            Map.Entry<Object, Object> entry = entries.next();
            String filePath = entry.getKey().toString();
            filePath = filePath.replace("${basedir}", this.getBaseDir());
            File testFile = new File(filePath);
            File pendingDir = new File(PENDING_DIR + "/TestDoc-" + i);
            Assert.assertTrue((boolean)pendingDir.mkdirs());
            Assert.assertTrue((boolean)pendingDir.isDirectory());
            File pending = new File(pendingDir, testFile.getName());
            pendingFiles.add(pending);
            if (Boolean.valueOf(entry.getValue().toString()).booleanValue()) {
                shouldPass.add(pending);
            } else {
                shouldFail.add(pending);
            }
            FileCopyUtils.copy((File)testFile, (File)pending);
            LOG.info((Object)("created: " + pending));
            ++i;
        }
        poller.run();
        for (File pending : pendingFiles) {
            Assert.assertTrue((!pending.isFile() ? 1 : 0) != 0);
        }
        for (File file : shouldPass) {
            Assert.assertTrue((String)("Loaded file " + file + " was not moved to loaded directory " + LOADED_DIR), (boolean)this.verifyFileExists(LOADED_DIR, file));
            Assert.assertFalse((String)("Loaded file " + file + " was moved to problem directory " + PROBLEM_DIR), (boolean)this.verifyFileExists(PROBLEM_DIR, file));
        }
        for (File file : shouldFail) {
            Assert.assertTrue((String)("Problem file " + file + " was not moved to problem directory" + PROBLEM_DIR), (boolean)this.verifyFileExists(PROBLEM_DIR, file));
            Assert.assertFalse((String)("Problem file " + file + " was moved to loaded directory" + LOADED_DIR), (boolean)this.verifyFileExists(LOADED_DIR, file));
        }
    }
}

