/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.document.DocumentTypeMaintainable;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DocumentTypeMaintainableTest
extends KEWTestCase {
    private void saveDocumentTypeUsingMaintainable(DocumentType documentType) throws Exception {
        DocumentTypeMaintainable docMaintainable = new DocumentTypeMaintainable();
        docMaintainable.setBoClass(DocumentType.class);
        docMaintainable.setBusinessObject((PersistableBusinessObject)documentType);
        docMaintainable.saveBusinessObject();
    }

    private void turnOnOutboxForUser(final String principalId) {
        new TransactionTemplate(KEWServiceLocator.getPlatformTransactionManager()).execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                KEWServiceLocator.getUserOptionsService().save(principalId, "USE_OUT_BOX", "yes");
                return null;
            }
        });
    }

    @Test
    public void testMaintainableSave_PreserveRouteNodes() throws Exception {
        this.loadXmlFile("DocTypeMaintainableConfig.xml");
        DocumentTypeService docTypeService = KEWServiceLocator.getDocumentTypeService();
        DocumentType documentType = docTypeService.findByName("DocumentTypeMaintainTest");
        Assert.assertEquals((String)"Wrong number of route nodes", (long)2L, (long)KEWServiceLocator.getRouteNodeService().getFlattenedNodes(documentType, false).size());
        documentType.setApplyRetroactively(null);
        this.saveDocumentTypeUsingMaintainable(documentType);
        documentType = docTypeService.findByName("DocumentTypeMaintainTest");
        Assert.assertEquals((String)"Document type should be current", (Object)Boolean.TRUE, (Object)documentType.getCurrentInd());
        List flattenedNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(documentType, false);
        Assert.assertEquals((String)"Wrong number of route nodes", (long)2L, (long)flattenedNodes.size());
    }

    @Test
    public void testApplyRetroactiveNull() throws Exception {
        this.loadXmlFile("DocTypeMaintainableConfig.xml");
        DocumentTypeService docTypeService = KEWServiceLocator.getDocumentTypeService();
        DocumentType documentType = docTypeService.findByName("DocumentTypeMaintainTest");
        documentType.setApplyRetroactively(null);
        this.saveDocumentTypeUsingMaintainable(documentType);
    }

    @Test
    public void testApplyRetroactiveSave() throws Exception {
        DocumentTypeService docTypeService = KEWServiceLocator.getDocumentTypeService();
        this.loadXmlFile("DocTypeMaintainableConfig.xml");
        this.loadXmlFile("DocTypeMaintainableConfig_Rule.xml");
        this.loadXmlFile("DocTypeMaintainableConfig.xml");
        this.loadXmlFile("DocTypeMaintainableConfig.xml");
        Assert.assertEquals((String)"Incorrect number of total document type instances for name DocumentTypeMaintainTest", (long)2L, (long)docTypeService.findPreviousInstances("DocumentTypeMaintainTest").size());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"DocumentTypeMaintainTest");
        document.route("Test Doc");
        String documentHeaderId = document.getDocumentId();
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        String userPrincipalName = "temay";
        this.turnOnOutboxForUser(this.getPrincipalIdForName(userPrincipalName));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(userPrincipalName), (String)documentHeaderId);
        TestUtilities.assertAtNode("Document should be at the first 'requests' node", document, "First Node");
        Assert.assertTrue((String)("User " + userPrincipalName + " should have approval requested."), (boolean)document.isApprovalRequested());
        document.approve("Test Approval");
        Assert.assertEquals((String)"There should be an outbox item", (long)1L, (long)KEWServiceLocator.getActionListService().getOutbox(this.getPrincipalIdForName(userPrincipalName), new ActionListFilter()).size());
        TestUtilities.assertNotInActionList(this.getPrincipalIdForName(userPrincipalName), documentHeaderId);
        userPrincipalName = "delyea";
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(userPrincipalName), (String)documentHeaderId);
        Assert.assertTrue((String)("User " + userPrincipalName + " should have approval requested."), (boolean)document.isApprovalRequested());
        TestUtilities.assertInActionList(this.getPrincipalIdForName(userPrincipalName), documentHeaderId);
        DocumentType documentType = docTypeService.findByName("DocumentTypeMaintainTest");
        documentType.setApplyRetroactively(Boolean.TRUE);
        String new_description = "Maintainable Test Document Type Description";
        documentType.setDescription(new_description);
        String new_label = "Maintainable Test Document Label";
        documentType.setLabel(new_label);
        String new_help_def_url = "http://test.kuali.org/helpdefinition";
        documentType.setUnresolvedHelpDefinitionUrl(new_help_def_url);
        this.saveDocumentTypeUsingMaintainable(documentType);
        for (DocumentType docTypeInstance : docTypeService.findPreviousInstances("DocumentTypeMaintainTest")) {
            Assert.assertEquals((String)"Label should have been applied retroactively to former document type versions", (Object)new_label, (Object)docTypeInstance.getLabel());
            Assert.assertEquals((String)"Description should have been applied retroactively to former document type versions", (Object)new_description, (Object)docTypeInstance.getDescription());
            Assert.assertEquals((String)"Unresolved Help Definition URL should have been applied retroactively to former document type versions", (Object)new_help_def_url, (Object)docTypeInstance.getUnresolvedHelpDefinitionUrl());
        }
        userPrincipalName = "temay";
        Collection outboxItems = KEWServiceLocator.getActionListService().getOutbox(this.getPrincipalIdForName(userPrincipalName), new ActionListFilter());
        Assert.assertEquals((String)"There should be one outbox item", (long)1L, (long)outboxItems.size());
        ActionItem outboxItem = (ActionItem)outboxItems.iterator().next();
        Assert.assertEquals((String)"The label on the outbox item should have been changed", (Object)new_label, (Object)outboxItem.getDocLabel());
        userPrincipalName = "delyea";
        Collection actionList = KEWServiceLocator.getActionListService().findByPrincipalId(this.getPrincipalIdForName(userPrincipalName));
        Assert.assertEquals((String)"There should be one action item", (long)1L, (long)actionList.size());
        ActionItem actionItem = (ActionItem)actionList.iterator().next();
        Assert.assertEquals((String)"The label on the action item should have been changed", (Object)new_label, (Object)actionItem.getDocLabel());
    }

    @Test
    public void testParentDocumentChanges() throws Exception {
        this.loadXmlFile("DocTypeMaintainableConfig.xml");
        this.loadXmlFile("DocTypeMaintainableConfig_Rule.xml");
    }

    private class TemporaryDocumentType {
        public static final String NAME = "DocumentTypeMaintainTest";
        public static final String DESCRIPTION = "Document Type Maintainable Test";
        public static final String LABEL = "Document Type Maintainable Test";
        public static final String POST_PROCESSOR_CLASS_NAME = "org.kuali.rice.kew.postprocessor.DefaultPostProcessor";
        public static final String DOC_HANDLER_URL = "http://localhost/dochandler";
        public static final String HELP_DEFINITION_URL = "http://localhost/helpdefinition";
        public static final String START_NODE_NAME = "AdHoc";
        public static final String FIRST_NODE_NAME = "First Node";
        public static final String FIRST_NODE_APPROVER_1 = "temay";
        public static final String FIRST_NODE_APPROVER_2 = "delyea";

        private TemporaryDocumentType() {
        }
    }
}

