/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowAttributeBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowDelegateBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowMemberBo;
import org.kuali.rice.kew.impl.type.KewAttributeDefinitionBo;
import org.kuali.rice.kew.impl.type.KewTypeAttributeBo;
import org.kuali.rice.kew.impl.type.KewTypeBo;
import org.kuali.rice.kew.responsibility.service.ResponsibilityIdService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class PeopleFlowBoTest
extends KEWTestCase {
    private BusinessObjectService boService;
    private ResponsibilityIdService responsibilityIdService;

    @Before
    public void setupBoService() {
        this.boService = KRADServiceLocator.getBusinessObjectService();
        this.responsibilityIdService = KEWServiceLocator.getResponsibilityIdService();
    }

    @Test(expected=Throwable.class)
    public void testKewTypeBoBasicPersist() {
        KewTypeBoBuilder builder = new KewTypeBoBuilder("testType", "testNamespace");
        this.boService.save((PersistableBusinessObject)builder.build());
        this.boService.save((PersistableBusinessObject)builder.build());
    }

    @Test
    public void testKewTypeBoFullPersist() {
        KewTypeBoBuilder builder = new KewTypeBoBuilder("testType", "testNamespace").setServiceName("testService");
        KewTypeBo kewTypeBo = builder.build();
        for (int i = 1; i <= 3; ++i) {
            KewAttributeDefinitionBo attributeDefn = new KewAttributeDefinitionBo();
            attributeDefn.setName("attrDef" + i);
            attributeDefn.setDescription("this is a description of attrDef" + i);
            attributeDefn.setComponentName("componentName" + i);
            attributeDefn.setLabel("label" + i);
            attributeDefn.setNamespace(kewTypeBo.getNamespace());
            this.boService.save((PersistableBusinessObject)attributeDefn);
            KewTypeAttributeBo typeAttribute = new KewTypeAttributeBo();
            typeAttribute.setSequenceNumber(Integer.valueOf(i));
            typeAttribute.setAttributeDefinition(attributeDefn);
            kewTypeBo.getAttributes().add(typeAttribute);
        }
        this.boService.save((PersistableBusinessObject)kewTypeBo);
    }

    @Test
    public void testPeopleFlowPersonMembers() {
        PeopleFlowMemberBo peopleFlowMember = new PeopleFlowMemberBo();
        peopleFlowMember.setMemberType(MemberType.PRINCIPAL);
        peopleFlowMember.setMemberId("admin");
        peopleFlowMember.setPriority(1);
        peopleFlowMember.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
        Assert.assertNotNull((Object)peopleFlowMember.getPerson());
        Assert.assertEquals((Object)"admin", (Object)peopleFlowMember.getPerson().getPrincipalName());
        PeopleFlowDelegateBo peopleFlowDelegate = new PeopleFlowDelegateBo();
        peopleFlowDelegate.setMemberType(MemberType.PRINCIPAL);
        peopleFlowDelegate.setMemberId("admin");
        peopleFlowDelegate.setDelegationTypeCode(DelegationType.PRIMARY.getCode());
        peopleFlowDelegate.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
        Assert.assertNotNull((Object)peopleFlowDelegate.getPerson());
        Assert.assertEquals((Object)"admin", (Object)peopleFlowDelegate.getPerson().getPrincipalName());
    }

    @Test
    public void testPeopleFlowBoPersist() {
        this.testKewTypeBoFullPersist();
        HashMap<String, String> keysMap = new HashMap<String, String>();
        keysMap.put("name", "testType");
        keysMap.put("namespace", "testNamespace");
        KewTypeBo kewTypeBo = (KewTypeBo)this.boService.findByPrimaryKey(KewTypeBo.class, keysMap);
        PeopleFlowBo peopleFlowBo = new PeopleFlowBo();
        peopleFlowBo.setDescription("description of testPeopleFlow");
        peopleFlowBo.setName("testPeopleFlow");
        peopleFlowBo.setNamespaceCode("testNamespace");
        peopleFlowBo.setTypeId(kewTypeBo.getId());
        this.boService.save((PersistableBusinessObject)peopleFlowBo);
        KewTypeAttributeBo attribute = (KewTypeAttributeBo)kewTypeBo.getAttributes().get(0);
        PeopleFlowAttributeBo peopleFlowAttr = new PeopleFlowAttributeBo();
        peopleFlowAttr.setAttributeDefinition(attribute.getAttributeDefinition());
        peopleFlowAttr.setPeopleFlowId(peopleFlowBo.getId());
        peopleFlowAttr.setValue("testAttrValue");
        peopleFlowBo.getAttributeBos().add(peopleFlowAttr);
        PeopleFlowMemberBo peopleFlowMember = new PeopleFlowMemberBo();
        peopleFlowMember.setMemberType(MemberType.PRINCIPAL);
        peopleFlowMember.setMemberId("admin");
        peopleFlowMember.setPriority(1);
        peopleFlowMember.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
        peopleFlowBo.getMembers().add(peopleFlowMember);
        PeopleFlowDelegateBo peopleFlowDelegate1 = new PeopleFlowDelegateBo();
        peopleFlowDelegate1.setMemberType(MemberType.GROUP);
        peopleFlowDelegate1.setMemberId("1");
        peopleFlowDelegate1.setDelegationTypeCode(DelegationType.PRIMARY.getCode());
        peopleFlowDelegate1.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
        peopleFlowMember.getDelegates().add(peopleFlowDelegate1);
        PeopleFlowDelegateBo peopleFlowDelegate2 = new PeopleFlowDelegateBo();
        peopleFlowDelegate2.setMemberType(MemberType.ROLE);
        peopleFlowDelegate2.setMemberId("2");
        peopleFlowDelegate2.setActionRequestPolicyCode(ActionRequestPolicy.FIRST.getCode());
        peopleFlowDelegate2.setDelegationTypeCode(DelegationType.SECONDARY.getCode());
        peopleFlowDelegate2.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
        peopleFlowMember.getDelegates().add(peopleFlowDelegate2);
        this.boService.save((PersistableBusinessObject)peopleFlowBo);
        Assert.assertNotNull((Object)peopleFlowBo.getId());
        peopleFlowBo = (PeopleFlowBo)this.boService.findBySinglePrimaryKey(PeopleFlowBo.class, (Object)peopleFlowBo.getId());
        Assert.assertNotNull((Object)peopleFlowBo);
        Assert.assertNotNull((Object)peopleFlowBo.getId());
        Assert.assertTrue((peopleFlowBo.getMembers().size() == 1 ? 1 : 0) != 0);
        PeopleFlowMemberBo memberBo = (PeopleFlowMemberBo)peopleFlowBo.getMembers().get(0);
        Assert.assertNotNull((Object)memberBo.getId());
        Assert.assertEquals((Object)peopleFlowBo.getId(), (Object)memberBo.getPeopleFlowId());
        Assert.assertEquals((Object)"admin", (Object)memberBo.getMemberId());
        Assert.assertEquals((Object)MemberType.PRINCIPAL, (Object)memberBo.getMemberType());
        Assert.assertNotNull((Object)memberBo.getPerson());
        Assert.assertEquals((Object)"admin", (Object)memberBo.getPerson().getPrincipalName());
        Assert.assertEquals((Object)peopleFlowMember.getResponsibilityId(), (Object)memberBo.getResponsibilityId());
        Assert.assertSame((Object)1, (Object)memberBo.getPriority());
        Assert.assertTrue((memberBo.getDelegates().size() == 2 ? 1 : 0) != 0);
        PeopleFlowDelegateBo delegateBo1 = (PeopleFlowDelegateBo)memberBo.getDelegates().get(0);
        Assert.assertNotNull((Object)delegateBo1.getId());
        Assert.assertEquals((Object)memberBo.getId(), (Object)delegateBo1.getPeopleFlowMemberId());
        Assert.assertEquals((Object)"1", (Object)delegateBo1.getMemberId());
        Assert.assertEquals((Object)MemberType.GROUP, (Object)delegateBo1.getMemberType());
        Assert.assertEquals((Object)DelegationType.PRIMARY.getCode(), (Object)delegateBo1.getDelegationTypeCode());
        Assert.assertEquals((Object)peopleFlowDelegate1.getResponsibilityId(), (Object)delegateBo1.getResponsibilityId());
        Assert.assertNull((Object)delegateBo1.getActionRequestPolicyCode());
        PeopleFlowDelegateBo delegateBo2 = (PeopleFlowDelegateBo)memberBo.getDelegates().get(1);
        Assert.assertNotNull((Object)delegateBo2.getId());
        Assert.assertEquals((Object)memberBo.getId(), (Object)delegateBo2.getPeopleFlowMemberId());
        Assert.assertEquals((Object)"2", (Object)delegateBo2.getMemberId());
        Assert.assertEquals((Object)MemberType.ROLE, (Object)delegateBo2.getMemberType());
        Assert.assertEquals((Object)DelegationType.SECONDARY.getCode(), (Object)delegateBo2.getDelegationTypeCode());
        Assert.assertEquals((Object)peopleFlowDelegate2.getResponsibilityId(), (Object)delegateBo2.getResponsibilityId());
        Assert.assertEquals((Object)ActionRequestPolicy.FIRST.getCode(), (Object)delegateBo2.getActionRequestPolicyCode());
    }

    public static KewTypeBo buildMinimalKewTypeBo() {
        KewTypeBo kewTypeBo = new KewTypeBo();
        kewTypeBo.setName("TestType");
        kewTypeBo.setNamespace("TestNamespace");
        return kewTypeBo;
    }

    private static class KewTypeBoBuilder {
        private boolean active = true;
        private String name;
        private String namespace;
        private String serviceName;

        public KewTypeBoBuilder(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public KewTypeBoBuilder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public KewTypeBoBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public KewTypeBoBuilder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public KewTypeBoBuilder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public KewTypeBo build() {
            KewTypeBo kewTypeBo = new KewTypeBo();
            kewTypeBo.setActive(this.active);
            kewTypeBo.setName(this.name);
            kewTypeBo.setNamespace(this.namespace);
            kewTypeBo.setServiceName(this.serviceName);
            return kewTypeBo;
        }
    }
}

