/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.kew.plugin.PluginConfig;
import org.kuali.rice.kew.plugin.PluginConfigParser;
import org.kuali.rice.kew.test.KEWTestCase;

public class PluginConfigParserTest
extends KEWTestCase {
    private PluginConfigParser parser = new PluginConfigParser();
    private static final String CONFIG_PATH_SUFFIX = "/src/test/resources/org/kuali/rice/kew/plugin/workflow.xml";

    @Test
    public void testParse() throws Exception {
        PluginConfig plugin = this.parser.parse(new File(this.getBaseDir() + CONFIG_PATH_SUFFIX), ConfigContext.getCurrentContextConfig());
        Assert.assertNotNull((Object)plugin);
        List listeners = plugin.getListeners();
        Assert.assertNotNull((Object)listeners);
        Assert.assertEquals((long)2L, (long)listeners.size());
        String listenerClassName1 = (String)listeners.get(0);
        String listenerClassName2 = (String)listeners.get(1);
        Assert.assertEquals((Object)"org.kuali.rice.kew.plugin.TestPluginListener", (Object)listenerClassName1);
        Assert.assertEquals((Object)"org.kuali.rice.kew.plugin.TestPluginListener2", (Object)listenerClassName2);
        Assert.assertEquals((String)"Plugin resource loader classname should be base resource loader", (Object)BaseResourceLoader.class.getName(), (Object)plugin.getResourceLoaderClassname());
    }
}

