/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.quicklinks;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.quicklinks.ActionListStats;
import org.kuali.rice.kew.quicklinks.InitiatedDocumentType;
import org.kuali.rice.kew.quicklinks.WatchedDocument;
import org.kuali.rice.kew.quicklinks.service.QuickLinksService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.SQLDataLoader;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class QuickLinksServiceTest
extends KEWTestCase {
    private static String principalId = "admin";
    private static String badPrincipalId = "joeshmoe";
    private QuickLinksService service;

    @Override
    protected void loadTestData() throws Exception {
        new SQLDataLoader("classpath:org/kuali/rice/kew/quicklinks/actionItem.sql", ";").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kew/quicklinks/documentRoute.sql", ";").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kew/quicklinks/documentType.sql", ";").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kew/quicklinks/userOption.sql", ";").runSql();
    }

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        this.service = (QuickLinksService)KEWServiceLocator.getService((String)"enQuickLinksService");
    }

    @Test
    public void testGetActionListStats() {
        List actionListStats = this.service.getActionListStats(principalId);
        Assert.assertNotNull((String)"No collection returned", (Object)actionListStats);
        Assert.assertTrue((String)"No test data", (actionListStats.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong number of Action List Stats", (long)3L, (long)actionListStats.size());
        ActionListStats als = (ActionListStats)actionListStats.get(0);
        Assert.assertEquals((String)"Wrong count", (long)1L, (long)als.getCount());
        Assert.assertEquals((String)"Wrong Type Label", (Object)"Add/modify EDEN workgroup", (Object)als.getDocumentTypeLabelText());
        Assert.assertEquals((String)"Wrong Type name", (Object)"EDENSERVICE-DOCS.WKGRPREQ", (Object)als.getDocumentTypeName());
        als = (ActionListStats)actionListStats.get(2);
        Assert.assertEquals((String)"Wrong count", (long)4L, (long)als.getCount());
        Assert.assertEquals((String)"Wrong Type Label", (Object)"Travel Request", (Object)als.getDocumentTypeLabelText());
        Assert.assertEquals((String)"Wrong Type name", (Object)"TravelRequest", (Object)als.getDocumentTypeName());
        actionListStats = this.service.getActionListStats(badPrincipalId);
        Assert.assertNotNull((String)"No collection returned", (Object)actionListStats);
        Assert.assertFalse((String)"Found test data", (actionListStats.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetWatchedDocuments() {
        List watchedDocuments = this.service.getWatchedDocuments(principalId);
        Assert.assertNotNull((String)"No collection returned", (Object)watchedDocuments);
        Assert.assertTrue((String)"No test data", (watchedDocuments.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong number of Watched Documents", (long)28L, (long)watchedDocuments.size());
        WatchedDocument wd = (WatchedDocument)watchedDocuments.get(0);
        Assert.assertEquals((String)"Wrong header id", (Object)"2694", (Object)wd.getDocumentHeaderId());
        Assert.assertEquals((String)"Wrong status code", (Object)"ENROUTE", (Object)wd.getDocumentStatusCode());
        Assert.assertEquals((String)"Wrong document title", (Object)"Travel Doc 2 - esdf", (Object)wd.getDocumentTitle());
        wd = (WatchedDocument)watchedDocuments.get(27);
        Assert.assertEquals((String)"Wrong header id", (Object)"2120", (Object)wd.getDocumentHeaderId());
        Assert.assertEquals((String)"Wrong status code", (Object)"ENROUTE", (Object)wd.getDocumentStatusCode());
        Assert.assertEquals((String)"Wrong document title", (Object)"Routing workgroup CreatinAGroup123", (Object)wd.getDocumentTitle());
        watchedDocuments = this.service.getWatchedDocuments(badPrincipalId);
        Assert.assertNotNull((String)"No collection returned", (Object)watchedDocuments);
        Assert.assertFalse((String)"Found test data", (watchedDocuments.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetRecentSearches() {
        SimpleDateFormat df = new SimpleDateFormat("'Created='MM/dd/yyyy'..;'");
        List recentSearches = this.service.getRecentSearches(principalId);
        Assert.assertNotNull((String)"No collection returned", (Object)recentSearches);
        Assert.assertTrue((String)"No test data", (recentSearches.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong number of Recent Searches", (long)5L, (long)recentSearches.size());
        KeyValue kv = (KeyValue)recentSearches.get(0);
        Assert.assertEquals((String)"Wrong key", (Object)"DocSearch.LastSearch.Holding4", (Object)kv.getKey());
        Assert.assertEquals((String)"Wrong value", (Object)df.format(new Date(1229925600000L)), (Object)kv.getValue().trim());
        kv = (KeyValue)recentSearches.get(4);
        Assert.assertEquals((String)"Wrong key", (Object)"DocSearch.LastSearch.Holding0", (Object)kv.getKey());
        Assert.assertEquals((String)"Wrong value", (Object)df.format(new Date(1225778400000L)), (Object)kv.getValue().trim());
        recentSearches = this.service.getRecentSearches(badPrincipalId);
        Assert.assertNotNull((String)"No collection returned", (Object)recentSearches);
        Assert.assertFalse((String)"Found test data", (recentSearches.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNamedSearches() {
        List namedSearches = this.service.getNamedSearches(principalId);
        Assert.assertNotNull((String)"No collection returned", (Object)namedSearches);
        Assert.assertTrue((String)"No test data", (namedSearches.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong number of Named Searches", (long)3L, (long)namedSearches.size());
        KeyValue kv = (KeyValue)namedSearches.get(0);
        Assert.assertEquals((String)"Wrong key", (Object)"DocSearch.NamedSearch.FindAlumni", (Object)kv.getKey());
        Assert.assertEquals((String)"Wrong value", (Object)"FindAlumni", (Object)kv.getValue());
        kv = (KeyValue)namedSearches.get(2);
        Assert.assertEquals((String)"Wrong key", (Object)"DocSearch.NamedSearch.FindStudent", (Object)kv.getKey());
        Assert.assertEquals((String)"Wrong value", (Object)"FindStudent", (Object)kv.getValue());
        namedSearches = this.service.getRecentSearches(badPrincipalId);
        Assert.assertNotNull((String)"No collection returned", (Object)namedSearches);
        Assert.assertFalse((String)"Found test data", (namedSearches.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetInitiatedDocumentTypesList() {
        List initiatedDocumentTypesList = this.service.getInitiatedDocumentTypesList(principalId);
        Assert.assertNotNull((String)"No collection returned", (Object)initiatedDocumentTypesList);
        Assert.assertTrue((String)"No test data", (initiatedDocumentTypesList.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong number of Document Types List", (long)8L, (long)initiatedDocumentTypesList.size());
        InitiatedDocumentType idt = (InitiatedDocumentType)initiatedDocumentTypesList.get(0);
        Assert.assertEquals((String)"Wrong Type Label Text", (Object)"Add/modify EDEN workgroup", (Object)idt.getDocumentTypeLabelText());
        Assert.assertEquals((String)"Wrong Type Name", (Object)"EDENSERVICE-DOCS.WKGRPREQ", (Object)idt.getDocumentTypeName());
        idt = (InitiatedDocumentType)initiatedDocumentTypesList.get(7);
        Assert.assertEquals((String)"Wrong Type Label Text", (Object)"Travel Request", (Object)idt.getDocumentTypeLabelText());
        Assert.assertEquals((String)"Wrong Type Name", (Object)"TravelRequest", (Object)idt.getDocumentTypeName());
        initiatedDocumentTypesList = this.service.getInitiatedDocumentTypesList(badPrincipalId);
        Assert.assertNotNull((String)"No collection returned", (Object)initiatedDocumentTypesList);
        Assert.assertFalse((String)"Found test data", (initiatedDocumentTypesList.size() > 0 ? 1 : 0) != 0);
    }
}

