/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.LockingException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RouteHeaderServiceTest
extends KEWTestCase {
    private Object lock = new Object();
    private RouteHeaderService routeHeaderService;

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        this.routeHeaderService = KEWServiceLocator.getRouteHeaderService();
    }

    @Test
    public void testLargeDocumentContent() throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<content>");
        for (int index = 0; index < 10000; ++index) {
            buffer.append("abcdefghijklmnopqrstuvwxyz");
        }
        buffer.append("</content>");
        DocumentRouteHeaderValue document = new DocumentRouteHeaderValue();
        document.setDocContent(buffer.toString());
        document.setDocRouteStatus("I");
        document.setDocRouteLevel(Integer.valueOf(0));
        document.setDateModified(new Timestamp(System.currentTimeMillis()));
        document.setCreateDate(new Timestamp(System.currentTimeMillis()));
        document.setInitiatorWorkflowId("1");
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("TestDocumentType");
        Assert.assertNotNull((Object)documentType);
        document.setDocumentTypeId(documentType.getDocumentTypeId());
        this.routeHeaderService.saveRouteHeader(document);
        Assert.assertNotNull((String)"Document was saved, it should have an ID now.", (Object)document.getDocumentId());
        document = this.routeHeaderService.getRouteHeader(document.getDocumentId());
        String docContent = document.getDocContent();
        Assert.assertEquals((String)"Doc content should be the same size as original string buffer.", (long)buffer.length(), (long)docContent.length());
        Assert.assertTrue((String)"Should be greater than about 5000 bytes.", (docContent.getBytes().length > 5000 ? 1 : 0) != 0);
    }

    @Test
    public void testGetApplicationIdByDocumentId() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType2");
        String documentId = document.getDocumentId();
        String applicationId = this.routeHeaderService.getApplicationIdByDocumentId(documentId);
        Assert.assertEquals((String)"applicationId should be KEWNEW", (Object)"KEWNEW", (Object)applicationId);
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        documentId = document.getDocumentId();
        applicationId = this.routeHeaderService.getApplicationIdByDocumentId(documentId);
        Assert.assertEquals((String)"applicationId should be KUALI", (Object)"KUALI", (Object)applicationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockRouteHeader() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        document.saveDocumentData();
        String documentId = document.getDocumentId();
        Locker locker = null;
        Object object = this.lock;
        synchronized (object) {
            locker = new Locker(documentId);
            locker.start();
            this.lock.wait();
        }
        try {
            this.routeHeaderService.lockRouteHeader(documentId, false);
            Assert.fail((String)"The route header should be locked.");
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        locker.join();
        this.routeHeaderService.lockRouteHeader(documentId, false);
        Assert.assertTrue((String)"Locker thread should have completed.", (boolean)locker.isCompleted());
        ConfigContext.getCurrentContextConfig().putProperty("document.lock.timeout", "2");
        object = this.lock;
        synchronized (object) {
            locker = new Locker(documentId);
            locker.start();
            this.lock.wait();
        }
        long millisStart = System.currentTimeMillis();
        try {
            this.routeHeaderService.lockRouteHeader(documentId, true);
            Assert.fail((String)"The route header should be locked.");
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
        long millisEnd = System.currentTimeMillis();
        long timeLocked = millisEnd - millisStart;
        Object object2 = this.lock;
        synchronized (object2) {
            this.lock.notify();
        }
        locker.join();
        this.routeHeaderService.lockRouteHeader(document.getDocumentId(), false);
        Assert.assertTrue((String)"Locker thread should have completed.", (boolean)locker.isCompleted());
    }

    private class Locker
    extends Thread {
        private String documentId;
        private boolean isCompleted = false;

        public Locker(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public void run() {
            RouteHeaderServiceTest.this.getTransactionTemplate().execute(new TransactionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus status) {
                    Object object = RouteHeaderServiceTest.this.lock;
                    synchronized (object) {
                        RouteHeaderServiceTest.this.routeHeaderService.lockRouteHeader(Locker.this.documentId, true);
                        try {
                            RouteHeaderServiceTest.this.lock.notify();
                            RouteHeaderServiceTest.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            Assert.fail((String)"Shouldn't have been interrupted");
                        }
                    }
                    return null;
                }
            });
            this.isCompleted = true;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }
    }
}

