/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import mocks.MockDocumentRefreshQueueImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.RuleTestUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class AddRuleDelegationTest
extends KEWTestCase {
    private static final String DELEGATE_USER = "user2";
    private static final String DELEGATE_USER2 = "pmckown";
    private static final String DOCTYPE = "AddDelegationTest_DocType";
    private static final String RULE_TEMPLATE = "AddDelegationTest_RuleTemplate";
    private static final String DELEGATION_TEMPLATE = "AddDelegationTest_DelegationTemplate";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("AddRuleDelegationTestData.xml");
    }

    @Test
    public void testNewDelegationTriggersRequeue() throws Exception {
        String docType = "RiceDocument.testNewDelegationTriggersRequeue";
        WorkflowDocument wd = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCTYPE);
        wd.route("");
        MockDocumentRefreshQueueImpl.clearRequeuedDocumentIds();
        RuleTestUtils.createDelegationToUser(DOCTYPE, RULE_TEMPLATE, DELEGATE_USER);
        Assert.assertTrue((String)"our document should have been requeued!", (boolean)MockDocumentRefreshQueueImpl.getRequeuedDocumentIds().contains(wd.getDocumentId()));
    }

    @Test
    public void testAddRuleDelegation() throws Exception {
        RuleBaseValues originalRule = RuleTestUtils.getRule(DOCTYPE, RULE_TEMPLATE);
        List originalResps = originalRule.getRuleResponsibilities();
        Assert.assertTrue((String)"assuming there is 1 responsibility", (originalResps != null && originalResps.size() == 1 ? 1 : 0) != 0);
        RuleResponsibilityBo originalResp = (RuleResponsibilityBo)originalResps.get(0);
        RuleTestUtils.createDelegationToUser(DOCTYPE, RULE_TEMPLATE, DELEGATE_USER);
        Principal principal2 = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(DELEGATE_USER);
        originalRule = KEWServiceLocator.getRuleService().findRuleBaseValuesById(originalRule.getId());
        Assert.assertTrue((String)"Original rule should be current.", (boolean)originalRule.getCurrentInd());
        List responsibilities = originalRule.getRuleResponsibilities();
        originalResp = (RuleResponsibilityBo)responsibilities.get(0);
        Assert.assertEquals((String)"Original rule should have 1 delegation now.", (long)1L, (long)originalResp.getDelegationRules().size());
        List newRuleDelegations = KEWServiceLocator.getRuleDelegationService().findByResponsibilityId(originalResp.getResponsibilityId());
        Assert.assertEquals((String)"Should be 1 delegation", (long)1L, (long)newRuleDelegations.size());
        RuleDelegationBo newRuleDelegation = (RuleDelegationBo)newRuleDelegations.get(0);
        Assert.assertEquals((String)"Incorrect responsibility id", (Object)originalResp.getResponsibilityId(), (Object)newRuleDelegation.getResponsibilityId());
        Assert.assertNotNull((String)"Name should not be null", (Object)newRuleDelegation.getDelegationRule().getName());
        Assert.assertTrue((String)"delegate rule should be current", (boolean)newRuleDelegation.getDelegationRule().getCurrentInd());
        Assert.assertTrue((String)"delegate rule should be flagged as a delegate", (boolean)newRuleDelegation.getDelegationRule().getDelegateRule());
        Assert.assertEquals((String)"Should have 1 responsibility", (long)1L, (long)newRuleDelegation.getDelegationRule().getRuleResponsibilities().size());
        Assert.assertEquals((String)"Incorrect responsibility name", (Object)principal2.getPrincipalId(), (Object)((RuleResponsibilityBo)newRuleDelegation.getDelegationRule().getRuleResponsibilities().get(0)).getRuleResponsibilityName());
        Assert.assertEquals((String)"Incorrect responsibility type", (Object)"F", (Object)((RuleResponsibilityBo)newRuleDelegation.getDelegationRule().getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Incorrect delegation type", (Object)DelegationType.PRIMARY, (Object)newRuleDelegation.getDelegationType());
        Principal delegatePrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(DELEGATE_USER2);
        RuleTestUtils.createRuleDelegationToUser(originalRule, originalResp, (PrincipalContract)delegatePrincipal);
        List ruleDelegations = KEWServiceLocator.getRuleDelegationService().findByResponsibilityId(originalResp.getResponsibilityId());
        Assert.assertEquals((String)"There should be 2 delegation rules", (long)2L, (long)ruleDelegations.size());
        boolean foundFirstDelegateRule = false;
        for (RuleDelegationBo ruleDelegation : ruleDelegations) {
            if (ruleDelegation.getRuleDelegationId().equals(newRuleDelegation.getRuleDelegationId())) {
                foundFirstDelegateRule = true;
                Assert.assertEquals((String)"Rule Version should not have changed.", (Object)ruleDelegation.getVersionNumber(), (Object)newRuleDelegation.getVersionNumber());
                continue;
            }
            Assert.assertEquals((String)"Incorrect responsibility id", (Object)originalResp.getResponsibilityId(), (Object)ruleDelegation.getResponsibilityId());
            Assert.assertNotNull((String)"Name should not be null", (Object)ruleDelegation.getDelegationRule().getName());
            Assert.assertTrue((String)"delegate rule should be current", (boolean)ruleDelegation.getDelegationRule().getCurrentInd());
            Assert.assertTrue((String)"delegate rule should be flagged as a delegate", (boolean)ruleDelegation.getDelegationRule().getDelegateRule());
            Assert.assertEquals((String)"Should have 1 responsibility", (long)1L, (long)ruleDelegation.getDelegationRule().getRuleResponsibilities().size());
            Assert.assertEquals((String)"Incorrect responsibility name", (Object)delegatePrincipal.getPrincipalId(), (Object)((RuleResponsibilityBo)ruleDelegation.getDelegationRule().getRuleResponsibilities().get(0)).getRuleResponsibilityName());
            Assert.assertEquals((String)"Incorrect responsibility type", (Object)"F", (Object)((RuleResponsibilityBo)ruleDelegation.getDelegationRule().getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        }
        Assert.assertTrue((String)"Failed to find the first delegate rule", (boolean)foundFirstDelegateRule);
        String newRuleDelegationId = newRuleDelegation.getRuleDelegationId();
        newRuleDelegation.setDelegationType(DelegationType.SECONDARY);
        this.saveNewVersion(newRuleDelegation);
        String newRuleDelegationId2 = newRuleDelegation.getRuleDelegationId();
        newRuleDelegation = KEWServiceLocator.getRuleDelegationService().findByRuleDelegationId(newRuleDelegationId);
        Assert.assertNotNull((Object)newRuleDelegation);
        Assert.assertFalse((String)"Rule delegation should no longer be current.", (boolean)newRuleDelegation.getDelegationRule().getCurrentInd());
        ruleDelegations = KEWServiceLocator.getRuleDelegationService().findByResponsibilityId(originalResp.getResponsibilityId());
        Assert.assertEquals((String)"There should be 2 delegation rules", (long)2L, (long)ruleDelegations.size());
        boolean foundReversionedDelegateRule = false;
        for (RuleDelegationBo ruleDelegation : ruleDelegations) {
            if (!ruleDelegation.getRuleDelegationId().equals(newRuleDelegationId2)) continue;
            foundReversionedDelegateRule = true;
            Assert.assertEquals((String)"Previous version relationship should be set up now", (Object)newRuleDelegation.getDelegationRule().getId(), (Object)ruleDelegation.getDelegationRule().getPreviousRuleId());
            Assert.assertEquals((String)"Rule Version should have been incremented.", (Object)(newRuleDelegation.getVersionNumber() + 1L), (Object)ruleDelegation.getVersionNumber());
        }
        Assert.assertTrue((String)"Failed to find the reversioned delegate rule", (boolean)foundReversionedDelegateRule);
    }

    private void saveNewVersion(RuleDelegationBo ruleDelegation) {
        ruleDelegation.setRuleDelegationId(null);
        ruleDelegation.setDelegateRuleId(null);
        ruleDelegation.setObjectId(null);
        for (RuleResponsibilityBo ruleResponsibility : ruleDelegation.getDelegationRule().getRuleResponsibilities()) {
            ruleResponsibility.setRuleBaseValuesId(null);
            ruleResponsibility.setResponsibilityId(null);
            ruleResponsibility.setId(null);
            ruleResponsibility.setObjectId(null);
        }
        KEWServiceLocator.getRuleService().saveRuleDelegation(ruleDelegation, true);
    }
}

