/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.rule.TestRuleValidationAttribute;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class RuleTemplateAttributeTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RuleTemplateAttributeTestConfig.xml");
    }

    @Test
    public void testGetWorkflowAttribute() throws Exception {
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName("TemplateWithRuleValidationAttribute");
        List ruleTemplateAttributes = template.getRuleTemplateAttributes();
        int index = 0;
        for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplateAttributes) {
            boolean runtimeThrown = false;
            WorkflowRuleAttribute attribute = null;
            try {
                attribute = ruleTemplateAttribute.getWorkflowAttribute();
            }
            catch (RuntimeException e) {
                runtimeThrown = true;
            }
            if (index == 0) {
                Assert.assertFalse((String)"RuntimeException should not have been thrown.", (boolean)runtimeThrown);
                Assert.assertNotNull((String)"Attribute should exist.", (Object)attribute);
                attribute = (WorkflowRuleAttribute)ClassLoaderUtils.unwrapFromProxy((Object)attribute);
                Assert.assertEquals((String)"Should be TestRuleAttribute", TestRuleAttribute.class, attribute.getClass());
            } else if (index == 1) {
                Assert.assertTrue((String)"RuntimeException should have been thrown.", (boolean)runtimeThrown);
                Assert.assertNull((String)"This should be the rule delegation attribute, not a WorkflowAttribute.", (Object)attribute);
            }
            ++index;
        }
    }

    @Test
    public void testIsWorkflowAttribute() throws Exception {
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName("TemplateWithRuleValidationAttribute");
        List ruleTemplateAttributes = template.getRuleTemplateAttributes();
        int index = 0;
        for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplateAttributes) {
            boolean isWorkflowAttribute = ruleTemplateAttribute.isWorkflowAttribute();
            Object attribute = ruleTemplateAttribute.getAttribute();
            attribute = ClassLoaderUtils.unwrapFromProxy((Object)attribute);
            if (index == 0) {
                Assert.assertNotNull((Object)attribute);
                Assert.assertEquals((String)"Should be TestRuleAttribute", TestRuleAttribute.class, attribute.getClass());
                Assert.assertTrue((String)"TestRuleAttribute is a workflow attribute.", (boolean)isWorkflowAttribute);
            } else if (index == 1) {
                Assert.assertEquals((String)"Should be TestRuleValidationAttribute", TestRuleValidationAttribute.class, attribute.getClass());
                Assert.assertFalse((String)"TestRuleValidationAttribute is not a workflow attribute", (boolean)isWorkflowAttribute);
            }
            ++index;
        }
    }
}

