/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.actionrequest.bo.RuleMaintenanceActionRequestCodeValuesFinder;
import org.kuali.rice.kew.document.RoutingRuleMaintainable;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.Maintainable;

public class RuleTemplateDefaultsTest
extends KEWTestCase {
    private void createNewKualiMaintenanceForm(String rtName) {
        KualiMaintenanceForm kmForm = new KualiMaintenanceForm();
        MaintenanceDocumentBase maintDoc = new MaintenanceDocumentBase();
        RoutingRuleMaintainable oldMaint = new RoutingRuleMaintainable();
        RoutingRuleMaintainable newMaint = new RoutingRuleMaintainable();
        RuleBaseValues rbValues = new RuleBaseValues();
        rbValues.setRuleTemplate(KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(rtName));
        oldMaint.setBusinessObject((PersistableBusinessObject)rbValues);
        oldMaint.setBoClass(rbValues.getClass());
        newMaint.setBusinessObject((PersistableBusinessObject)rbValues);
        newMaint.setBoClass(rbValues.getClass());
        maintDoc.setOldMaintainableObject((Maintainable)oldMaint);
        maintDoc.setNewMaintainableObject((Maintainable)newMaint);
        maintDoc.getDocumentHeader().setDocumentDescription("This is a rule template test");
        kmForm.setDocument((Document)maintDoc);
        KNSGlobalVariables.setKualiForm((KualiForm)kmForm);
    }

    private Set<String> createExpectedKeysSet(boolean hasAcknowledge, boolean hasComplete, boolean hasApprove, boolean hasFyi) {
        HashSet<String> expectedKeys = new HashSet<String>();
        if (hasAcknowledge) {
            expectedKeys.add("K");
        }
        if (hasComplete) {
            expectedKeys.add("C");
        }
        if (hasApprove) {
            expectedKeys.add("A");
        }
        if (hasFyi) {
            expectedKeys.add("F");
        }
        return expectedKeys;
    }

    private Set<String> createSetOfKeyValueKeys(List<KeyValue> klpList) {
        HashSet<String> actualKeys = new HashSet<String>();
        Iterator<KeyValue> iterator = klpList.iterator();
        while (iterator.hasNext()) {
            actualKeys.add(iterator.next().getKey());
        }
        return actualKeys;
    }

    @Test
    public void testAllTrueOptionsInTestRuleTemplate() throws Exception {
        this.createNewKualiMaintenanceForm("TestRuleTemplate");
        this.assertRuleTemplateHasExpectedKeyValues(this.createExpectedKeysSet(true, true, true, true), this.createSetOfKeyValueKeys(new RuleMaintenanceActionRequestCodeValuesFinder().getKeyValues()));
    }

    @Test
    public void testCorrectKeyValuesReturnedBasedOnKualiFormInstance() throws Exception {
        KNSGlobalVariables.setKualiForm((KualiForm)new KualiForm());
        this.assertRuleTemplateHasExpectedKeyValues(this.createExpectedKeysSet(true, true, true, true), this.createSetOfKeyValueKeys(new RuleMaintenanceActionRequestCodeValuesFinder().getKeyValues()));
        this.loadXmlFile("RT_ValidRuleTemplatesWithVaryingDefaults.xml");
        this.createNewKualiMaintenanceForm("Test_Rule_Template2");
        this.assertRuleTemplateHasExpectedKeyValues(this.createExpectedKeysSet(false, false, false, true), this.createSetOfKeyValueKeys(new RuleMaintenanceActionRequestCodeValuesFinder().getKeyValues()));
    }

    @Test
    public void testOptionsInRT_ValidRuleTemplatesWithVaryingDefaults() throws Exception {
        this.loadXmlFile("RT_ValidRuleTemplatesWithVaryingDefaults.xml");
        String[] ruleTemplates = new String[]{"RuleTemplate_With_Valid_Defaults", "RuleTemplate_With_More_Valid_Defaults"};
        boolean[][] kSetBools = new boolean[][]{{false, false, true, false}, {true, true, false, false}};
        String[][] defaultActions = new String[][]{{"A", "A", "A"}, {"C", "C", "C"}};
        for (int i = 0; i < ruleTemplates.length; ++i) {
            this.createNewKualiMaintenanceForm(ruleTemplates[i]);
            this.assertRuleTemplateHasExpectedKeyValues(this.createExpectedKeysSet(kSetBools[i][0], kSetBools[i][1], kSetBools[i][2], kSetBools[i][3]), this.createSetOfKeyValueKeys(new RuleMaintenanceActionRequestCodeValuesFinder().getKeyValues()));
            this.assertRuleTemplateHasExpectedDefaultActions(defaultActions[i]);
        }
    }

    private void assertRuleTemplateHasExpectedKeyValues(Set<String> expectedKeys, Set<String> actualKeys) throws Exception {
        for (String expKey : expectedKeys) {
            Assert.assertTrue((String)("The key label pair with a key of '" + expKey + "' should have been true."), (boolean)actualKeys.contains(expKey));
            actualKeys.remove(expKey);
        }
        if (!actualKeys.isEmpty()) {
            String pluralStr = actualKeys.size() != 1 ? "s" : "";
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("The key label pair").append(pluralStr).append(" with the key").append(pluralStr).append(" of ");
            Iterator<String> iterator = actualKeys.iterator();
            while (iterator.hasNext()) {
                errMsg.append("'").append(iterator.next()).append(iterator.hasNext() ? "', " : "' ");
            }
            errMsg.append("should have been false.");
            Assert.fail((String)errMsg.toString());
        }
    }

    private void assertRuleTemplateHasExpectedDefaultActions(String[] expectedDefActions) throws Exception {
        RoutingRuleMaintainable rrMaint = (RoutingRuleMaintainable)((MaintenanceDocument)((KualiMaintenanceForm)KNSGlobalVariables.getKualiForm()).getDocument()).getNewMaintainableObject();
        String[] respSectionConsts = new String[]{"personResponsibilities", "groupResponsibilities", "roleResponsibilities"};
        for (int i = 0; i < respSectionConsts.length; ++i) {
            String actualDefAction = ((RuleResponsibilityBo)rrMaint.initNewCollectionLine(respSectionConsts[i])).getActionRequestedCd();
            Assert.assertEquals((String)"The rule template does not have the expected default approve action.", (Object)expectedDefActions[i], (Object)actualDefAction);
        }
    }
}

