/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.role.service.RoleService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemodule.TestDocContent;
import org.kuali.rice.kew.routemodule.TestRecipient;
import org.kuali.rice.kew.routemodule.TestResponsibility;
import org.kuali.rice.kew.routemodule.TestRouteLevel;
import org.kuali.rice.kew.routemodule.TestRouteModuleXMLHelper;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class RoleServiceTest
extends KEWTestCase {
    private static final String TEST_ROLE = "TestRole";
    private static final String TEST_GROUP_1 = "TestGroup1";
    private static final String TEST_GROUP_2 = "TestGroup2";
    private RoleService roleService;
    private String documentId;
    private List<String> group1 = new ArrayList<String>();
    private List<String> group2 = new ArrayList<String>();

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        this.roleService = KEWServiceLocator.getRoleService();
        this.initializeAttribute();
        this.documentId = this.routeDocument();
    }

    private void initializeAttribute() throws Exception {
        this.group1.add(this.getPrincipalIdForName("jhopf"));
        this.group1.add(this.getPrincipalIdForName("pmckown"));
        this.group2.add(this.getPrincipalIdForName("xqi"));
        this.group2.add(this.getPrincipalIdForName("tbazler"));
        TestRuleAttribute.addRole(TEST_ROLE);
        TestRuleAttribute.addQualifiedRole(TEST_ROLE, TEST_GROUP_1);
        TestRuleAttribute.addQualifiedRole(TEST_ROLE, TEST_GROUP_2);
        TestRuleAttribute.setRecipientPrincipalIds(TEST_ROLE, TEST_GROUP_1, this.group1);
        TestRuleAttribute.setRecipientPrincipalIds(TEST_ROLE, TEST_GROUP_2, this.group2);
    }

    private String routeDocument() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        document.setApplicationContent(TestRouteModuleXMLHelper.toXML(this.generateDocContent()));
        document.route("testing only");
        return document.getDocumentId();
    }

    @Test
    public void testReResolveQualifiedRole() throws Exception {
        DocumentRouteHeaderValue loadedDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        Assert.assertEquals((Object)"R", (Object)loadedDocument.getDocRouteStatus());
        List requests = this.getTestRoleRequests(loadedDocument);
        Assert.assertEquals((String)"Incorrect number of role control requests.", (long)2L, (long)requests.size());
        this.assertRequestGraphs(requests);
        ArrayList<String> newGroup1Recipients = new ArrayList<String>();
        newGroup1Recipients.add(this.getPrincipalIdForName("bmcgough"));
        newGroup1Recipients.add(this.getPrincipalIdForName("xqi"));
        newGroup1Recipients.add(this.getPrincipalIdForName("rkirkend"));
        TestRuleAttribute.setRecipientPrincipalIds(TEST_ROLE, TEST_GROUP_1, newGroup1Recipients);
        this.roleService.reResolveQualifiedRole(loadedDocument, TEST_ROLE, TEST_GROUP_1);
        loadedDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        Assert.assertEquals((Object)"R", (Object)loadedDocument.getDocRouteStatus());
        requests = this.getTestRoleRequests(loadedDocument);
        Assert.assertEquals((String)"Incorrect number of role control requests.", (long)1L, (long)requests.size());
        this.assertRequestGraphs(requests);
        this.assertInitiatorRequestDone(TEST_ROLE, TEST_GROUP_1);
        this.roleService.reResolveQualifiedRole(loadedDocument, TEST_ROLE, "random cool name");
        requests = this.getTestRoleRequests(loadedDocument);
        Assert.assertEquals((String)"Incorrect number of role control requests.", (long)1L, (long)requests.size());
        this.assertRequestGraphs(requests);
    }

    @Test
    public void testReResolveQualifiedRoleErrors() throws Exception {
        try {
            this.roleService.reResolveQualifiedRole((DocumentRouteHeaderValue)null, null, null);
            Assert.fail((String)"Exception should have been thrown when null values are passed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DocumentRouteHeaderValue loadedDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        try {
            this.roleService.reResolveQualifiedRole(loadedDocument, null, null);
            Assert.fail((String)"Exception should have been thrown when null values are passed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.roleService.reResolveQualifiedRole(loadedDocument, "GimpyRoleName", TEST_GROUP_1);
            Assert.fail((String)"Exception should be thrown when attempting to re-resolve with a bad role name.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        document.setApplicationContent(TestRouteModuleXMLHelper.toXML(this.generateDocContent()));
        document.blanketApprove("");
        DocumentRouteHeaderValue baDoc = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        try {
            this.roleService.reResolveQualifiedRole(baDoc, TEST_ROLE, TEST_GROUP_1);
            Assert.fail((String)"Shouldn't be able to resolve on a document with no active nodes.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testReResolveRole() throws Exception {
        DocumentRouteHeaderValue loadedDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        Assert.assertEquals((Object)"R", (Object)loadedDocument.getDocRouteStatus());
        List requests = this.getTestRoleRequests(loadedDocument);
        Assert.assertEquals((String)"Incorrect number of role control requests.", (long)2L, (long)requests.size());
        this.assertRequestGraphs(requests);
        ArrayList<String> newGroup1 = new ArrayList<String>();
        ArrayList<String> newGroup2 = new ArrayList<String>();
        newGroup2.add(this.getPrincipalIdForName("ewestfal"));
        newGroup2.add(this.getPrincipalIdForName("jthomas"));
        TestRuleAttribute.setRecipientPrincipalIds(TEST_ROLE, TEST_GROUP_1, newGroup1);
        TestRuleAttribute.setRecipientPrincipalIds(TEST_ROLE, TEST_GROUP_2, newGroup2);
        this.roleService.reResolveRole(loadedDocument, TEST_ROLE);
        loadedDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        Assert.assertEquals((Object)"R", (Object)loadedDocument.getDocRouteStatus());
        requests = this.getTestRoleRequests(loadedDocument);
        Assert.assertEquals((String)"Incorrect number of role control requests.", (long)1L, (long)requests.size());
        this.assertRequestGraphs(requests);
    }

    @Test
    public void testReResolveRoleErrors() throws Exception {
        try {
            this.roleService.reResolveRole((DocumentRouteHeaderValue)null, null);
            Assert.fail((String)"Exception should have been thrown when null values are passed.");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        DocumentRouteHeaderValue loadedDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        try {
            this.roleService.reResolveRole(loadedDocument, null);
            Assert.fail((String)"Exception should have been thrown when null values are passed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.roleService.reResolveRole(loadedDocument, "GimpyRoleName");
            Assert.fail((String)"Exception should be thrown when attempting to re-resolve with a bad role name.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        document.setApplicationContent(TestRouteModuleXMLHelper.toXML(this.generateDocContent()));
        document.blanketApprove("");
        DocumentRouteHeaderValue baDoc = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        try {
            this.roleService.reResolveRole(baDoc, TEST_ROLE);
            Assert.fail((String)"Shouldn't be able to re-resolve on a document with no active nodes.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List getTestRoleRequests(DocumentRouteHeaderValue document) {
        ArrayList<ActionRequestValue> testRoleRequests = new ArrayList<ActionRequestValue>();
        List requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteLevel(document.getDocumentId(), document.getDocRouteLevel());
        for (ActionRequestValue actionRequest : requests) {
            if (!TEST_ROLE.equals(actionRequest.getRoleName())) continue;
            testRoleRequests.add(actionRequest);
        }
        return testRoleRequests;
    }

    private void assertRequestGraphs(List requests) throws Exception {
        for (ActionRequestValue request : requests) {
            if (TEST_GROUP_1.equals(request.getQualifiedRoleName())) {
                this.assertQualifiedRoleRequest(request, TEST_ROLE, TEST_GROUP_1);
                continue;
            }
            if (!TEST_GROUP_2.equals(request.getQualifiedRoleName())) continue;
            this.assertQualifiedRoleRequest(request, TEST_ROLE, TEST_GROUP_2);
        }
    }

    private void assertQualifiedRoleRequest(ActionRequestValue request, String roleName, String qualifiedRoleName) throws Exception {
        this.assertActionRequest(request, roleName, qualifiedRoleName);
        List<String> recipients = TestRuleAttribute.getRecipientPrincipalIds(roleName, qualifiedRoleName);
        Assert.assertEquals((String)"Incorrect number of children requests.", (long)recipients.size(), (long)request.getChildrenRequests().size());
        for (ActionRequestValue childRequest : request.getChildrenRequests()) {
            this.assertActionRequest(childRequest, roleName, qualifiedRoleName);
            Assert.assertTrue((String)("Child request to invalid user: " + childRequest.getPrincipalId()), (boolean)this.containsUser(recipients, childRequest.getPrincipalId()));
            Assert.assertEquals((String)"Child request should have no children.", (long)0L, (long)childRequest.getChildrenRequests().size());
        }
    }

    private void assertActionRequest(ActionRequestValue request, String roleName, String qualifiedRoleName) {
        Assert.assertEquals((String)"Incorrect role name.", (Object)roleName, (Object)request.getRoleName());
        Assert.assertEquals((String)"Incorrect qualified role name.", (Object)qualifiedRoleName, (Object)request.getQualifiedRoleName());
        Assert.assertEquals((String)"Incorrect qualified role name label.", (Object)qualifiedRoleName, (Object)request.getQualifiedRoleNameLabel());
        Assert.assertTrue((String)"Request should be activated or done.", (ActionRequestStatus.ACTIVATED.getCode().equals(request.getStatus()) || ActionRequestStatus.DONE.getCode().equals(request.getStatus()) ? 1 : 0) != 0);
    }

    private boolean containsUser(List<String> principalIds, String principalId) throws Exception {
        return principalIds.contains(principalId);
    }

    private void assertInitiatorRequestDone(String roleName, String qualifiedRoleNameLabel) throws Exception {
        Principal initiator = KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName("rkirkend");
        List requests = KEWServiceLocator.getActionRequestService().findByStatusAndDocId(ActionRequestStatus.DONE.getCode(), this.documentId);
        Iterator iterator = requests.iterator();
        while (iterator.hasNext()) {
            ActionRequestValue request = (ActionRequestValue)iterator.next();
            if (initiator.getPrincipalId().equals(request.getPrincipalId())) continue;
            iterator.remove();
        }
        Assert.assertEquals((String)"Initiator should have a complete request and their re-resolved request.", (long)2L, (long)requests.size());
        int roleRequestCount = 0;
        for (ActionRequestValue actionRequest : requests) {
            if (!TEST_ROLE.equals(actionRequest.getRoleName())) continue;
            ++roleRequestCount;
            this.assertActionRequest(actionRequest, roleName, qualifiedRoleNameLabel);
            Assert.assertTrue((String)"Initiator request should have a parent.", (actionRequest.getParentActionRequest() != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"There should be 1 DONE request from the result of the role re-resolve.", (long)1L, (long)roleRequestCount);
    }

    private TestDocContent generateDocContent() {
        TestDocContent docContent = new TestDocContent();
        ArrayList<TestRouteLevel> routeLevels = new ArrayList<TestRouteLevel>();
        TestRouteLevel routeLevel1 = new TestRouteLevel();
        routeLevels.add(routeLevel1);
        docContent.setRouteLevels(routeLevels);
        routeLevel1.setPriority(1);
        ArrayList<TestResponsibility> responsibilities = new ArrayList<TestResponsibility>();
        routeLevel1.setResponsibilities(responsibilities);
        TestResponsibility responsibility1 = new TestResponsibility();
        responsibility1.setActionRequested("A");
        responsibility1.setPriority(1);
        TestRecipient recipient1 = new TestRecipient();
        recipient1.setId(this.getPrincipalIdForName("rkirkend"));
        recipient1.setType(RecipientType.PRINCIPAL.getCode());
        responsibility1.setRecipient(recipient1);
        responsibilities.add(responsibility1);
        return docContent;
    }
}

