/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.springframework.util.CollectionUtils;

public class KEWModuleServiceIntTest
extends KEWTestCase {
    private static final String KUALI_NAMESPACE_CODE = "KUALI";
    private ModuleService kewModuleService;

    @Before
    public void setupServiceUnderTest() {
        KualiModuleService kualiModuleService = (KualiModuleService)GlobalResourceLoader.getService((String)"kualiModuleService");
        this.kewModuleService = kualiModuleService.getResponsibleModuleService(DocumentTypeEBO.class);
    }

    @Test
    public void testGetDocumentTypeEbo() {
        Assert.assertNotNull((String)"kewModuleService wasn't successfully configured", (Object)this.kewModuleService);
        DocumentTypeEBO riceDocument = (DocumentTypeEBO)this.kewModuleService.getExternalizableBusinessObject(DocumentTypeEBO.class, Collections.singletonMap("name", "RiceDocument"));
        Assert.assertNotNull((String)"riceDocument wasn't successfully loaded", (Object)riceDocument);
        Assert.assertEquals((String)"riceDocument doesn't have the requested name", (Object)riceDocument.getName(), (Object)"RiceDocument");
        Assert.assertNull((String)"non-null result for bogus query", (Object)this.kewModuleService.getExternalizableBusinessObject(DocumentTypeEBO.class, Collections.singletonMap("name", "Kwisatz Haderach")));
        List documentTypes = this.kewModuleService.getExternalizableBusinessObjectsList(DocumentTypeEBO.class, Collections.emptyMap());
        Assert.assertFalse((String)"documentTypes weren't successfully retrieved", (boolean)CollectionUtils.isEmpty((Collection)documentTypes));
        Assert.assertTrue((documentTypes.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)KEWModuleServiceIntTest.contains(documentTypes, riceDocument));
        documentTypes = this.kewModuleService.getExternalizableBusinessObjectsList(DocumentTypeEBO.class, Collections.singletonMap("name", "RiceDocument"));
        Assert.assertFalse((String)"documentTypes weren't successfully retrieved", (boolean)CollectionUtils.isEmpty((Collection)documentTypes));
        Assert.assertTrue((documentTypes.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)KEWModuleServiceIntTest.contains(documentTypes, riceDocument));
        documentTypes = this.kewModuleService.getExternalizableBusinessObjectsList(DocumentTypeEBO.class, Collections.singletonMap("name", "Kwisatz Haderach"));
        Assert.assertTrue((String)"no documentTypes should have been returned", (boolean)CollectionUtils.isEmpty((Collection)documentTypes));
    }

    private static boolean contains(Collection<DocumentTypeEBO> collection, DocumentTypeEBO documentType) {
        if (collection != null) {
            for (DocumentTypeEBO element : collection) {
                if (!documentType.getName().equals(element.getName()) || !documentType.getDocumentTypeId().equals(element.getDocumentTypeId())) continue;
                return true;
            }
        }
        return false;
    }
}

