/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.xml.export.XmlExporterTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.ClearDatabaseLifecycle;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RuleXmlExporterTest
extends XmlExporterTestCase {
    @Test
    public void testExport() throws Exception {
        this.loadXmlFile("org/kuali/rice/kew/actions/ActionsConfig.xml");
        this.loadXmlStream(new FileInputStream(this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/batch/data/RuleAttributeContent.xml"));
        this.loadXmlStream(new FileInputStream(this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/batch/data/RuleTemplateContent.xml"));
        this.loadXmlStream(new FileInputStream(this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/batch/data/DocumentTypeContent.xml"));
        this.loadXmlStream(new FileInputStream(this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/batch/data/RuleContent.xml"));
        this.assertRuleBaseValuesStateIndependence();
        this.assertExport();
    }

    @Override
    protected void assertExport() throws Exception {
        List oldRules = KEWServiceLocator.getRuleService().fetchAllRules(true);
        this.assertAllRulesHaveUniqueNames(oldRules);
        List oldRuleDelegations = KEWServiceLocator.getRuleDelegationService().findAllCurrentRuleDelegations();
        this.assertAllRuleDelegationsHaveUniqueNames(oldRuleDelegations);
        KewExportDataSet dataSet = new KewExportDataSet();
        dataSet.getRules().addAll(oldRules);
        dataSet.getRuleDelegations().addAll(oldRuleDelegations);
        dataSet.getDocumentTypes().addAll(KEWServiceLocator.getDocumentTypeService().findAllCurrent());
        dataSet.getRuleTemplates().addAll(KEWServiceLocator.getRuleTemplateService().findAll());
        dataSet.getRuleAttributes().addAll(KEWServiceLocator.getRuleAttributeService().findAll());
        byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
        Assert.assertTrue((String)"XML should be non empty.", (xmlBytes != null && xmlBytes.length > 0 ? 1 : 0) != 0);
        ClearDatabaseLifecycle clearLifeCycle = new ClearDatabaseLifecycle();
        clearLifeCycle.getTablesToClear().add("KREW_RULE_T");
        clearLifeCycle.getTablesToClear().add("KREW_RULE_RSP_T");
        clearLifeCycle.getTablesToClear().add("KREW_DLGN_RSP_T");
        clearLifeCycle.getTablesToClear().add("KREW_RULE_ATTR_T");
        clearLifeCycle.getTablesToClear().add("KREW_RULE_TMPL_T");
        clearLifeCycle.getTablesToClear().add("KREW_DOC_TYP_T");
        clearLifeCycle.start();
        new KEWTestCase.ClearCacheLifecycle().stop();
        this.loadXmlStream(new BufferedInputStream(new ByteArrayInputStream(xmlBytes)));
        List newRules = KEWServiceLocator.getRuleService().fetchAllRules(true);
        Assert.assertEquals((String)"Should have same number of old and new Rules.", (long)oldRules.size(), (long)newRules.size());
        for (RuleBaseValues oldRule : oldRules) {
            boolean foundRule = false;
            for (RuleBaseValues newRule : newRules) {
                if (!oldRule.getDescription().equals(newRule.getDescription())) continue;
                this.assertRuleExport(oldRule, newRule);
                foundRule = true;
            }
            Assert.assertTrue((String)("Could not locate the new rule for description " + oldRule.getDescription()), (boolean)foundRule);
        }
        List newRuleDelegations = KEWServiceLocator.getRuleDelegationService().findAllCurrentRuleDelegations();
        this.assertDelegations(oldRuleDelegations, newRuleDelegations);
    }

    protected void assertRuleBaseValuesStateIndependence() throws Exception {
        for (Object o : KEWServiceLocator.getRuleService().fetchAllRules(true)) {
            RuleBaseValues rule = (RuleBaseValues)o;
            KewExportDataSet dataSet = new KewExportDataSet();
            dataSet.getRules().add(rule);
            byte[] saveXmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
            String saveStr = new String(saveXmlBytes);
            WebRuleUtils.populateRuleMaintenanceFields((RuleBaseValues)rule);
            byte[] loadXmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
            String loadStr = new String(loadXmlBytes);
            Assert.assertTrue((String)("The load/render state of the RuleBaseValues shouldn't effect the export: \n" + saveStr + "\n\n != \n\n" + loadStr), (boolean)StringUtils.equals((String)saveStr, (String)loadStr));
        }
    }

    private void assertRuleExport(RuleBaseValues oldRule, RuleBaseValues newRule) {
        Assert.assertFalse((String)"Ids should be different.", (boolean)oldRule.getId().equals(newRule.getId()));
        Assert.assertEquals((Object)oldRule.isActive(), (Object)newRule.isActive());
        Assert.assertEquals((Object)DateUtils.round((Date)oldRule.getActivationDate(), (int)5), (Object)DateUtils.round((Date)newRule.getActivationDate(), (int)5));
        Assert.assertEquals((Object)oldRule.getName(), (Object)newRule.getName());
        Assert.assertEquals((Object)oldRule.getCurrentInd(), (Object)newRule.getCurrentInd());
        Assert.assertEquals((Object)oldRule.getDeactivationDate(), (Object)newRule.getDeactivationDate());
        Assert.assertEquals((Object)oldRule.getDelegateRule(), (Object)newRule.getDelegateRule());
        Assert.assertEquals((Object)oldRule.getDescription(), (Object)newRule.getDescription());
        Assert.assertEquals((Object)oldRule.getDocTypeName(), (Object)newRule.getDocTypeName());
        if (oldRule.getFromDateValue() == null) {
            Assert.assertNull((Object)newRule.getFromDateValue());
        } else {
            Assert.assertEquals((Object)DateUtils.round((Date)oldRule.getFromDateValue(), (int)5), (Object)DateUtils.round((Date)newRule.getFromDateValue(), (int)5));
        }
        if (oldRule.getToDateValue() == null) {
            Assert.assertNull((Object)newRule.getToDateValue());
        } else {
            Assert.assertEquals((Object)DateUtils.round((Date)oldRule.getToDateValue(), (int)5), (Object)DateUtils.round((Date)newRule.getToDateValue(), (int)5));
        }
        Assert.assertEquals((Object)oldRule.getFromDateString(), (Object)newRule.getFromDateString());
        Assert.assertEquals((Object)oldRule.getToDateString(), (Object)newRule.getToDateString());
        Assert.assertEquals((Object)oldRule.isForceAction(), (Object)newRule.isForceAction());
        if (!oldRule.getDelegateRule().booleanValue()) {
            Assert.assertEquals((Object)oldRule.getPreviousRuleId(), (Object)newRule.getPreviousRuleId());
        }
        Assert.assertEquals((Object)oldRule.getDocumentId(), (Object)newRule.getDocumentId());
        if (oldRule.getRuleTemplate() == null) {
            Assert.assertNull((Object)newRule.getRuleTemplate());
        } else {
            Assert.assertEquals((Object)oldRule.getRuleTemplate().getName(), (Object)newRule.getRuleTemplate().getName());
        }
        if (oldRule.getRuleExpressionDef() == null) {
            Assert.assertNull((Object)newRule.getRuleExpressionDef());
        } else {
            Assert.assertEquals((Object)oldRule.getRuleExpressionDef().getExpression(), (Object)newRule.getRuleExpressionDef().getExpression());
            Assert.assertEquals((Object)oldRule.getRuleExpressionDef().getType(), (Object)newRule.getRuleExpressionDef().getType());
        }
        if (!oldRule.getDelegateRule().booleanValue()) {
            Assert.assertEquals((Object)oldRule.getVersionNbr(), (Object)newRule.getVersionNbr());
        }
        this.assertRuleExtensions(oldRule.getRuleExtensions(), newRule.getRuleExtensions());
        this.assertResponsibilities(oldRule.getRuleResponsibilities(), newRule.getRuleResponsibilities());
    }

    private void assertRuleExtensions(List oldRuleExtensions, List newRuleExtensions) {
        Assert.assertEquals((long)oldRuleExtensions.size(), (long)newRuleExtensions.size());
        for (RuleExtensionBo oldExtension : oldRuleExtensions) {
            boolean foundExtension = false;
            for (RuleExtensionBo newExtension : newRuleExtensions) {
                if (!oldExtension.getRuleTemplateAttribute().getRuleAttribute().getName().equals(newExtension.getRuleTemplateAttribute().getRuleAttribute().getName()) || !oldExtension.getRuleTemplateAttribute().getRuleTemplate().getName().equals(newExtension.getRuleTemplateAttribute().getRuleTemplate().getName())) continue;
                this.assertExtensionValues(oldExtension.getExtensionValues(), newExtension.getExtensionValues());
                foundExtension = true;
                break;
            }
            Assert.assertTrue((String)"Could not locate rule extension.", (boolean)foundExtension);
        }
    }

    private void assertExtensionValues(List oldExtensionValues, List newExtensionValues) {
        Assert.assertEquals((long)oldExtensionValues.size(), (long)newExtensionValues.size());
        for (RuleExtensionValue oldValue : oldExtensionValues) {
            boolean foundValue = false;
            for (RuleExtensionValue newValue : oldExtensionValues) {
                if (!oldValue.getKey().equals(newValue.getKey())) continue;
                Assert.assertEquals((Object)oldValue.getValue(), (Object)newValue.getValue());
                foundValue = true;
                break;
            }
            Assert.assertTrue((String)"Could not locate extension value.", (boolean)foundValue);
        }
    }

    private void assertResponsibilities(List oldResps, List newResps) {
        Assert.assertEquals((long)oldResps.size(), (long)newResps.size());
        for (RuleResponsibilityBo oldResp : oldResps) {
            boolean foundResp = false;
            for (RuleResponsibilityBo newResp : newResps) {
                if (!oldResp.getRuleResponsibilityName().equals(newResp.getRuleResponsibilityName())) continue;
                Assert.assertEquals((Object)oldResp.getActionRequestedCd(), (Object)newResp.getActionRequestedCd());
                Assert.assertEquals((Object)oldResp.getApprovePolicy(), (Object)newResp.getApprovePolicy());
                Assert.assertEquals((Object)oldResp.getResolvedRoleName(), (Object)newResp.getResolvedRoleName());
                Assert.assertEquals((Object)oldResp.getRole(), (Object)newResp.getRole());
                Assert.assertEquals((Object)oldResp.getRuleResponsibilityType(), (Object)newResp.getRuleResponsibilityType());
                Assert.assertEquals((Object)oldResp.getPriority(), (Object)newResp.getPriority());
                foundResp = true;
                break;
            }
            Assert.assertTrue((String)("Could not locate responsibility " + oldResp.getRuleResponsibilityName() + " on rule " + oldResp.getRuleBaseValues().getDescription()), (boolean)foundResp);
        }
    }

    private void assertDelegations(List oldDelegations, List newDelegations) {
        Assert.assertEquals((long)oldDelegations.size(), (long)newDelegations.size());
        for (RuleDelegationBo oldDelegation : oldDelegations) {
            boolean foundDelegation = false;
            for (RuleDelegationBo newDelegation : newDelegations) {
                if (!oldDelegation.getDelegationRule().getName().equals(newDelegation.getDelegationRule().getName())) continue;
                Assert.assertEquals((Object)oldDelegation.getDelegationType(), (Object)newDelegation.getDelegationType());
                Assert.assertFalse((boolean)oldDelegation.getResponsibilityId().equals(newDelegation.getResponsibilityId()));
                this.assertRuleExport(oldDelegation.getDelegationRule(), newDelegation.getDelegationRule());
                foundDelegation = true;
                break;
            }
            Assert.assertTrue((String)"Could not locate delegation.", (boolean)foundDelegation);
        }
    }

    private void assertAllRulesHaveUniqueNames(List rules) throws Exception {
        HashSet<String> ruleDescriptions = new HashSet<String>();
        for (RuleBaseValues rule : rules) {
            Assert.assertFalse((String)("Found 2 rules with the same description '" + rule.getDescription() + "'.  " + "In order for this test to work, all rules in the configuration files must have unique descriptions."), (boolean)ruleDescriptions.contains(rule.getDescription()));
            ruleDescriptions.add(rule.getDescription());
        }
    }

    private void assertAllRuleDelegationsHaveUniqueNames(List<RuleDelegationBo> ruleDelegations) throws Exception {
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleDelegationBo ruleDelegation : ruleDelegations) {
            rules.add(ruleDelegation.getDelegationRule());
        }
        this.assertAllRulesHaveUniqueNames(rules);
    }
}

