/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class ActionItemServiceTest
extends KEWTestCase {
    private ActionListService actionListService;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionItemConfig.xml");
    }

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        this.actionListService = KEWServiceLocator.getActionListService();
    }

    @Test
    public void testUpdateActionItemsForWorkgroupChange() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"ActionItemDocumentType");
        document.setTitle("");
        document.route("");
        Group oldWorkgroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "AIWG-Admin");
        GroupService groupService = KimApiServiceLocator.getGroupService();
        Assert.assertEquals((String)"Workgroup should have 6 members.", (long)6L, (long)groupService.getMembersOfGroup(oldWorkgroup.getId()).size());
        Principal user1 = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("user1");
        Principal user2 = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("user2");
        Principal rkirkend = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("rkirkend");
        Principal shenl = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("shenl");
        ArrayList usersToRemove = new ArrayList();
        List members = groupService.getMembersOfGroup(oldWorkgroup.getId());
        for (GroupMember recipient : members) {
            if (!recipient.getMemberId().equals(rkirkend.getPrincipalId()) && !recipient.getMemberId().equals(shenl.getPrincipalId())) continue;
            KimApiServiceLocator.getGroupService().removePrincipalFromGroup(recipient.getMemberId(), oldWorkgroup.getId());
        }
        KimApiServiceLocator.getGroupService().addPrincipalToGroup(user1.getPrincipalId(), oldWorkgroup.getId());
        KimApiServiceLocator.getGroupService().addPrincipalToGroup(user2.getPrincipalId(), oldWorkgroup.getId());
        Group loadedNewWorkgroup = this.getGroup(oldWorkgroup.getId());
        boolean foundUser1 = false;
        boolean foundUser2 = false;
        List loadedNewGroupMembers = groupService.getMembersOfGroup(loadedNewWorkgroup.getId());
        Assert.assertEquals((String)"Workgroup should have 6 members.", (long)6L, (long)loadedNewGroupMembers.size());
        for (GroupMember recipient : loadedNewGroupMembers) {
            if (recipient.getMemberId().equals(user1.getPrincipalId())) {
                foundUser1 = true;
                continue;
            }
            if (!recipient.getMemberId().equals(user2.getPrincipalId())) continue;
            foundUser2 = true;
        }
        Assert.assertTrue((String)"Did not find user 1 on workgroup.", (boolean)foundUser1);
        Assert.assertTrue((String)"Did not find user 2 on workgroup.", (boolean)foundUser2);
        Collection actionItems = KEWServiceLocator.getActionListService().findByDocumentId(document.getDocumentId());
        boolean foundrkirkend = false;
        boolean foundlshen = false;
        boolean founduser1 = false;
        boolean founduser2 = false;
        for (ActionItem actionItem : actionItems) {
            String authId = actionItem.getPrincipal().getPrincipalName();
            if (authId.equals("rkirkend")) {
                foundrkirkend = true;
                continue;
            }
            if (authId.equals("user1")) {
                founduser1 = true;
                continue;
            }
            if (authId.equals("lshen")) {
                foundlshen = true;
                continue;
            }
            if (!authId.equals("user2")) continue;
            founduser2 = true;
        }
        Assert.assertTrue((String)"rkirkend should still have an AI because he is in 2 workgroups that are routed to.", (boolean)foundrkirkend);
        Assert.assertTrue((String)"user1 should have an AI because they were added to 'AIWG-Admin'", (boolean)founduser1);
        Assert.assertTrue((String)"user2 should have an AI because they were added to 'AIWG-Admin'", (boolean)founduser2);
        Assert.assertFalse((String)"lshen should not have an AI because they were removed from 'AIWG-Admin'", (boolean)foundlshen);
    }

    @Test
    public void testUpdateActionItemsForNestedGroupChange() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"ActionItemDocumentType");
        document.setTitle("");
        Group workgroup1 = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "AIWG-Admin");
        document.adHocToGroup(ActionRequestType.APPROVE, "", workgroup1.getId(), "", true);
        document.route("");
        Principal ewestfal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("ewestfal");
        Assert.assertEquals((String)"User should have 1 action item", (long)1L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(ewestfal.getPrincipalId()).size());
        Assert.assertEquals((String)"Workgroup should have 6 members.", (long)6L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        KimApiServiceLocator.getGroupService().removePrincipalFromGroup(ewestfal.getPrincipalId(), workgroup1.getId());
        Assert.assertEquals((String)"Workgroup should have 5 members.", (long)5L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        Assert.assertEquals((String)"User should have 0 action item", (long)0L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(ewestfal.getPrincipalId()).size());
        KimApiServiceLocator.getGroupService().addPrincipalToGroup(ewestfal.getPrincipalId(), workgroup1.getId());
        Assert.assertEquals((String)"Workgroup should have 6 members.", (long)6L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        Assert.assertEquals((String)"User should have 1 action item", (long)1L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(ewestfal.getPrincipalId()).size());
        Group workgroup1Impl = this.getGroup(workgroup1.getId());
        Principal dewey = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("dewey");
        KimApiServiceLocator.getGroupService().addPrincipalToGroup(dewey.getPrincipalId(), workgroup1Impl.getId());
        Assert.assertEquals((String)"Workgroup should have 7 members.", (long)7L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        Assert.assertEquals((String)"User should have 1 action item", (long)1L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(dewey.getPrincipalId()).size());
        Principal user1 = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("user1");
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionItemDocumentType");
        document.setTitle("");
        workgroup1 = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "AIWG-Nested1");
        document.adHocToGroup(ActionRequestType.APPROVE, "", workgroup1.getId(), "", true);
        document.route("");
        Assert.assertEquals((String)"User should have 1 action item", (long)1L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(user1.getPrincipalId()).size());
        Assert.assertEquals((String)"Workgroup should have 6 members.", (long)6L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        Group workgroupSub = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "AIWG-Nested2");
        KimApiServiceLocator.getGroupService().removePrincipalFromGroup(user1.getPrincipalId(), workgroupSub.getId());
        Assert.assertEquals((String)"Workgroup should have 5 members.", (long)5L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        Assert.assertEquals((String)"User should have 0 action item", (long)0L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(user1.getPrincipalId()).size());
        KimApiServiceLocator.getGroupService().addPrincipalToGroup(user1.getPrincipalId(), workgroupSub.getId());
        Assert.assertEquals((String)"Workgroup should have 6 members.", (long)6L, (long)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(workgroup1.getId()).size());
        Assert.assertEquals((String)"User should have 1 action item", (long)1L, (long)KEWServiceLocator.getActionListService().findByPrincipalId(user1.getPrincipalId()).size());
    }

    @Test
    public void testWorkgroupActionItemGenerationWhenMultipleWorkgroupRequests() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"ActionItemDocumentType");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jitrue"), (String)document.getDocumentId());
        Group testGroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "AIWG-Test");
        Group adminGroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "AIWG-Admin");
        List ars = document.getRootActionRequests();
        boolean routedWorkflowAdmin = false;
        boolean routedTestWorkgroup = false;
        for (ActionRequest request : ars) {
            if (request.isGroupRequest() && testGroup.getId().equals(request.getGroupId())) {
                routedTestWorkgroup = true;
                continue;
            }
            if (!request.isGroupRequest() || !adminGroup.getId().equals(request.getGroupId())) continue;
            routedWorkflowAdmin = true;
        }
        Assert.assertTrue((String)"Should have routed to 'AIWG-Test'", (boolean)routedTestWorkgroup);
        Assert.assertTrue((String)"Should have routed to 'AIWG-Admin'", (boolean)routedWorkflowAdmin);
        Assert.assertTrue((String)"Approve should be requested to member of 'AIWG-Test'", (boolean)document.isApprovalRequested());
        document.approve("");
        Collection actionItems = KEWServiceLocator.getActionListService().findByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be 6 action items to the AIWG-Admin.", (long)6L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertNotNull((String)"this should be a workgroup request", (Object)actionItem.getGroup());
        }
    }

    @Test
    public void testMultipleActionItemGeneration() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"ActionItemDocumentType");
        document.setTitle("");
        document.route("");
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        String jitruePrincipalId = this.getPrincipalIdForName("jitrue");
        Collection actionItems = KEWServiceLocator.getActionListService().findByWorkflowUserDocumentId(ewestfalPrincipalId, document.getDocumentId());
        Assert.assertEquals((String)"Ewestfal should have two action items.", (long)2L, (long)actionItems.size());
        actionItems = KEWServiceLocator.getActionListService().getActionList(ewestfalPrincipalId, null);
        Assert.assertEquals((String)"Ewestfal should have one action item in his action list.", (long)1L, (long)actionItems.size());
        document = WorkflowDocumentFactory.loadDocument((String)ewestfalPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"Ewestfal should have an approval requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)jitruePrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"Jitrue should have an approval requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        actionItems = KEWServiceLocator.getActionListService().findByWorkflowUserDocumentId(ewestfalPrincipalId, document.getDocumentId());
        Assert.assertEquals((String)"Ewestfal should have one action item.", (long)1L, (long)actionItems.size());
        String actionItemId = ((ActionItem)actionItems.iterator().next()).getId();
        actionItems = KEWServiceLocator.getActionListService().getActionList(ewestfalPrincipalId, null);
        Assert.assertEquals((String)"Ewestfal should have one action item in his action list.", (long)1L, (long)actionItems.size());
        Assert.assertEquals((String)"The two action items should be the same.", (Object)actionItemId, (Object)((ActionItem)actionItems.iterator().next()).getId());
    }

    @Test
    public void testOrphanedAcknowledgeFromBlanketApprovalFix() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"BAOrphanedRequestDocumentType");
        document.blanketApprove("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        int numActionItems = this.actionListService.findByDocumentId(document.getDocumentId()).size();
        Assert.assertEquals((String)"Incorrect number of action items.", (long)2L, (long)numActionItems);
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        Collection actionItems = this.actionListService.findByWorkflowUserDocumentId(user1PrincipalId, document.getDocumentId());
        Assert.assertEquals((String)"user1 should have one action item.", (long)1L, (long)actionItems.size());
        actionItems = this.actionListService.findByWorkflowUserDocumentId(rkirkendPrincipalId, document.getDocumentId());
        Assert.assertEquals((String)"rkirkend should have one action item.", (long)1L, (long)actionItems.size());
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have ack request.", (boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((String)"Should still be PROCESSED.", (boolean)document.isProcessed());
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have ack request.", (boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((String)"Should now be FINAL.", (boolean)document.isFinal());
    }

    protected Group getGroup(String groupId) {
        return KimApiServiceLocator.getGroupService().getGroup(groupId);
    }
}

