/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ActionRequestScenariosTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionRequestsConfig.xml");
    }

    @Test
    public void testInlineRequestsRouteModule() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("arh14"), (String)"InlineRequestsDocumentType");
        document.setApplicationContent("<blah><step>step1</step></blah>");
        document.route("");
        TestUtilities.assertAtNode(document, "step1");
        List requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 request.", (long)1L, (long)requests.size());
        ActionRequestValue user1Request = (ActionRequestValue)requests.get(0);
        Assert.assertEquals((Object)this.getPrincipalIdForName("user1"), (Object)user1Request.getPrincipalId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("user1"), (String)document.getDocumentId());
        document.setApplicationContent("<blah><step>step2</step></blah>");
        document.approve("");
        TestUtilities.assertAtNode(document, "step2");
        requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 request.", (long)1L, (long)requests.size());
        ActionRequestValue workgroupRequest = (ActionRequestValue)requests.get(0);
        Assert.assertEquals((Object)this.getGroupIdFromGroupName("KR-WKFLW", "TestWorkgroup"), (Object)workgroupRequest.getGroupId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("temay"), (String)document.getDocumentId());
        document.setApplicationContent("<blah><step>step3</step></blah>");
        document.approve("");
        TestUtilities.assertAtNode(document, "step3");
        requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 request.", (long)1L, (long)requests.size());
        ActionRequestValue initiatorRequest = (ActionRequestValue)requests.get(0);
        Assert.assertEquals((Object)"INITIATOR", (Object)initiatorRequest.getRoleName());
        Assert.assertFalse((String)"Document should not be FINAL", (boolean)document.isFinal());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("arh14"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be FINAL", (boolean)document.isFinal());
    }

    @Test
    public void testInlineRequestsRouteModule_UsingAttributes() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("arh14"), (String)"InlineRequestsDocumentType_UsingAttributes");
        document.setApplicationContent("<blah><step>step1</step></blah>");
        document.route("");
        TestUtilities.assertAtNode(document, "step1");
        List requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 request.", (long)1L, (long)requests.size());
        ActionRequestValue user1Request = (ActionRequestValue)requests.get(0);
        Assert.assertEquals((Object)this.getPrincipalIdForName("user1"), (Object)user1Request.getPrincipalId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("user1"), (String)document.getDocumentId());
        document.setApplicationContent("<blah><step>step2</step></blah>");
        document.approve("");
        TestUtilities.assertAtNode(document, "step2");
        requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 request.", (long)1L, (long)requests.size());
        ActionRequestValue workgroupRequest = (ActionRequestValue)requests.get(0);
        Assert.assertEquals((Object)this.getGroupIdFromGroupName("KR-WKFLW", "TestWorkgroup"), (Object)workgroupRequest.getGroupId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("temay"), (String)document.getDocumentId());
        document.setApplicationContent("<blah><step>step3</step></blah>");
        document.approve("");
        TestUtilities.assertAtNode(document, "step3");
        requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 request.", (long)1L, (long)requests.size());
        ActionRequestValue initiatorRequest = (ActionRequestValue)requests.get(0);
        Assert.assertEquals((Object)"INITIATOR", (Object)initiatorRequest.getRoleName());
        Assert.assertFalse((String)"Document should not be FINAL", (boolean)document.isFinal());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("arh14"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be FINAL", (boolean)document.isFinal());
    }

    @Test
    public void testForceActionWithDelegation() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("user1"), (String)"testForceActionWithDelegation");
        document.route("");
        TestUtilities.assertAtNode(document, "Node1");
        List rootRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 root request.", (long)1L, (long)rootRequests.size());
        ActionRequestValue ewestfalRequest = (ActionRequestValue)rootRequests.get(0);
        Assert.assertTrue((String)"Request to ewestfal should be force action of true", (boolean)ewestfalRequest.getForceAction());
        Assert.assertEquals((String)"Should have 1 child request.", (long)1L, (long)ewestfalRequest.getChildrenRequests().size());
        ActionRequestValue rkirkendRequest = (ActionRequestValue)ewestfalRequest.getChildrenRequests().get(0);
        Assert.assertFalse((String)"Request to rkirkend should be force action of false", (boolean)rkirkendRequest.getForceAction());
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("ewestfal"), (String)"testForceActionWithDelegation");
        document.route("");
        TestUtilities.assertAtNode(document, "Node1");
        document.approve("");
        Assert.assertTrue((String)"Document should be FINAL", (boolean)document.isFinal());
    }

    @Test
    public void testRoleToRoleDelegation() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("user1"), (String)"testRoleToRoleDelegation");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("xqi"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jitrue"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jhopf"), (String)document.getDocumentId());
        document.approve("Approving as primary delegate.");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((String)"the primary approver should no longer have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jhopf"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Should not have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("xqi"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Should not have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jitrue"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Should not have an approve request.", (boolean)document.isApprovalRequested());
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of action requests.", (long)7L, (long)actionRequests.size());
        for (ActionRequestValue request : actionRequests) {
            Assert.assertTrue((String)"Request should be deactivated.", (boolean)request.isDeactivated());
            if (request.isRoleRequest()) {
                Assert.assertEquals((String)"Should be all approve request", (Object)ActionRequestPolicy.ALL.getCode(), (Object)request.getApprovePolicy());
                continue;
            }
            Assert.assertEquals((String)"Should not have first approve policy set", (Object)ActionRequestPolicy.FIRST.getCode(), (Object)request.getApprovePolicy());
        }
    }

    @Test
    public void testRoleToRoleMixedApprovePoliciesDelegation() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("user1"), (String)"testMixedbagRoleToRoleDelegation");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("xqi"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jitrue"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jhopf"), (String)document.getDocumentId());
        document.approve("Approving as primary delegate.");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((String)"the primary approver should no longer have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jhopf"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Should not have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("xqi"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Should not have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdFromPrincipalName("jitrue"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Should not have an approve request.", (boolean)document.isApprovalRequested());
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of action requests.", (long)7L, (long)actionRequests.size());
        for (ActionRequestValue request : actionRequests) {
            Assert.assertTrue((String)"Request should be deactivated.", (boolean)request.isDeactivated());
            if (request.isRoleRequest() && request.getRoleName().equals("MAIN")) {
                Assert.assertEquals((String)"Should be all approve request", (Object)ActionRequestPolicy.ALL.getCode(), (Object)request.getApprovePolicy());
                continue;
            }
            if (request.isRoleRequest() && request.getRoleName().equals("PRIMARY_DELEGATE")) {
                Assert.assertEquals((String)"Should be first approve request", (Object)ActionRequestPolicy.FIRST.getCode(), (Object)request.getApprovePolicy());
                continue;
            }
            if (request.isRoleRequest() && request.getRoleName().equals("SECONDARY_DELEGATE")) {
                Assert.assertEquals((String)"Should be first approve request", (Object)ActionRequestPolicy.FIRST.getCode(), (Object)request.getApprovePolicy());
                continue;
            }
            if (request.isRoleRequest()) {
                Assert.fail((String)"the roles have been messed up");
                continue;
            }
            Assert.assertEquals((String)"Should not have first approve policy set", (Object)ActionRequestPolicy.FIRST.getCode(), (Object)request.getApprovePolicy());
        }
    }

    @Test
    public void testUnresolvableRoleAttributeRecipients() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdFromPrincipalName("user1"), (String)"UnresolvableRoleRecipsDocType");
        try {
            document.route("");
        }
        catch (Exception e) {
            TestUtilities.getExceptionThreader().join();
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
            Assert.assertTrue((String)"Document should be in exception routing", (boolean)document.isException());
        }
    }

    private String getPrincipalIdFromPrincipalName(String principalName) {
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName).getPrincipalId();
    }

    private String getGroupIdFromGroupName(String namespace, String groupName) {
        return KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespace, groupName).getId();
    }

    private String getRoleIdFromRoleName(String namespaceCode, String roleName) {
        return KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName(namespaceCode, roleName);
    }
}

