/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.AbstractRoleAttribute;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.workgroup.GroupNameId;

public class ChartOrgDispatchAttribute
extends AbstractRoleAttribute {
    private static final long serialVersionUID = -9114899910238607996L;
    public static final String DISPATCH_ROLE = "DISPATCH";
    private String workgroupName;

    public ChartOrgDispatchAttribute() {
    }

    public ChartOrgDispatchAttribute(String workgroupName) {
        this.workgroupName = workgroupName;
    }

    public List getRoleNames() {
        return Arrays.asList(new RoleName(((Object)((Object)this)).getClass().getName(), DISPATCH_ROLE, DISPATCH_ROLE));
    }

    public List getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        return this.parseWorkgroups(documentContent);
    }

    public ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, String roleName, String qualifiedRole) {
        ArrayList<GroupNameId> recipients = new ArrayList<GroupNameId>();
        recipients.add(new GroupNameId(qualifiedRole));
        return new ResolvedQualifiedRole(roleName, recipients);
    }

    public String getDocContent() {
        return "<DISPATCH>" + this.workgroupName + "</" + DISPATCH_ROLE + ">";
    }

    private List<String> parseWorkgroups(DocumentContent documentContent) {
        Document document = XmlHelper.buildJDocument((org.w3c.dom.Document)documentContent.getDocument());
        Collection dispatchElements = XmlHelper.findElements((Element)document.getRootElement(), (String)DISPATCH_ROLE);
        ArrayList<String> workgroupNames = new ArrayList<String>();
        for (Element element : dispatchElements) {
            workgroupNames.add(element.getText());
        }
        return workgroupNames;
    }
}

