/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.engine.node.NodeGraphSearchCriteria;
import org.kuali.rice.kew.engine.node.NodeGraphSearchResult;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class RouteNodeServiceTest
extends KEWTestCase {
    private RouteNodeService routeNodeService;

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        this.routeNodeService = KEWServiceLocator.getRouteNodeService();
    }

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("NodeConfig.xml");
    }

    @Test
    public void testGetFlattenedNodeInstances() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.saveDocument("");
        DocumentRouteHeaderValue serverDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        List routeNodeInstances = this.routeNodeService.getFlattenedNodeInstances(serverDocument, true);
        Assert.assertEquals((long)1L, (long)routeNodeInstances.size());
        Assert.assertEquals((Object)"AdHoc", (Object)((RouteNodeInstance)routeNodeInstances.get(0)).getName());
        document.blanketApprove("");
        Assert.assertTrue((boolean)document.isProcessed());
        serverDocument = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        routeNodeInstances = this.routeNodeService.getFlattenedNodeInstances(serverDocument, true);
        Assert.assertEquals((long)4L, (long)routeNodeInstances.size());
        Assert.assertEquals((Object)"AdHoc", (Object)((RouteNodeInstance)routeNodeInstances.get(0)).getName());
        Assert.assertEquals((Object)"WorkflowDocument", (Object)((RouteNodeInstance)routeNodeInstances.get(1)).getName());
        Assert.assertEquals((Object)"Acknowledge1", (Object)((RouteNodeInstance)routeNodeInstances.get(2)).getName());
        Assert.assertEquals((Object)"Acknowledge2", (Object)((RouteNodeInstance)routeNodeInstances.get(3)).getName());
    }

    @Test
    public void testSearchNodeGraphSequentailBackward() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.blanketApprove("", new String[]{"WorkflowDocument"});
        List activeNodeInstances = this.routeNodeService.getActiveNodeInstances(document.getDocumentId());
        NodeGraphSearchCriteria criteria = new NodeGraphSearchCriteria(2, (Collection)activeNodeInstances, "AdHoc");
        NodeGraphSearchResult result = this.routeNodeService.searchNodeGraph(criteria);
        Assert.assertEquals((String)"Path should have two nodes.", (long)2L, (long)result.getPath().size());
        RouteNodeInstance resultNodeInstance = result.getResultNodeInstance();
        Assert.assertNotNull((String)"Should have a resulting node instance.", (Object)resultNodeInstance);
        Assert.assertEquals((String)"Result node should be the adhoc node.", (Object)"AdHoc", (Object)resultNodeInstance.getName());
        document.blanketApprove("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        List terminalNodeInstances = this.routeNodeService.getTerminalNodeInstances(document.getDocumentId());
        criteria = new NodeGraphSearchCriteria(2, (Collection)terminalNodeInstances, "AdHoc");
        result = this.routeNodeService.searchNodeGraph(criteria);
        Assert.assertEquals((String)"Path should have 4 nodes.", (long)4L, (long)result.getPath().size());
        resultNodeInstance = result.getResultNodeInstance();
        Assert.assertNotNull((String)"Should have a resulting node instance.", (Object)resultNodeInstance);
        Assert.assertEquals((String)"Result node should be the adhoc node.", (Object)"AdHoc", (Object)resultNodeInstance.getName());
        RouteNodeInstance ack1NodeInstance = null;
        for (RouteNodeInstance nodeInstance : result.getPath()) {
            if (!nodeInstance.getName().equals("Acknowledge1")) continue;
            ack1NodeInstance = nodeInstance;
            break;
        }
        Assert.assertNotNull((String)"Could not locate the Acknowledge1 node in the path.", ack1NodeInstance);
        ArrayList<RouteNodeInstance> startNodes = new ArrayList<RouteNodeInstance>();
        startNodes.add(ack1NodeInstance);
        criteria = new NodeGraphSearchCriteria(2, startNodes, "WorkflowDocument");
        result = this.routeNodeService.searchNodeGraph(criteria);
        Assert.assertEquals((String)"Path should have 2 nodes.", (long)2L, (long)result.getPath().size());
        resultNodeInstance = result.getResultNodeInstance();
        Assert.assertNotNull((String)"Should have a resulting node instance.", (Object)resultNodeInstance);
        Assert.assertEquals((String)"Result node should be the workflow document node.", (Object)"WorkflowDocument", (Object)resultNodeInstance.getName());
    }

    @Test
    public void testSearchNodeGraphParallelBackward() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"ParallelDocType");
        document.blanketApprove("", new String[]{"WorkflowDocument2", "WorkflowDocument3"});
        List activeNodeInstances = this.routeNodeService.getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Should be 2 active nodes.", (long)2L, (long)activeNodeInstances.size());
        Set<String> nodeNames = TestUtilities.createNodeInstanceNameSet(activeNodeInstances);
        Assert.assertTrue((String)"Should be at WorkflowDocument2 node.", (boolean)nodeNames.contains("WorkflowDocument2"));
        Assert.assertTrue((String)"Should be at the WorkflowDocument3 node.", (boolean)nodeNames.contains("WorkflowDocument3"));
        NodeGraphSearchCriteria criteria = new NodeGraphSearchCriteria(2, (Collection)activeNodeInstances, "AdHoc");
        NodeGraphSearchResult result = this.routeNodeService.searchNodeGraph(criteria);
        Assert.assertEquals((String)"Path should have eight nodes.", (long)8L, (long)result.getPath().size());
        RouteNodeInstance resultNodeInstance = result.getResultNodeInstance();
        Assert.assertNotNull((String)"Should have a resulting node instance.", (Object)resultNodeInstance);
        Assert.assertEquals((String)"Result node should be the adhoc node.", (Object)"AdHoc", (Object)resultNodeInstance.getName());
        nodeNames = TestUtilities.createNodeInstanceNameSet(result.getPath());
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument3"));
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument5"));
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument2"));
        Assert.assertTrue((boolean)nodeNames.contains("Acknowledge1"));
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument4"));
        Assert.assertTrue((boolean)nodeNames.contains("Split"));
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument"));
        Assert.assertTrue((boolean)nodeNames.contains("AdHoc"));
        RouteNodeInstance workflowDocument2Node = null;
        RouteNodeInstance workflowDocument3Node = null;
        for (RouteNodeInstance nodeInstance : activeNodeInstances) {
            if (nodeInstance.getName().equals("WorkflowDocument2")) {
                workflowDocument2Node = nodeInstance;
                continue;
            }
            if (!nodeInstance.getName().equals("WorkflowDocument3")) continue;
            workflowDocument3Node = nodeInstance;
        }
        Assert.assertNotNull((String)"Could not locate WorkflowDocument2 node.", workflowDocument2Node);
        Assert.assertNotNull((String)"Could not locate WorkflowDocument3 node.", workflowDocument3Node);
        ArrayList<RouteNodeInstance> startNodeInstances = new ArrayList<RouteNodeInstance>();
        startNodeInstances.add(workflowDocument2Node);
        criteria = new NodeGraphSearchCriteria(2, (Collection)activeNodeInstances, "WorkflowDocument4");
        result = this.routeNodeService.searchNodeGraph(criteria);
        Assert.assertEquals((String)"Path should have three nodes.", (long)3L, (long)result.getPath().size());
        resultNodeInstance = result.getResultNodeInstance();
        Assert.assertEquals((String)"Result node should be the WorkflowDocument4 node.", (Object)"WorkflowDocument4", (Object)resultNodeInstance.getName());
        nodeNames = TestUtilities.createNodeInstanceNameSet(result.getPath());
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument2"));
        Assert.assertTrue((boolean)nodeNames.contains("Acknowledge1"));
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument4"));
        startNodeInstances = new ArrayList();
        startNodeInstances.add(workflowDocument3Node);
        criteria = new NodeGraphSearchCriteria(2, (Collection)activeNodeInstances, "WorkflowDocument5");
        result = this.routeNodeService.searchNodeGraph(criteria);
        Assert.assertEquals((String)"Path should have two nodes.", (long)2L, (long)result.getPath().size());
        resultNodeInstance = result.getResultNodeInstance();
        Assert.assertEquals((String)"Result node should be the WorkflowDocument5 node.", (Object)"WorkflowDocument5", (Object)resultNodeInstance.getName());
        nodeNames = TestUtilities.createNodeInstanceNameSet(result.getPath());
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument3"));
        Assert.assertTrue((boolean)nodeNames.contains("WorkflowDocument5"));
    }

    @Test
    public void testSearchNodeGraphForward() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.route("");
        List initialNodeInstances = KEWServiceLocator.getRouteNodeService().getInitialNodeInstances(document.getDocumentId());
        NodeGraphSearchCriteria criteria = new NodeGraphSearchCriteria(1, (Collection)initialNodeInstances, "WorkflowDocument");
        try {
            this.routeNodeService.searchNodeGraph(criteria);
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

