/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.plugin.PluginEnvironment;
import org.kuali.rice.kew.plugin.PluginRegistry;
import org.kuali.rice.kew.plugin.PluginRegistryFactory;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class ExtraClassPathTest
extends KEWTestCase {
    private PluginRegistry registry;

    public void setUp() throws Exception {
        super.setUp();
        TestUtilities.initializePluginDirectories();
        String pluginZipFileLocation = this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/plugin/extraclasspathtest.zip";
        File pluginZipFile = new File(pluginZipFileLocation);
        Assert.assertTrue((String)("File " + pluginZipFileLocation + " should exist"), (boolean)pluginZipFile.exists());
        Assert.assertTrue((String)("File " + pluginZipFileLocation + " should be a file"), (boolean)pluginZipFile.isFile());
        FileUtils.copyFileToDirectory((File)pluginZipFile, (File)TestUtilities.getPluginsDirectory());
        pluginZipFile = new File(TestUtilities.getPluginsDirectory(), pluginZipFile.getName());
        FileUtils.forceDeleteOnExit((File)pluginZipFile);
        this.registry = new PluginRegistryFactory().createPluginRegistry();
        this.registry.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.registry != null) {
            this.registry.stop();
        }
        TestUtilities.cleanupPluginDirectories();
    }

    @Test
    public void testExtraClassPath() throws Exception {
        List environments = this.registry.getPluginEnvironments();
        Assert.assertEquals((String)"There should be 1 plugin environment.", (long)1L, (long)environments.size());
        PluginEnvironment environment = (PluginEnvironment)environments.get(0);
        Assert.assertEquals((String)"Should be the extraclasspathtest plugin.", (Object)"extraclasspathtest", (Object)environment.getPlugin().getName().getLocalPart());
        String extraClassesDirName = environment.getPlugin().getConfig().getProperty("extra.classes.dir");
        String extraLibDirName = environment.getPlugin().getConfig().getProperty("extra.lib.dir");
        File extraClassesDir = new File(extraClassesDirName);
        Assert.assertTrue((String)("extra classes dir (" + extraClassesDirName + ") should exist."), (boolean)extraClassesDir.exists());
        Assert.assertTrue((String)("extra classes dir (" + extraClassesDirName + ") should be a directory."), (boolean)extraClassesDir.isDirectory());
        File extraLibDir = new File(extraLibDirName);
        Assert.assertTrue((String)("extra lib dir (" + extraLibDirName + ") should exist."), (boolean)extraLibDir.exists());
        Assert.assertTrue((String)("extra lib dir (" + extraLibDirName + ") should be a directory."), (boolean)extraLibDir.isDirectory());
        ClassLoader classLoader = environment.getPlugin().getClassLoader();
        Assert.assertNotNull((String)"Resource should exist.", (Object)classLoader.getResource("extraclasspath-classes.txt"));
        Assert.assertNotNull((String)"Resource should exist.", (Object)classLoader.getResource("extraclasspath-lib.txt"));
    }
}

