/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.kew.plugin.HotDeployer;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.PluginEnvironment;
import org.kuali.rice.kew.plugin.PluginRegistry;
import org.kuali.rice.kew.plugin.PluginUtils;
import org.kuali.rice.kew.plugin.Reloader;
import org.kuali.rice.kew.plugin.ServerPluginRegistry;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class HotDeployTest
extends KEWTestCase {
    private File pluginDir;

    public void setUp() throws Exception {
        super.setUp();
        TestUtilities.initializePluginDirectories();
        this.pluginDir = TestUtilities.getPluginsDirectory();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        TestUtilities.cleanupPluginDirectories();
    }

    @Test
    public void testHotDeploy() throws Exception {
        PluginRegistry theRegistry = PluginUtils.getPluginRegistry();
        Assert.assertNotNull((String)"PluginRegistry should exist.", (Object)theRegistry);
        Assert.assertTrue((boolean)(theRegistry instanceof ServerPluginRegistry));
        ServerPluginRegistry registry = (ServerPluginRegistry)theRegistry;
        HotDeployer hotDeployer = registry.getHotDeployer();
        Reloader reloader = registry.getReloader();
        registry.stopHotDeployer();
        registry.stopReloader();
        Assert.assertEquals((String)"There should be no plugins.", (long)0L, (long)registry.getPluginEnvironments().size());
        Assert.assertEquals((String)"Resource loader should have no children.", (long)0L, (long)registry.getResourceLoaders().size());
        Assert.assertEquals((String)"There should be no plugins added.", (long)0L, (long)hotDeployer.getAddedPlugins().size());
        Assert.assertEquals((String)"There should be no plugins removed.", (long)0L, (long)hotDeployer.getRemovedPlugins().size());
        hotDeployer.run();
        Assert.assertEquals((String)"There should still be no plugins.", (long)0L, (long)registry.getPluginEnvironments().size());
        String pluginZipFileLocation = this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/plugin/ziptest.zip";
        File pluginZipFile = new File(pluginZipFileLocation);
        Assert.assertTrue((String)("Plugin file '" + pluginZipFileLocation + "' should exist"), (boolean)pluginZipFile.exists());
        Assert.assertTrue((String)("Plugin file '" + pluginZipFileLocation + "' should be a file"), (boolean)pluginZipFile.isFile());
        FileUtils.copyFileToDirectory((File)pluginZipFile, (File)this.pluginDir);
        Assert.assertEquals((String)"There should be one plugin added.", (long)1L, (long)hotDeployer.getAddedPlugins().size());
        Assert.assertEquals((String)"There should be no plugins removed.", (long)0L, (long)hotDeployer.getRemovedPlugins().size());
        hotDeployer.run();
        Assert.assertEquals((String)"Plugin should have been hot deployed.", (long)1L, (long)registry.getPluginEnvironments().size());
        Assert.assertEquals((String)"There should be no plugins added.", (long)0L, (long)hotDeployer.getAddedPlugins().size());
        Assert.assertEquals((String)"There should be no plugins removed.", (long)0L, (long)hotDeployer.getRemovedPlugins().size());
        Assert.assertEquals((String)"Resource loader should have 1 plugin child.", (long)1L, (long)registry.getResourceLoaders().size());
        Plugin plugin = (Plugin)registry.getResourceLoaders().get(0);
        Assert.assertEquals((String)"Plugin has wrong name.", (Object)new QName(CoreConfigHelper.getApplicationId(), "ziptest"), (Object)plugin.getName());
        Assert.assertTrue((String)"Plugin should be started.", (boolean)plugin.isStarted());
        Assert.assertEquals((String)"Plugin in resource loader and environment should be the same.", (Object)plugin, (Object)registry.getPluginEnvironment(plugin.getName().getLocalPart()).getPlugin());
        Assert.assertEquals((String)"Reloader should have a reference to environment.", (long)1L, (long)reloader.getReloadables().size());
        FileUtils.forceDelete((File)new File(this.pluginDir, "ziptest.zip"));
        Assert.assertEquals((String)"There should be no plugins added.", (long)0L, (long)hotDeployer.getAddedPlugins().size());
        Assert.assertEquals((String)"There should be one plugin removed.", (long)1L, (long)hotDeployer.getRemovedPlugins().size());
        hotDeployer.run();
        Assert.assertEquals((String)"No plugins should be deployed.", (long)0L, (long)registry.getPluginEnvironments().size());
        Assert.assertEquals((String)"Resource loader should have 0 plugin children.", (long)0L, (long)registry.getResourceLoaders().size());
        Assert.assertEquals((String)"Reloader should no longer have reference to environment.", (long)0L, (long)reloader.getReloadables().size());
    }

    @Test
    public void testReloader() throws Exception {
        PluginRegistry theRegistry = PluginUtils.getPluginRegistry();
        Assert.assertNotNull((String)"PluginRegistry should exist.", (Object)theRegistry);
        Assert.assertTrue((boolean)(theRegistry instanceof ServerPluginRegistry));
        ServerPluginRegistry registry = (ServerPluginRegistry)theRegistry;
        HotDeployer hotDeployer = registry.getHotDeployer();
        Reloader reloader = registry.getReloader();
        registry.stopHotDeployer();
        registry.stopReloader();
        Assert.assertEquals((String)"There should be no plugins.", (long)0L, (long)registry.getPluginEnvironments().size());
        Assert.assertEquals((String)"Resource loader should have no children.", (long)0L, (long)registry.getResourceLoaders().size());
        String pluginZipFileLocation = this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/plugin/ziptest.zip";
        File pluginZipFile = new File(pluginZipFileLocation);
        Assert.assertTrue((String)("Plugin file '" + pluginZipFileLocation + "' should exist"), (boolean)pluginZipFile.exists());
        Assert.assertTrue((String)("Plugin file '" + pluginZipFileLocation + "' should be a file"), (boolean)pluginZipFile.isFile());
        FileUtils.copyFileToDirectory((File)pluginZipFile, (File)this.pluginDir);
        pluginZipFile = new File(this.pluginDir, pluginZipFile.getName());
        Assert.assertTrue((boolean)pluginZipFile.exists());
        hotDeployer.run();
        Assert.assertEquals((String)"Plugin should have been hot deployed.", (long)1L, (long)registry.getPluginEnvironments().size());
        Assert.assertEquals((String)"Resource loader should have 1 plugin child.", (long)1L, (long)registry.getResourceLoaders().size());
        PluginEnvironment environment = (PluginEnvironment)registry.getPluginEnvironments().get(0);
        Plugin plugin = environment.getPlugin();
        Assert.assertTrue((boolean)environment.isReloadable());
        Assert.assertFalse((boolean)environment.isReloadNeeded());
        reloader.run();
        Assert.assertTrue((String)"Original plugin should still be running.", (boolean)plugin.isStarted());
        Assert.assertEquals((String)"Plugin should not have changed.", (Object)plugin, (Object)((PluginEnvironment)registry.getPluginEnvironments().get(0)).getPlugin());
        FileUtils.touch((File)pluginZipFile);
        Assert.assertTrue((String)"A reload should be needed now.", (boolean)environment.isReloadNeeded());
        reloader.run();
        Assert.assertTrue((String)"original plugin should be stopped.", (!plugin.isStarted() ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should only be one Plugin.", (long)1L, (long)registry.getResourceLoaders().size());
        PluginEnvironment newPluginEnvironment = (PluginEnvironment)registry.getPluginEnvironments().get(0);
        Plugin newPlugin = newPluginEnvironment.getPlugin();
        Assert.assertEquals((String)"There should still only be one environment.", (long)1L, (long)registry.getPluginEnvironments().size());
        Assert.assertEquals((String)"The plugin environments should still be the same.", (Object)environment, registry.getPluginEnvironments().get(0));
        Assert.assertFalse((String)"The old and new plugins should be different.", (boolean)newPlugin.equals(plugin));
        Assert.assertEquals((String)"The resource loaders should have been updated with the new plugin.", (Object)newPlugin, registry.getResourceLoaders().get(0));
    }
}

