/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.ZipFilePluginLoader;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class ZipFilePluginLoaderTest
extends KEWTestCase {
    private Plugin plugin;
    private File pluginDir;

    @Before
    @Test
    public void testLoad() throws Exception {
        Config config = ConfigContext.getCurrentContextConfig();
        if (config == null) {
            config = new JAXBConfigImpl();
            config.putProperty("application.id", "KEW");
            ConfigContext.init((Config)config);
        }
        File pluginZipFile = new File(this.getBaseDir() + "/src/test/resources/org/kuali/rice/kew/plugin/ziptest.zip");
        Assert.assertTrue((boolean)pluginZipFile.exists());
        Assert.assertTrue((boolean)pluginZipFile.isFile());
        this.pluginDir = TestUtilities.createTempDir();
        FileUtils.copyFileToDirectory((File)pluginZipFile, (File)this.pluginDir);
        pluginZipFile = new File(this.pluginDir, pluginZipFile.getName());
        Assert.assertTrue((boolean)pluginZipFile.exists());
        pluginZipFile.deleteOnExit();
        ZipFilePluginLoader loader = new ZipFilePluginLoader(pluginZipFile, null, ClassLoaderUtils.getDefaultClassLoader(), ConfigContext.getCurrentContextConfig());
        this.plugin = loader.load();
        Assert.assertNotNull((String)"Plugin should have been successfully loaded.", (Object)this.plugin);
        Assert.assertEquals((String)"Plugin QName should be '{KUALI}ziptest'", (Object)new QName("KUALI", "ziptest"), (Object)this.plugin.getName());
        this.plugin.start();
        File extractedDirectory = new File(this.pluginDir, this.plugin.getName().getLocalPart());
        Assert.assertTrue((String)"Plugin should have been extracted.", (boolean)extractedDirectory.exists());
        Assert.assertTrue((boolean)extractedDirectory.isDirectory());
        File[] files = extractedDirectory.listFiles();
        Assert.assertEquals((String)"Should be 3 files", (long)3L, (long)files.length);
        Assert.assertNotNull((String)"Resource should exist.", (Object)this.plugin.getClassLoader().getResource("lib-test.txt"));
        Assert.assertNotNull((String)"Resource should exist.", (Object)this.plugin.getClassLoader().getResource("classes-test.txt"));
        Assert.assertEquals((Object)this.plugin.getConfig().getProperty("test.param.1"), (Object)"test.value.1");
        Assert.assertEquals((Object)this.plugin.getConfig().getProperty("test.param.2"), (Object)"test.value.2");
        Assert.assertEquals((Object)this.plugin.getConfig().getProperty("test.param.3"), (Object)"test.value.3");
        Assert.assertFalse((String)"Plugin should not be modifed at this point.", (boolean)loader.isModified());
        long lastModified = this.pluginDir.lastModified();
        Thread.sleep(1000L);
        FileUtils.touch((File)pluginZipFile);
        Assert.assertTrue((String)"Plugin should be modifed after zip file is touched.", (boolean)loader.isModified());
        this.plugin.stop();
        this.plugin = loader.load();
        this.plugin.start();
        Assert.assertFalse((String)"After reload, plugin should no longer be modifed.", (boolean)loader.isModified());
        Assert.assertTrue((String)"The extracted directory should have been modified.", (this.pluginDir.lastModified() > lastModified ? 1 : 0) != 0);
        try {
            this.plugin.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileUtils.deleteDirectory((File)this.pluginDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

