/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.test.KEWTestCase;

public class AttributeClientRoutingDataValidationTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("AttributeClientRoutingDataValidationTest.xml");
    }

    @Test
    public void testClientApplicationValidationImplementsWorkflowAttributeXmlValidator() throws Exception {
        WorkflowAttributeDefinition attDef = WorkflowAttributeDefinition.Builder.create((String)"TestRuleAttributeThree").build();
        List validationErrors = KewApiServiceLocator.getWorkflowDocumentActionsService().validateWorkflowAttributeDefinition(attDef);
        Assert.assertTrue((String)"Validation errors should not be empty", (!validationErrors.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should be 2 validation errors", (long)2L, (long)validationErrors.size());
        boolean foundKey1 = false;
        boolean foundKey2 = false;
        for (RemotableAttributeErrorContract error : validationErrors) {
            if (error.getAttributeName().equals("key1")) {
                Assert.assertEquals((String)"key1 key should have message of value1", (Object)"value1", (Object)error.getMessage());
                foundKey1 = true;
                continue;
            }
            if (!error.getAttributeName().equals("key2")) continue;
            Assert.assertEquals((String)"key2 key should have message of value2", (Object)"value2", (Object)error.getMessage());
            foundKey2 = true;
        }
        Assert.assertTrue((String)"should have found a key1 error", (boolean)foundKey1);
        Assert.assertTrue((String)"should have found a key2 error", (boolean)foundKey2);
    }

    @Test
    public void testClientApplicationValidationNoImplementsWorkflowAttributeXmlValidator() throws Exception {
        WorkflowAttributeDefinition attDef = WorkflowAttributeDefinition.Builder.create((String)"TestRuleAttributeDuex").build();
        List validationErrors = KewApiServiceLocator.getWorkflowDocumentActionsService().validateWorkflowAttributeDefinition(attDef);
        Assert.assertTrue((String)"Validation errors should be empty because WorkflowAttributeXmlValidator interface is not implemented", (boolean)validationErrors.isEmpty());
    }

    @Test
    public void testThrowWorkflowExceptionNoneExistentAttribute() throws Exception {
        WorkflowAttributeDefinition attDef = WorkflowAttributeDefinition.Builder.create((String)"FakeyMcAttribute").build();
        try {
            KewApiServiceLocator.getWorkflowDocumentActionsService().validateWorkflowAttributeDefinition(attDef);
            Assert.fail((String)"Should have thrown WorkflowException attempting to lookup non-existent attribute");
        }
        catch (WorkflowRuntimeException e) {
            Assert.assertTrue((String)"This is the correct exception to throw", (boolean)true);
        }
    }
}

