/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.xml.sax.InputSource;

public class PrincipalIdRoleAttributeTest
extends KEWTestCase {
    private static final String ATTRIBUTE_NAME = "PrincipalIdRoleAttribute";
    private static final String PRINCIPAL_ID_PROP = "principalId";

    @Test
    public void testPrincipalIdAttribute() throws Exception {
        this.loadXmlFile("PrincipalIdRoleAttributeTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"PrincipalIdRoleAttributeTest");
        WorkflowAttributeDefinition.Builder principalIdDef1 = WorkflowAttributeDefinition.Builder.create((String)ATTRIBUTE_NAME);
        PropertyDefinition principalIdProp1 = PropertyDefinition.create((String)PRINCIPAL_ID_PROP, (String)KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("rkirkend").getPrincipalId());
        principalIdDef1.addPropertyDefinition(principalIdProp1);
        WorkflowAttributeDefinition.Builder principalIdDef2 = WorkflowAttributeDefinition.Builder.create((String)ATTRIBUTE_NAME);
        PropertyDefinition principalIdProp2 = PropertyDefinition.create((String)PRINCIPAL_ID_PROP, (String)KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("bmcgough").getPrincipalId());
        principalIdDef2.addPropertyDefinition(principalIdProp2);
        document.addAttributeDefinition(principalIdDef1.build());
        document.addAttributeDefinition(principalIdDef2.build());
        document.route("Routing!");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("i approve");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("i also approve");
        Assert.assertTrue((String)"Document should be FINAL", (boolean)document.isFinal());
    }

    @Test
    public void testParameterizedPrincipalIdAttribute() throws Exception {
        this.loadXmlFile("ParameterizedPrincipalIdRoleAttributeTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"PrincipalIdRoleAttributeTest");
        WorkflowAttributeDefinition.Builder principalIdDef1 = WorkflowAttributeDefinition.Builder.create((String)ATTRIBUTE_NAME);
        PropertyDefinition principalIdProp1 = PropertyDefinition.create((String)PRINCIPAL_ID_PROP, (String)KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("rkirkend").getPrincipalId());
        principalIdDef1.addPropertyDefinition(principalIdProp1);
        document.addAttributeDefinition(principalIdDef1.build());
        document.route("Routing!");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        XPath xPath = XPathHelper.newXPath();
        Assert.assertTrue((String)"Should have found the ID.", (boolean)((Boolean)xPath.evaluate("//PrincipalIdRoleAttribute/thisIdRocks", new InputSource(new StringReader(document.getDocumentContent().getFullContent())), XPathConstants.BOOLEAN)));
    }
}

