/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.test;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.framework.persistence.ojb.DataAccessUtils;
import org.kuali.rice.kew.test.KEWTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springmodules.orm.ojb.PersistenceBrokerTemplate;

public abstract class OjbBeanTestCase
extends KEWTestCase {
    private Object lock = new Object();

    @Test
    public void testOptimisticLocking() throws Exception {
        if (this.isOptimisticallyLocked()) {
            this.getTransactionTemplate().execute(new TransactionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus status) {
                    try {
                        block9: {
                            Object bean = OjbBeanTestCase.this.loadBean();
                            OjbBeanTestCase.this.modifyBean(bean);
                            Object object = OjbBeanTestCase.this.lock;
                            synchronized (object) {
                                OjbBeanTestCase.this.modifyConcurrently();
                                try {
                                    OjbBeanTestCase.this.lock.wait();
                                }
                                catch (InterruptedException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            try {
                                OjbBeanTestCase.this.getPersistenceBrokerTemplate().store(bean);
                                Assert.fail((String)"The bean was modified by a different transaction, OptimisticLockFailureException should have been thrown.");
                            }
                            catch (Exception e) {
                                if (DataAccessUtils.isOptimisticLockFailure((Throwable)e)) break block9;
                                throw e;
                            }
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void modifyConcurrently() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OjbBeanTestCase.this.lock;
                synchronized (object) {
                    try {
                        OjbBeanTestCase.this.getTransactionTemplate().execute(new TransactionCallback(){

                            public Object doInTransaction(TransactionStatus nestedStatus) {
                                try {
                                    Object bean = OjbBeanTestCase.this.loadBean();
                                    OjbBeanTestCase.this.modifyBean(bean);
                                    OjbBeanTestCase.this.getPersistenceBrokerTemplate().store(bean);
                                    return null;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Assert.fail((String)t.getMessage());
                    }
                    finally {
                        OjbBeanTestCase.this.lock.notify();
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    protected abstract Object loadBean() throws Exception;

    protected abstract void modifyBean(Object var1) throws Exception;

    protected abstract boolean isOptimisticallyLocked();

    protected PersistenceBrokerTemplate getPersistenceBrokerTemplate() {
        return new PersistenceBrokerTemplate();
    }
}

