/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.workflow;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.SearchAttributeIndexTestDocument;
import org.kuali.rice.krad.util.GlobalVariables;

@Deprecated
public class SearchAttributeIndexRequestTest
extends KRADTestCase {
    private static final String SEARCH_ATTRIBUTE_INDEX_DOCUMENT_TEST_DOC_TYPE = "SearchAttributeIndexTestDocument";

    @Test
    public void regularApproveTest() throws Exception {
        String principalName = "quickstart";
        String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("quickstart").getPrincipalId();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        RouteContext.clearCurrentRouteContext();
        Document document = DOCUMENT_FIXTURE.NORMAL_DOCUMENT.getDocument();
        document.getDocumentHeader().setDocumentDescription("Routed SAIndexTestDoc");
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(SEARCH_ATTRIBUTE_INDEX_DOCUMENT_TEST_DOC_TYPE);
        this.assertApproveAttributes(document, documentType, principalId);
    }

    protected void assertApproveAttributes(Document document, DocumentType documentType, String principalId) throws Exception {
        KRADServiceLocatorWeb.getDocumentService().routeDocument(document, "Routed SearchAttributeIndexTestDocument", null);
        this.assertDDSearchableAttributesWork(documentType, principalId, "routeLevelCount", new String[]{"1", "0", "2", "7"}, new int[]{1, 0, 0, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "constantString", new String[]{"hippo", "monkey"}, new int[]{1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "routedString", new String[]{"routing", "hippo"}, new int[]{1, 0});
        GlobalVariables.setUserSession((UserSession)new UserSession("user1"));
        document = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(document.getDocumentNumber());
        KRADServiceLocatorWeb.getDocumentService().approveDocument(document, "User1 approved document", null);
        this.assertDDSearchableAttributesWork(documentType, principalId, "routeLevelCount", new String[]{"1", "0", "2", "7"}, new int[]{0, 0, 1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "constantString", new String[]{"hippo", "monkey"}, new int[]{1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "routedString", new String[]{"routing", "hippo"}, new int[]{1, 0});
        GlobalVariables.setUserSession((UserSession)new UserSession("user2"));
        document = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(document.getDocumentNumber());
        KRADServiceLocatorWeb.getDocumentService().approveDocument(document, "User1 approved document", null);
        this.assertDDSearchableAttributesWork(documentType, principalId, "routeLevelCount", new String[]{"1", "0", "2", "3", "4", "7"}, new int[]{0, 0, 0, 1, 0, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "constantString", new String[]{"hippo", "monkey"}, new int[]{1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "routedString", new String[]{"routing", "hippo"}, new int[]{1, 0});
        GlobalVariables.setUserSession((UserSession)new UserSession("user3"));
        document = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(document.getDocumentNumber());
        KRADServiceLocatorWeb.getDocumentService().approveDocument(document, "User3 approved document", null);
        this.assertDDSearchableAttributesWork(documentType, principalId, "routeLevelCount", new String[]{"1", "0", "2", "3", "4", "7"}, new int[]{0, 0, 0, 1, 0, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "constantString", new String[]{"hippo", "monkey"}, new int[]{1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "routedString", new String[]{"routing", "hippo"}, new int[]{1, 0});
        GlobalVariables.setUserSession(null);
    }

    @Test
    public void blanketApproveTest() throws Exception {
        String principalName = "admin";
        String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("admin").getPrincipalId();
        GlobalVariables.setUserSession((UserSession)new UserSession("admin"));
        Document document = DOCUMENT_FIXTURE.NORMAL_DOCUMENT.getDocument();
        document.getDocumentHeader().setDocumentDescription("Blanket Approved SAIndexTestDoc");
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(SEARCH_ATTRIBUTE_INDEX_DOCUMENT_TEST_DOC_TYPE);
        this.assertBlanketApproveAttributes(document, documentType, principalId);
    }

    protected void assertBlanketApproveAttributes(Document document, DocumentType documentType, String principalId) throws Exception {
        KRADServiceLocatorWeb.getDocumentService().blanketApproveDocument(document, "Blanket Approved SearchAttributeIndexTestDocument", null);
        this.assertDDSearchableAttributesWork(documentType, principalId, "routeLevelCount", new String[]{"1", "0", "2", "3", "7"}, new int[]{0, 0, 0, 1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "constantString", new String[]{"hippo", "monkey"}, new int[]{1, 0});
        this.assertDDSearchableAttributesWork(documentType, principalId, "routedString", new String[]{"routing", "hippo"}, new int[]{1, 0});
        GlobalVariables.setUserSession(null);
    }

    private void assertDDSearchableAttributesWork(DocumentType docType, String principalId, String fieldName, Object[] searchValues, int[] resultSizes) throws Exception {
        if (!(searchValues instanceof String[]) && !(searchValues instanceof String[][])) {
            throw new IllegalArgumentException("'searchValues' parameter has to be either a String[] or a String[][]");
        }
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        DocumentSearchService docSearchService = KEWServiceLocator.getDocumentSearchService();
        for (int i = 0; i < resultSizes.length; ++i) {
            block6: {
                criteria = DocumentSearchCriteria.Builder.create();
                criteria.setDocumentTypeName(docType.getName());
                criteria.addDocumentAttributeValue(fieldName, searchValues[i].toString());
                try {
                    results = docSearchService.lookupDocuments(principalId, criteria.build());
                    if (resultSizes[i] < 0) {
                        Assert.fail((String)(fieldName + "'s search at loop index " + i + " should have thrown an exception"));
                    }
                    if (resultSizes[i] != results.getSearchResults().size()) {
                        Assert.assertEquals((String)(fieldName + "'s search results at loop index " + i + " returned the wrong number of documents."), (long)resultSizes[i], (long)results.getSearchResults().size());
                    }
                }
                catch (Exception ex) {
                    if (resultSizes[i] < 0) break block6;
                    Assert.fail((String)(fieldName + "'s search at loop index " + i + " should not have thrown an exception"));
                }
            }
            GlobalVariables.clear();
        }
    }

    private static enum DOCUMENT_FIXTURE {
        NORMAL_DOCUMENT("hippo", "routing");

        private String constantString;
        private String routingString;

        private DOCUMENT_FIXTURE(String constantString, String routingString) {
            this.constantString = constantString;
            this.routingString = routingString;
        }

        public Document getDocument() throws Exception {
            Document document = KRADServiceLocatorWeb.getDocumentService().getNewDocument(SearchAttributeIndexRequestTest.SEARCH_ATTRIBUTE_INDEX_DOCUMENT_TEST_DOC_TYPE);
            SearchAttributeIndexTestDocument searchAttributeIndexTestDocument = (SearchAttributeIndexTestDocument)document;
            searchAttributeIndexTestDocument.initialize(this.constantString, this.routingString);
            return searchAttributeIndexTestDocument;
        }
    }
}

