/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.util.GlobalVariables;

public class AttachmentTest
extends KRADTestCase {
    Attachment dummyAttachment;

    public void setUp() throws Exception {
        super.setUp();
        this.dummyAttachment = new Attachment();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.dummyAttachment = null;
    }

    @Test
    public void testNoteIdentifier() {
        this.dummyAttachment.setNoteIdentifier(Long.valueOf(12345L));
        Assert.assertTrue((String)"Testing NoteIdentifier of Attachment in AttachmentTest", (12345L == this.dummyAttachment.getNoteIdentifier() ? 1 : 0) != 0);
    }

    @Test
    public void testAttachmentMimeTypeCode() {
        this.dummyAttachment.setAttachmentMimeTypeCode("MIME_TYP");
        Assert.assertEquals((String)"Testing AttachmentmimeTypeCode of Attachment in AttachmentTest", (Object)"MIME_TYP", (Object)this.dummyAttachment.getAttachmentMimeTypeCode());
    }

    @Test
    public void testAttachmentFileName() {
        this.dummyAttachment.setAttachmentFileName("FILE_NM");
        Assert.assertEquals((String)"Testing AttchmentFileName of Attachment in AttachmentTest", (Object)"FILE_NM", (Object)this.dummyAttachment.getAttachmentFileName());
    }

    @Test
    public void testAttachmentIdentifier() {
        this.dummyAttachment.setAttachmentIdentifier("Att_ID");
        Assert.assertEquals((String)"Testing Attachment in AttachmentTest", (Object)"Att_ID", (Object)this.dummyAttachment.getAttachmentIdentifier());
    }

    @Test
    public void testAttachmentFileSize() {
        this.dummyAttachment.setAttachmentFileSize(Long.valueOf(12345L));
        Assert.assertTrue((String)"Testing AttachmentFileSize of Attachment in AttachmentTest", (12345L == this.dummyAttachment.getAttachmentFileSize() ? 1 : 0) != 0);
    }

    @Test
    public void testAttachmentTypeCode() {
        this.dummyAttachment.setAttachmentTypeCode("ATT_TYP_CD");
        Assert.assertEquals((String)"Testing AttachmentmimeTypeCode of Attachment in AttachmentTest", (Object)"ATT_TYP_CD", (Object)this.dummyAttachment.getAttachmentTypeCode());
    }

    @Test
    public void testNote() {
        Note dummyNote = new Note();
        dummyNote.setNoteText("Hello");
        this.dummyAttachment.setNote(dummyNote);
        Assert.assertEquals((String)"Testing Note of Attachment in AttachmentTest", (Object)"Hello", (Object)this.dummyAttachment.getNote().getNoteText());
    }

    @Test
    public void testComplete() {
        this.dummyAttachment.setAttachmentIdentifier("Att_ID");
        this.dummyAttachment.setAttachmentFileName("FILE_NM");
        this.dummyAttachment.setAttachmentFileSize(new Long(12345L));
        this.dummyAttachment.setAttachmentMimeTypeCode("MIME_TYP");
        Assert.assertTrue((String)"Testing Complete of Attachment in AttachmentTest", (boolean)this.dummyAttachment.isComplete());
        this.dummyAttachment.setAttachmentFileName(null);
        Assert.assertFalse((String)"Testing Complete of Attachment in AttachmentTest", (boolean)this.dummyAttachment.isComplete());
        this.dummyAttachment.setAttachmentFileSize(Long.valueOf(0L));
        Assert.assertFalse((String)"Testing Complete of Attachment in AttachmentTest", (boolean)this.dummyAttachment.isComplete());
        this.dummyAttachment.setAttachmentIdentifier(null);
        Assert.assertFalse((String)"Testing Complete of Attachment in AttachmentTest", (boolean)this.dummyAttachment.isComplete());
        this.dummyAttachment.setAttachmentMimeTypeCode(null);
        Assert.assertFalse((String)"Testing Complete of Attachment in AttachmentTest", (boolean)this.dummyAttachment.isComplete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachmentContents() throws Exception {
        try {
            String line;
            FileWriter out = new FileWriter("dummy.txt");
            out.write("Hello testAttachmentContent");
            out.close();
            File dummyFile = new File("dummy.txt");
            Note dummyNote = new Note();
            FileInputStream inStream = new FileInputStream("dummy.txt");
            GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
            Person kualiUser = GlobalVariables.getUserSession().getPerson();
            Note parentNote = KRADServiceLocator.getNoteService().createNote(dummyNote, (PersistableBusinessObject)this.dummyAttachment, kualiUser.getPrincipalId());
            this.dummyAttachment = KRADServiceLocator.getAttachmentService().createAttachment((PersistableBusinessObject)parentNote, "dummy.txt", "MimeTypeCode", (int)dummyFile.length(), (InputStream)inStream, "AttachmentTypeCode");
            String result = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(this.dummyAttachment.getAttachmentContents()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
            ((InputStream)inStream).close();
            Assert.assertEquals((String)"Testing attachmentContents in AttachmentTest", (Object)"Hello testAttachmentContent", (Object)result);
        }
        finally {
            new File("dummy.txt").delete();
        }
    }
}

