/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.fieldlevel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.FixedPointValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.test.BaseRiceTestCase;

public class FixedPointValidationPatternTest
extends BaseRiceTestCase {
    FixedPointValidationPattern pattern;

    @Before
    public final void setUp() throws Exception {
        this.pattern = new FixedPointValidationPattern();
        this.pattern.setPrecision(2);
        this.pattern.setScale(1);
    }

    @Test
    public final void testDefaultAllows_empty() {
        Assert.assertFalse((boolean)this.pattern.matches(""));
    }

    @Test
    public final void testDefaultAllows_positive1() {
        Assert.assertTrue((boolean)this.pattern.matches(".1"));
    }

    @Test
    public final void testDefaultAllows_positive2() {
        Assert.assertTrue((boolean)this.pattern.matches("0.1"));
    }

    @Test
    public final void testDefaultAllows_positive3() {
        Assert.assertTrue((boolean)this.pattern.matches("1.1"));
    }

    @Test
    public final void testDefaultAllows_positive4() {
        Assert.assertTrue((boolean)this.pattern.matches("1"));
    }

    @Test
    public final void testDefaultAllows_positive5() {
        Assert.assertTrue((boolean)this.pattern.matches("1.0"));
    }

    @Test
    public final void testDefaultAllows_negative1() {
        Assert.assertFalse((boolean)this.pattern.matches("-.1"));
    }

    @Test
    public final void testDefaultAllows_negative2() {
        Assert.assertFalse((boolean)this.pattern.matches("-0.1"));
    }

    @Test
    public final void testDefaultAllows_negative3() {
        Assert.assertFalse((boolean)this.pattern.matches("-1.1"));
    }

    @Test
    public final void testDefaultAllows_negative4() {
        Assert.assertFalse((boolean)this.pattern.matches("-1"));
    }

    @Test
    public final void testDefaultAllows_negative5() {
        Assert.assertFalse((boolean)this.pattern.matches("-1.0"));
    }

    @Test
    public final void testDefaultAllows_invalid1() {
        Assert.assertFalse((boolean)this.pattern.matches("-."));
    }

    @Test
    public final void testDefaultAllows_invalid2() {
        Assert.assertFalse((boolean)this.pattern.matches("1."));
    }

    @Test
    public final void testDefaultAllows_invalid3() {
        Assert.assertFalse((boolean)this.pattern.matches("-1."));
    }

    @Test
    public final void testDefaultAllows_invalid4() {
        Assert.assertFalse((boolean)this.pattern.matches("12."));
    }

    @Test
    public final void testDefaultAllows_invalid5() {
        Assert.assertFalse((boolean)this.pattern.matches("1245678901234567890123.23"));
    }

    @Test
    public final void testDefaultAllows_invalid6() {
        Assert.assertFalse((boolean)this.pattern.matches("123"));
    }

    @Test
    public final void testAllowNegative_positive1() {
        Assert.assertTrue((boolean)this.pattern.matches(".1"));
    }

    @Test
    public final void testAllowNegative_positive2() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("0.1"));
    }

    @Test
    public final void testAllowNegative_positive3() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("1.1"));
    }

    @Test
    public final void testAllowNegative_positive4() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("1"));
    }

    @Test
    public final void testAllowNegative_positive5() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("1.0"));
    }

    @Test
    public final void testAllowNegative_negative1() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-.1"));
    }

    @Test
    public final void testAllowNegative_negative2() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-0.1"));
    }

    @Test
    public final void testAllowNegative_negative3() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-1.1"));
    }

    @Test
    public final void testAllowNegative_negative4() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-1"));
    }

    @Test
    public final void testAllowNegative_negative5() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-1.0"));
    }

    @Test
    public final void testAllowNegative_invalid1() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("-."));
    }

    @Test
    public final void testAllowNegative_invalid2() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("1."));
    }

    @Test
    public final void testAllowNegative_invalid3() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("-1."));
    }

    @Test
    public final void testAllowNegative_invalid4() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("-12."));
    }

    @Test
    public final void testAllowNegative_invalid5() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("-1.23"));
    }

    @Test
    public final void testAllowNegative_invalid6() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("123."));
    }

    @Test
    public final void testAllowNegative_invalid7() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches(".123"));
    }

    @Test(expected=ValidationPattern.ValidationPatternException.class)
    public final void testZero_Percision_And_Scale_invalid8() {
        this.pattern.setPrecision(0);
        this.pattern.setScale(0);
        this.pattern.completeValidation();
    }

    @Test(expected=ValidationPattern.ValidationPatternException.class)
    public final void testPrecision_Less_Than_Scale_invalid9() {
        this.pattern.setPrecision(1);
        this.pattern.setScale(3);
        this.pattern.completeValidation();
    }

    @Test(expected=ValidationPattern.ValidationPatternException.class)
    public final void testPrecision_And_Scale_Negative_invalid10() {
        this.pattern.setPrecision(-3);
        this.pattern.setScale(-1);
        this.pattern.completeValidation();
    }
}

