/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.DataTypeConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.DataTypeConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class DataTypeConstraintProcessorTest {
    private DataTypeConstraintProcessor processor;
    private AttributeValueReader attributeValueReader;
    private DataTypeConstraint booleanConstraint;
    private DataTypeConstraint dateConstraint;
    private DataTypeConstraint doubleConstraint;
    private DataTypeConstraint floatConstraint;
    private DataTypeConstraint integerConstraint;
    private DataTypeConstraint longConstraint;
    private DictionaryValidationResult dictionaryValidationResult;
    private String[] testStringToDateFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd", "yyyy-MMM-dd", "dd-MM-yyyy", "dd-MMM-yyyy"};

    @Before
    public void setUp() throws Exception {
        DateTimeServiceImpl dateTimeService = new DateTimeServiceImpl(){

            public Date convertToDate(String dateString) throws ParseException {
                return this.parseAgainstFormatArray(dateString, DataTypeConstraintProcessorTest.this.testStringToDateFormats);
            }
        };
        this.processor = new DataTypeConstraintProcessor();
        this.processor.setDateTimeService((DateTimeService)dateTimeService);
        this.booleanConstraint = new SimpleDataTypeConstraint(DataType.BOOLEAN);
        this.dateConstraint = new SimpleDataTypeConstraint(DataType.DATE);
        this.doubleConstraint = new SimpleDataTypeConstraint(DataType.DOUBLE);
        this.floatConstraint = new SimpleDataTypeConstraint(DataType.FLOAT);
        this.integerConstraint = new SimpleDataTypeConstraint(DataType.INTEGER);
        this.longConstraint = new SimpleDataTypeConstraint(DataType.LONG);
        this.dictionaryValidationResult = new DictionaryValidationResult();
    }

    @Test
    public void testBooleanAsBooleanTrue() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, Boolean.TRUE, this.booleanConstraint);
        this.assertSuccess(validationResult);
    }

    @Test
    public void testBooleanAsBooleanFalse() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, Boolean.FALSE, this.booleanConstraint);
        this.assertSuccess(validationResult);
    }

    @Test
    public void testBooleanAsNull() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, null, this.booleanConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testBooleanAsStringTrue() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "true", this.booleanConstraint);
        this.assertSuccess(validationResult);
    }

    @Test
    public void testBooleanAsStringFalse() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "false", this.booleanConstraint);
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testBooleanAsStringPotato() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "potato", this.booleanConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testIntegerAsString12() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "12", this.integerConstraint);
        this.assertSuccess(validationResult);
    }

    @Test
    public void testIntegerAsOutOfRangeIntegerString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "923423423423423412", this.integerConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testIntegerAsNegativeIntegerString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "-3412", this.integerConstraint);
        this.assertSuccess(validationResult);
    }

    @Test
    public void testIntegerAsNull() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, null, this.integerConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testIntegerAsStringPotato() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "potato", this.integerConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testIntegerAsInteger12() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, 12, this.integerConstraint);
        this.assertSuccess(validationResult);
    }

    @Test
    public void testIntegerAsBigDecimal12() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, BigDecimal.valueOf(12L), this.integerConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testIntegerAsBigDecimal12point32() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, BigDecimal.valueOf(12.32), this.integerConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testLongAsOutOfIntegerRangeString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "923423423423423412", this.longConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testLongAsOutOfIntegerRangeLong() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, 923423423423423412L, this.longConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testLongAsNegativeLong() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, -923423423423423412L, this.longConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDoubleAsPositiveDoubleString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "234897.2323", this.doubleConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDoubleAsNegativeDoubleString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "-234897.2323", this.doubleConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDoubleAsNull() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, null, this.doubleConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDoubleAsNegativeDouble() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, -234897.2323, this.doubleConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDoubleAsOutOfDoubleRangeString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "923423234234423423423412999999999999999999999999e12312321", this.doubleConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDoubleAsNegativeOutOfDoubleRangeString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "-923423234234423423423412999999999999999999999999e99234234", this.doubleConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testFloatAsPositiveFloatString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "234897.2323", this.floatConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testFloatAsNegativeFloatString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "-234897.2323", this.floatConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testFloatAsOutOfFloatRangeString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "923423234234423423423412999999999999999999999999", this.floatConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testFloatAsNegativeOutOfFloatRangeString() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "-923423234234423423423412999999999999999999999999", this.floatConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat1Success() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "2001-07-04T12:08:56.235-0700", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat2Success() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "2001-03-04", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat3Success() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "2001-JUL-12", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat3Failure() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "2001-KUA-12", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat4Success() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "22-12-2001", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat5Success() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "12-AUG-2001", this.dateConstraint);
        this.assertSuccess(validationResult);
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat5Failure() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "12-KUA-2001", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    @Test
    public void testDateAsStringInFormat6Failure() {
        ConstraintValidationResult validationResult = this.process(this.dictionaryValidationResult, "20010704", this.dateConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    protected ConstraintValidationResult process(DictionaryValidationResult result, Object value, DataTypeConstraint constraint) {
        AttributeDefinition definition = new AttributeDefinition();
        definition.setName("testAttribute");
        this.attributeValueReader = new SingleAttributeValueReader(value, "testEntry", "testAttribute", definition);
        return this.processor.process(result, value, constraint, this.attributeValueReader).getFirstConstraintValidationResult();
    }

    protected void assertSuccess(ConstraintValidationResult validationResult) {
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)validationResult.getStatus());
        Assert.assertEquals((Object)new DataTypeConstraintProcessor().getName(), (Object)validationResult.getConstraintName());
    }

    public class SimpleDataTypeConstraint
    implements DataTypeConstraint {
        private DataType dataType;

        public SimpleDataTypeConstraint(DataType dataType) {
            this.dataType = dataType;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }
}

