/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.AccountRequestDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class DocumentServiceTest
extends KRADTestCase {
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    public void tearDown() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testGetNewDocument() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        WorkflowDocument wd = travelDocument.getDocumentHeader().getWorkflowDocument();
        Assert.assertEquals((String)"Initiator should be the current user", (Object)wd.getInitiatorPrincipalId(), (Object)GlobalVariables.getUserSession().getPerson().getPrincipalId());
    }

    @Test
    public void testGetNewDocumentDifferentInitiatorThanCurrentUser() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest", "testuser1");
        WorkflowDocument wd = travelDocument.getDocumentHeader().getWorkflowDocument();
        Assert.assertEquals((String)"Initiator should be testuser1", (Object)wd.getInitiatorPrincipalId(), (Object)"testuser1");
    }

    @Test
    public void testGetNewDocumentInvalidInitiator() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest", "notValidUserAtAll");
        WorkflowDocument wd = travelDocument.getDocumentHeader().getWorkflowDocument();
        Assert.assertEquals((String)"Initiator should be the current user", (Object)wd.getInitiatorPrincipalId(), (Object)GlobalVariables.getUserSession().getPerson().getPrincipalId());
    }
}

