/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.test;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class BaseMaintenanceDocumentTest
extends KRADTestCase {
    private MaintenanceDocument document;
    private String documentTypeName;
    private String initiatorPrincipalName;

    public void setUp() throws Exception {
        block2: {
            super.setUp();
            GlobalVariables.setUserSession((UserSession)new UserSession(this.getInitiatorPrincipalName()));
            try {
                MaintenanceDocument maintenanceDocument = (MaintenanceDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument(this.getDocumentTypeName());
                maintenanceDocument.getDocumentHeader().setDocumentDescription("test maintenance document");
                this.setDocument(maintenanceDocument);
            }
            catch (UnknownDocumentTypeException udte) {
                if (!udte.getMessage().contains("AccountManagerMaintenanceDocument")) break block2;
                Assert.fail((String)("CI failure - https://jira.kuali.org/browse/KULRICE-9285 " + udte.getMessage() + " " + ExceptionUtils.getStackTrace((Throwable)udte)));
            }
        }
    }

    @Before
    public void setUpBeforeTest() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    protected String getDocumentTypeName() {
        return this.documentTypeName;
    }

    protected String getInitiatorPrincipalName() {
        return this.initiatorPrincipalName;
    }

    protected void setupNewAccountMaintDoc(MaintenanceDocument document) {
        Object am = this.getNewMaintainableObject();
        document.getOldMaintainableObject().setDataObject(null);
        document.getOldMaintainableObject().setDataObjectClass(am.getClass());
        document.getNewMaintainableObject().setDataObject(am);
        document.getNewMaintainableObject().setDataObjectClass(am.getClass());
        document.getNewMaintainableObject().setMaintenanceAction("New");
    }

    protected abstract Object getNewMaintainableObject();

    protected abstract Object getOldMaintainableObject();

    protected void setupEditAccountMaintDoc(MaintenanceDocument document) {
        Object newAm = this.getNewMaintainableObject();
        Object oldAm = this.getOldMaintainableObject();
        document.getOldMaintainableObject().setDataObject(oldAm);
        document.getOldMaintainableObject().setDataObjectClass(oldAm.getClass());
        document.getNewMaintainableObject().setDataObject(newAm);
        document.getNewMaintainableObject().setDataObjectClass(newAm.getClass());
        document.getNewMaintainableObject().setMaintenanceAction("Edit");
    }

    @Test
    public void test_NewDoc() {
        this.setupNewAccountMaintDoc(this.getDocument());
        Assert.assertEquals((String)"Document should indicate New.", (Object)true, (Object)this.getDocument().isNew());
        Assert.assertEquals((String)"Document should not indicate Edit.", (Object)false, (Object)this.getDocument().isEdit());
        Assert.assertEquals((String)"Old BO should not be present.", (Object)false, (Object)this.getDocument().isOldDataObjectInDocument());
    }

    @Test
    public void test_EditDoc() {
        this.setupEditAccountMaintDoc(this.getDocument());
        Assert.assertEquals((String)"Document should not indicate New.", (Object)false, (Object)this.getDocument().isNew());
        Assert.assertEquals((String)"Document should indicate Edit.", (Object)true, (Object)this.getDocument().isEdit());
        Assert.assertEquals((String)"Old BO should be present.", (Object)true, (Object)this.getDocument().isOldDataObjectInDocument());
    }

    @Test
    public void test_CopyDoc() {
        this.setupEditAccountMaintDoc(this.getDocument());
        this.getDocument().getNewMaintainableObject().setMaintenanceAction("Copy");
        Assert.assertEquals((String)"Document should indicate New.", (Object)true, (Object)this.getDocument().isNew());
        Assert.assertEquals((String)"Document should not indicate Edit.", (Object)false, (Object)this.getDocument().isEdit());
        Assert.assertEquals((String)"Old BO should be present.", (Object)true, (Object)this.getDocument().isOldDataObjectInDocument());
    }

    @Test
    public void test_SaveNewDoc() throws WorkflowException {
        this.setupNewAccountMaintDoc(this.getDocument());
        KRADServiceLocatorWeb.getDocumentService().saveDocument((Document)this.getDocument());
        Assert.assertTrue((boolean)this.getDocument().getDocumentHeader().getWorkflowDocument().isSaved());
    }

    public MaintenanceDocument getDocument() {
        return this.document;
    }

    public void setDocument(MaintenanceDocument document) {
        this.document = document;
    }
}

