/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewTheme;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.mockito.Mockito;

public class ViewThemeTest
extends KRADTestCase {
    @Test
    public void testManualThemeConfiguration() {
        View view = KRADServiceLocatorWeb.getViewService().getViewById("TestViewTheme1");
        ViewTheme theme = view.getTheme();
        Assert.assertNotNull((Object)theme);
        Assert.assertEquals((long)2L, (long)theme.getMinCssSourceFiles().size());
        Assert.assertEquals((long)2L, (long)theme.getMinScriptSourceFiles().size());
        theme = (ViewTheme)Mockito.spy((Object)theme);
        ((ViewTheme)Mockito.doReturn((Object)true).when((Object)theme)).inDevMode();
        view.setTheme(theme);
        KRADServiceLocatorWeb.getViewService().buildView(view, (Object)new UifFormBase(), new HashMap());
        Assert.assertEquals((long)2L, (long)theme.getCssFiles().size());
        Assert.assertEquals((long)2L, (long)theme.getScriptFiles().size());
        view = KRADServiceLocatorWeb.getViewService().getViewById("TestViewTheme1");
        theme = view.getTheme();
        Assert.assertNotNull((Object)theme);
        theme = (ViewTheme)Mockito.spy((Object)theme);
        ((ViewTheme)Mockito.doReturn((Object)false).when((Object)theme)).inDevMode();
        view.setTheme(theme);
        KRADServiceLocatorWeb.getViewService().buildView(view, (Object)new UifFormBase(), new HashMap());
        Assert.assertEquals((long)1L, (long)theme.getCssFiles().size());
        Assert.assertEquals((long)1L, (long)theme.getScriptFiles().size());
        Assert.assertTrue((boolean)theme.getCssFiles().contains(theme.getMinCssFile()));
        Assert.assertTrue((boolean)theme.getScriptFiles().contains(theme.getMinScriptFile()));
    }
}

