/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.BOContainingPerson;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.widget.Inquiry;

public class InquiryTest
extends KRADTestCase {
    @Test
    public void testBuildInquiryUrl_relatedClass() {
        Inquiry inquiry = new Inquiry();
        inquiry.setParentReadOnly(true);
        inquiry.setInquiryLink(new Link());
        inquiry.setDirectInquiryAction(new Action());
        String baseInquiryUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
        inquiry.setBaseInquiryUrl(baseInquiryUrl);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("principalId", "principalId");
        BOContainingPerson dataObject = new BOContainingPerson();
        dataObject.setPrincipalId("en");
        inquiry.buildInquiryLink((Object)dataObject, "principalId", Person.class, params);
        Assert.assertNotNull((String)"InquiryLink should not be null", (Object)inquiry.getInquiryLink());
        Assert.assertNotNull((String)"InquiryLink's href should not be null", (Object)inquiry.getInquiryLink().getHref());
        String expectedHref = baseInquiryUrl + "/kr-krad/inquiry?principalId=en&methodToCall=start&dataObjectClassName=org.kuali.rice.kim.impl.identity.PersonImpl";
        Assert.assertEquals((String)"InquiryLink's href is not the expected value", (Object)expectedHref, (Object)inquiry.getInquiryLink().getHref());
    }
}

