/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.state.StateMappingBase;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.uif.util.ConstraintStateUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

public class ConstraintStateUtilsTest {
    @Test
    public void testStateValidationUtil() {
        ValidCharactersConstraint genericConstraint = new ValidCharactersConstraint(){};
        ArrayList<String> cStates = new ArrayList<String>();
        cStates.add("state1");
        cStates.add("state3>state5");
        cStates.add("state7+");
        genericConstraint.setStates(cStates);
        StateMappingBase genericStateMapping = new StateMappingBase();
        ArrayList<String> states = new ArrayList<String>();
        states.add("state1");
        states.add("state2");
        states.add("state3");
        states.add("state4");
        states.add("state5");
        states.add("state6");
        states.add("state7");
        states.add("state8");
        genericStateMapping.setStates(states);
        boolean applies = ConstraintStateUtils.constraintAppliesForState((String)"state1", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        Constraint constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state1", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state2", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertFalse((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state2", (StateMapping)genericStateMapping);
        Assert.assertNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state3", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state3", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state4", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state4", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state5", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state5", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state7", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state7", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state8", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state8", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"fake", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertFalse((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"notListed", (StateMapping)genericStateMapping);
        Assert.assertNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState(null, (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, null, (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"", (Constraint)genericConstraint, (StateMapping)genericStateMapping);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState(null, (Constraint)genericConstraint, null);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, null, null);
        Assert.assertNotNull((Object)constraintResult);
        applies = ConstraintStateUtils.constraintAppliesForState((String)"state3", (Constraint)genericConstraint, null);
        Assert.assertTrue((boolean)applies);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state3", null);
        Assert.assertNotNull((Object)constraintResult);
        try {
            applies = ConstraintStateUtils.constraintAppliesForState((String)"state3", (Constraint)genericConstraint, (StateMapping)new StateMappingBase());
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
        ArrayList<2> constraintStateOverrides = new ArrayList<2>();
        final List<String> overrideStates = Arrays.asList("state2", "state3");
        ValidCharactersConstraint override = new ValidCharactersConstraint(){
            {
                this.setStates(overrideStates);
            }
        };
        constraintStateOverrides.add(override);
        genericConstraint.setConstraintStateOverrides(constraintStateOverrides);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state1", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        Assert.assertEquals((Object)genericConstraint, (Object)constraintResult);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state3", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        Assert.assertEquals((Object)override, (Object)constraintResult);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state2", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        Assert.assertEquals((Object)override, (Object)constraintResult);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state4", (StateMapping)genericStateMapping);
        Assert.assertNotNull((Object)constraintResult);
        Assert.assertEquals((Object)genericConstraint, (Object)constraintResult);
        constraintResult = ConstraintStateUtils.getApplicableConstraint((Constraint)genericConstraint, (String)"state6", (StateMapping)genericStateMapping);
        Assert.assertNull((Object)constraintResult);
    }

    @Test
    public void testCustomClientsideUtilMethod() {
        View view = new View();
        StateMappingBase genericStateMapping = new StateMappingBase();
        ArrayList<String> states = new ArrayList<String>();
        states.add("state1");
        states.add("state2");
        states.add("state3");
        states.add("state4");
        states.add("state5");
        states.add("state6");
        states.add("state7");
        states.add("state8");
        genericStateMapping.setStates(states);
        genericStateMapping.setStatePropertyName("state");
        UifFormBase model = new UifFormBase();
        HashMap<String, String> customClientStateMap = new HashMap<String, String>();
        customClientStateMap.put("state1", "state3");
        customClientStateMap.put("state4", "state8");
        customClientStateMap.put("state7", "state7");
        genericStateMapping.setCustomClientSideValidationStates(customClientStateMap);
        view.setStateMapping((StateMapping)genericStateMapping);
        model.setState("state1");
        String state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state3", (Object)state);
        model.setState("state4");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state8", (Object)state);
        model.setState("state7");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state7", (Object)state);
        model.setState("state2");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state3", (Object)state);
        model.setState("state3");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state4", (Object)state);
        model.setState("state5");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state6", (Object)state);
        model.setState("state8");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state8", (Object)state);
        model.setState("fake");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"fake", (Object)state);
        model.setState(null);
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertNull((Object)state);
        model.setState("");
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"", (Object)state);
        model.setState("state1");
        StateMappingBase emptyStateMapping = new StateMappingBase();
        emptyStateMapping.setStatePropertyName("state");
        view.setStateMapping((StateMapping)emptyStateMapping);
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertEquals((Object)"state1", (Object)state);
        view.setStateMapping(null);
        state = ConstraintStateUtils.getClientViewValidationState((Object)model, (View)view);
        Assert.assertNull((Object)state);
    }
}

