/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import edu.sampleu.travel.dataobject.TravelAuthorizationDocumentExtension;
import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelExpenseItem;
import edu.sampleu.travel.dataobject.TravelMileageRate;
import edu.sampleu.travel.dataobject.TravelPerDiemExpense;
import edu.sampleu.travel.dataobject.TravelerDetail;
import edu.sampleu.travel.options.ExpenseType;
import edu.sampleu.travel.options.PostalCountryCode;
import edu.sampleu.travel.options.PostalStateCode;
import edu.sampleu.travel.options.TripType;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class TravelAuthorizationDocumentTest
extends KRADTestCase {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DOCUMENT_DESCRIPTION = "Test Travel Authorization Document";
    private static final String TRIP_BEGIN = "2010-01-01";
    private static final String TRIP_END = "2010-02-01";
    private static final String TRIP_DESCRIPTION = "Test Trip";
    private static final String TRAVEL_TYPE_CODE = TripType.OS.getCode();
    private static final KualiDecimal EXPENSE_LIMIT = new KualiDecimal(10000);
    private static final String CELL_PHONE_NUMBER = "555-555-5555";
    private static String TRAVELER_DETAIL_ID;
    private static final String PRINCIPAL_ID = "admin";
    private static String TRAVEL_DESTINATION_ID;
    private static final String DESTINATION_NAME;
    private static final String COUNTRY_CODE;
    private static final String STATE_CODE;
    private static String MILEAGE_RATE_ID;
    private static final String MILEAGE_RATE_CODE = "DO";
    private static final String MILEAGE_RATE_NAME = "Domestic";
    private static final BigDecimal MILEAGE_RATE;
    private static final String PER_DIEM_DATE = "2010-01-01";
    private static final BigDecimal BREAKFAST_VALUE;
    private static final BigDecimal LUNCH_VALUE;
    private static final BigDecimal DINNER_VALUE;
    private static final BigDecimal INCIDENTALS_VALUE;
    private static final BigDecimal ESTIMATED_MILEAGE;
    private static final String EXPENSE_TYPE;
    private static final String EXPENSE_DESCRIPTION;
    private static final String TRAVEL_COMPANY_NAME = "Zorba's Travel";
    private static final String EXPENSE_DATE = "2010-01-01";
    private static final BigDecimal EXPENSE_AMOUNT;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession(PRINCIPAL_ID));
        TravelerDetail newTravelerDetail = new TravelerDetail();
        newTravelerDetail.setPrincipalId(PRINCIPAL_ID);
        TRAVELER_DETAIL_ID = ((TravelerDetail)KRADServiceLocator.getDataObjectService().save((Object)newTravelerDetail, new PersistenceOption[]{PersistenceOption.FLUSH})).getId();
        TravelDestination newTravelDestination = new TravelDestination();
        newTravelDestination.setTravelDestinationName(DESTINATION_NAME);
        newTravelDestination.setCountryCd(COUNTRY_CODE);
        newTravelDestination.setStateCd(STATE_CODE);
        TRAVEL_DESTINATION_ID = ((TravelDestination)KRADServiceLocator.getDataObjectService().save((Object)newTravelDestination, new PersistenceOption[]{PersistenceOption.FLUSH})).getTravelDestinationId();
        TravelMileageRate newTravelMileageRate = new TravelMileageRate();
        newTravelMileageRate.setMileageRateCd(MILEAGE_RATE_CODE);
        newTravelMileageRate.setMileageRateName(MILEAGE_RATE_NAME);
        newTravelMileageRate.setMileageRate(MILEAGE_RATE);
        MILEAGE_RATE_ID = ((TravelMileageRate)KRADServiceLocator.getDataObjectService().save((Object)newTravelMileageRate, new PersistenceOption[]{PersistenceOption.FLUSH})).getMileageRateId();
    }

    @Override
    public void tearDown() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testTravelExpenseItem() throws Exception {
        Assert.assertTrue((String)(TravelExpenseItem.class.getName() + " is not mapped in JPA"), (boolean)KRADServiceLocator.getDataObjectService().supports(TravelAuthorizationDocument.class));
        String id = this.createAndSaveTravelAuthorizationDocument().getDocumentNumber();
        TravelAuthorizationDocument document = (TravelAuthorizationDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(id);
        String documentNumber = document.getDocumentNumber();
        Assert.assertNotNull((String)"Travel Authorization Document is null", (Object)document);
        Assert.assertNotNull((String)"Travel Authorization Document ID is null", (Object)documentNumber);
        Assert.assertEquals((String)"Travel Authorization Document trip begin is incorrect", (Object)DATE_FORMAT.parse("2010-01-01"), (Object)document.getTripBegin());
        Assert.assertEquals((String)"Travel Authorization Document trip end is incorrect", (Object)DATE_FORMAT.parse(TRIP_END), (Object)document.getTripEnd());
        Assert.assertEquals((String)"Travel Authorization Document trip description is incorrect", (Object)TRIP_DESCRIPTION, (Object)document.getTripDescription());
        Assert.assertEquals((String)"Travel Authorization Document trip destination ID is incorrect", (Object)TRAVEL_DESTINATION_ID, (Object)document.getTripDestinationId());
        Assert.assertEquals((String)"Travel Authorization Document traveler detail ID is incorrect", (Object)TRAVELER_DETAIL_ID, (Object)document.getTravelerDetailId());
        Assert.assertEquals((String)"Travel Authorization Document travel type code is incorrect", (Object)TRAVEL_TYPE_CODE, (Object)document.getTravelTypeCode());
        Assert.assertEquals((String)"Travel Authorization Document expense limit is incorrect", (Object)EXPENSE_LIMIT, (Object)document.getExpenseLimit());
        Assert.assertEquals((String)"Travel Authorization Document cell phone number is incorrect", (Object)CELL_PHONE_NUMBER, (Object)document.getCellPhoneNumber());
        Assert.assertTrue((String)"Travel Authorization Document daily expense estimates is empty", (!document.getDailyExpenseEstimates().isEmpty() ? 1 : 0) != 0);
        TravelPerDiemExpense travelPerDiemExpense = (TravelPerDiemExpense)document.getDailyExpenseEstimates().get(0);
        String travelPerDiemExpenseDocumentNumber = travelPerDiemExpense.getTravelAuthorizationDocumentId();
        Assert.assertEquals((String)"Travel Per Diem Expense document ID is incorrect", (Object)travelPerDiemExpenseDocumentNumber, (Object)documentNumber);
        Assert.assertTrue((String)"Travel Authorization Document actual expense items is empty", (!document.getActualExpenseItems().isEmpty() ? 1 : 0) != 0);
        TravelExpenseItem travelExpenseItem = (TravelExpenseItem)document.getActualExpenseItems().get(0);
        String travelExpenseItemDocumentNumber = travelExpenseItem.getTravelAuthorizationDocumentId();
        Assert.assertEquals((String)"Travel Expense Item document ID is incorrect", (Object)travelExpenseItemDocumentNumber, (Object)documentNumber);
    }

    private TravelAuthorizationDocument createAndSaveTravelAuthorizationDocument() throws Exception {
        Document newDocument = KRADServiceLocatorWeb.getDocumentService().getNewDocument(TravelAuthorizationDocument.class);
        newDocument.getDocumentHeader().setDocumentDescription(DOCUMENT_DESCRIPTION);
        TravelAuthorizationDocument newTravelAuthorizationDocument = (TravelAuthorizationDocument)newDocument;
        newTravelAuthorizationDocument.setTripBegin((java.util.Date)new Date(DATE_FORMAT.parse("2010-01-01").getTime()));
        newTravelAuthorizationDocument.setTripEnd((java.util.Date)new Date(DATE_FORMAT.parse(TRIP_END).getTime()));
        newTravelAuthorizationDocument.setTripDescription(TRIP_DESCRIPTION);
        newTravelAuthorizationDocument.setTripDestinationId(TRAVEL_DESTINATION_ID);
        newTravelAuthorizationDocument.setTravelerDetailId(TRAVELER_DETAIL_ID);
        newTravelAuthorizationDocument.setTravelTypeCode(TRAVEL_TYPE_CODE);
        newTravelAuthorizationDocument.setExpenseLimit(EXPENSE_LIMIT);
        newTravelAuthorizationDocument.setCellPhoneNumber(CELL_PHONE_NUMBER);
        TravelPerDiemExpense travelPerDiemExpense = new TravelPerDiemExpense();
        travelPerDiemExpense.setTravelAuthorizationDocumentId(newTravelAuthorizationDocument.getDocumentNumber());
        travelPerDiemExpense.setTravelDestinationId(TRAVEL_DESTINATION_ID);
        travelPerDiemExpense.setPerDiemDate(DATE_FORMAT.parse("2010-01-01"));
        travelPerDiemExpense.setBreakfastValue(BREAKFAST_VALUE);
        travelPerDiemExpense.setLunchValue(LUNCH_VALUE);
        travelPerDiemExpense.setDinnerValue(DINNER_VALUE);
        travelPerDiemExpense.setIncidentalsValue(INCIDENTALS_VALUE);
        travelPerDiemExpense.setMileageRateId(MILEAGE_RATE_ID);
        travelPerDiemExpense.setEstimatedMileage(ESTIMATED_MILEAGE);
        newTravelAuthorizationDocument.getDailyExpenseEstimates().add(travelPerDiemExpense);
        TravelExpenseItem travelExpenseItem = new TravelExpenseItem();
        travelExpenseItem.setTravelAuthorizationDocumentId(newTravelAuthorizationDocument.getDocumentNumber());
        travelExpenseItem.setTravelExpenseTypeCd(EXPENSE_TYPE);
        travelExpenseItem.setExpenseDesc(EXPENSE_DESCRIPTION);
        travelExpenseItem.setTravelCompanyName(TRAVEL_COMPANY_NAME);
        travelExpenseItem.setExpenseDate(DATE_FORMAT.parse("2010-01-01"));
        travelExpenseItem.setExpenseAmount(EXPENSE_AMOUNT);
        travelExpenseItem.setReimbursable(true);
        travelExpenseItem.setTaxable(false);
        newTravelAuthorizationDocument.getActualExpenseItems().add(travelExpenseItem);
        newTravelAuthorizationDocument.setExtension((Object)new TravelAuthorizationDocumentExtension());
        ((TravelAuthorizationDocumentExtension)newTravelAuthorizationDocument.getExtension()).setAnotherProperty("Test Value");
        return (TravelAuthorizationDocument)KRADServiceLocatorWeb.getDocumentService().saveDocument((Document)newTravelAuthorizationDocument);
    }

    @Test
    public void testDocumentExtension() throws Exception {
        TravelAuthorizationDocument document = this.createAndSaveTravelAuthorizationDocument();
        Assert.assertNotNull((String)"extension missing after save", (Object)document.getExtension());
        Assert.assertNotNull((String)"extension does not have document after save", (Object)((TravelAuthorizationDocumentExtension)document.getExtension()).getDocument());
        Assert.assertNotNull((String)"extension does not have document number after save", (Object)((TravelAuthorizationDocumentExtension)document.getExtension()).getDocumentNumber());
        Assert.assertEquals((String)"Document number not set in extension after save", (Object)document.getDocumentNumber(), (Object)((TravelAuthorizationDocumentExtension)document.getExtension()).getDocumentNumber());
    }

    static {
        DESTINATION_NAME = PostalStateCode.CA.getLabel();
        COUNTRY_CODE = PostalCountryCode.US.getCode();
        STATE_CODE = PostalStateCode.CA.getCode();
        MILEAGE_RATE = new BigDecimal("1994.88");
        BREAKFAST_VALUE = new BigDecimal("15.00");
        LUNCH_VALUE = new BigDecimal("30.00");
        DINNER_VALUE = new BigDecimal("45.00");
        INCIDENTALS_VALUE = new BigDecimal("15.00");
        ESTIMATED_MILEAGE = new BigDecimal("50");
        EXPENSE_TYPE = ExpenseType.A.getCode();
        EXPENSE_DESCRIPTION = ExpenseType.A.getLabel();
        EXPENSE_AMOUNT = new BigDecimal("1236.49");
    }
}

