/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.options.PostalCountryCode;
import edu.sampleu.travel.options.PostalStateCode;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class TravelDestinationTest
extends KRADTestCase {
    private static final String DESTINATION_NAME = PostalStateCode.PR.getLabel();
    private static final String COUNTRY_CODE = PostalCountryCode.US.getCode();
    private static final String STATE_CODE = PostalStateCode.PR.getCode();

    @Test
    public void testTravelDestination() {
        Assert.assertTrue((String)(TravelDestination.class.getName() + " is not mapped in JPA"), (boolean)KRADServiceLocator.getDataObjectService().supports(TravelDestination.class));
        String id = this.createTravelDestination();
        TravelDestination travelDestination = (TravelDestination)KRADServiceLocator.getDataObjectService().find(TravelDestination.class, (Object)id);
        Assert.assertNotNull((String)"Travel Destination ID is null", (Object)travelDestination.getTravelDestinationId());
        Assert.assertEquals((String)"Travel Destination name is incorrect", (Object)DESTINATION_NAME, (Object)travelDestination.getTravelDestinationName());
        Assert.assertEquals((String)"Travel Destination country is incorrect", (Object)COUNTRY_CODE, (Object)travelDestination.getCountryCd());
        Assert.assertEquals((String)"Travel Destination state is incorrect", (Object)STATE_CODE, (Object)travelDestination.getStateCd());
        Assert.assertTrue((String)"Travel Destination is not active", (boolean)travelDestination.isActive());
    }

    private String createTravelDestination() {
        TravelDestination travelDestination = new TravelDestination();
        travelDestination.setTravelDestinationName(DESTINATION_NAME);
        travelDestination.setCountryCd(COUNTRY_CODE);
        travelDestination.setStateCd(STATE_CODE);
        travelDestination.setActive(true);
        return ((TravelDestination)KRADServiceLocator.getDataObjectService().save((Object)travelDestination, new PersistenceOption[0])).getTravelDestinationId();
    }
}

