/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data;

import java.util.Date;
import java.util.LinkedHashMap;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.testbo.AnotherReferencedDataObject;
import org.kuali.rice.krad.data.jpa.testbo.ReferencedDataObject;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.jpa.testbo.YetAnotherReferencedDataObject;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class DataObjectWrapperIntegrationTest
extends KRADTestCase {
    @Test
    public void testRefreshRelationship_MultipleForeignKeys() {
        TestDataObject testDataObject = new TestDataObject();
        testDataObject.setPrimaryKeyProperty("abc");
        testDataObject = (TestDataObject)this.getDataObjectService().save((Object)testDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"abc", (Object)testDataObject.getPrimaryKeyProperty());
        Assert.assertNull((Object)testDataObject.getReferencedObject());
        Assert.assertNull((Object)testDataObject.getStringProperty());
        DataObjectWrapper wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        wrapper.fetchRelationship("referencedObject");
        Assert.assertNull((Object)testDataObject.getReferencedObject());
        Assert.assertNull((Object)testDataObject.getStringProperty());
        ReferencedDataObject referencedDataObject = new ReferencedDataObject();
        referencedDataObject.setStringProperty("cba");
        referencedDataObject.setSomeOtherStringProperty("efg");
        referencedDataObject = (ReferencedDataObject)this.getDataObjectService().save((Object)referencedDataObject, new PersistenceOption[0]);
        testDataObject.setStringProperty("cba");
        Assert.assertNull((Object)testDataObject.getReferencedObject());
        wrapper.fetchRelationship("referencedObject");
        Assert.assertNotNull((Object)testDataObject.getReferencedObject());
        Assert.assertEquals((Object)"efg", (Object)testDataObject.getReferencedObject().getSomeOtherStringProperty());
        referencedDataObject = (ReferencedDataObject)this.getDataObjectService().find(ReferencedDataObject.class, (Object)"cba");
        Assert.assertEquals((Object)"efg", (Object)referencedDataObject.getSomeOtherStringProperty());
        referencedDataObject.setSomeOtherStringProperty("efg2");
        this.getDataObjectService().save((Object)referencedDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"efg", (Object)testDataObject.getReferencedObject().getSomeOtherStringProperty());
        wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        wrapper.fetchRelationship("referencedObject");
        Assert.assertEquals((Object)"efg2", (Object)testDataObject.getReferencedObject().getSomeOtherStringProperty());
        ReferencedDataObject referencedDataObject2 = new ReferencedDataObject();
        referencedDataObject2.setStringProperty("cba2");
        referencedDataObject2.setSomeOtherStringProperty("efg3");
        this.getDataObjectService().save((Object)referencedDataObject2, new PersistenceOption[0]);
        testDataObject.setStringProperty("cba2");
        wrapper.fetchRelationship("referencedObject");
        Assert.assertEquals((Object)"cba2", (Object)testDataObject.getReferencedObject().getStringProperty());
        Assert.assertEquals((Object)"efg3", (Object)testDataObject.getReferencedObject().getSomeOtherStringProperty());
        testDataObject.setStringProperty(null);
        Assert.assertNotNull((Object)testDataObject.getReferencedObject());
        wrapper.fetchRelationship("referencedObject");
        Assert.assertNull((Object)testDataObject.getReferencedObject());
    }

    @Test
    public void testRefreshRelationship_CompoundForeignKeys() {
        TestDataObject testDataObject = new TestDataObject();
        testDataObject.setPrimaryKeyProperty("abc");
        testDataObject = (TestDataObject)this.getDataObjectService().save((Object)testDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"abc", (Object)testDataObject.getPrimaryKeyProperty());
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
        Assert.assertNull((Object)testDataObject.getStringProperty());
        Assert.assertNull((Object)testDataObject.getDateProperty());
        DataObjectWrapper wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
        Assert.assertNull((Object)testDataObject.getStringProperty());
        Assert.assertNull((Object)testDataObject.getDateProperty());
        Date date = this.newDateWithTimeAtStartOfDay();
        AnotherReferencedDataObject referencedDataObject = new AnotherReferencedDataObject();
        referencedDataObject.setStringProperty("cba");
        referencedDataObject.setDateProperty(date);
        referencedDataObject.setSomeOtherStringProperty("efg");
        referencedDataObject = (AnotherReferencedDataObject)this.getDataObjectService().save((Object)referencedDataObject, new PersistenceOption[0]);
        testDataObject.setStringProperty("cba");
        testDataObject.setDateProperty(date);
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertNotNull((Object)testDataObject.getAnotherReferencedObject());
        Assert.assertEquals((Object)"efg", (Object)testDataObject.getAnotherReferencedObject().getSomeOtherStringProperty());
        LinkedHashMap<String, Object> compoundKey = new LinkedHashMap<String, Object>();
        compoundKey.put("stringProperty", "cba");
        compoundKey.put("dateProperty", date);
        referencedDataObject = (AnotherReferencedDataObject)this.getDataObjectService().find(AnotherReferencedDataObject.class, (Object)new CompoundKey(compoundKey));
        Assert.assertEquals((Object)"efg", (Object)referencedDataObject.getSomeOtherStringProperty());
        referencedDataObject.setSomeOtherStringProperty("efg2");
        this.getDataObjectService().save((Object)referencedDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"efg", (Object)testDataObject.getAnotherReferencedObject().getSomeOtherStringProperty());
        wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertEquals((Object)"efg2", (Object)testDataObject.getAnotherReferencedObject().getSomeOtherStringProperty());
        AnotherReferencedDataObject referencedDataObject2 = new AnotherReferencedDataObject();
        referencedDataObject2.setStringProperty("cba2");
        Date date2 = this.newDateWithTimeAtStartOfDay();
        referencedDataObject2.setDateProperty(date2);
        referencedDataObject2.setSomeOtherStringProperty("efg3");
        this.getDataObjectService().save((Object)referencedDataObject2, new PersistenceOption[0]);
        testDataObject.setStringProperty("cba2");
        testDataObject.setDateProperty(date2);
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertEquals((Object)"cba2", (Object)testDataObject.getAnotherReferencedObject().getStringProperty());
        Assert.assertEquals((Object)date2, (Object)testDataObject.getAnotherReferencedObject().getDateProperty());
        Assert.assertEquals((Object)"efg3", (Object)testDataObject.getAnotherReferencedObject().getSomeOtherStringProperty());
        testDataObject.setStringProperty(null);
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
        testDataObject.setStringProperty("cba2");
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertNotNull((Object)testDataObject.getAnotherReferencedObject());
        testDataObject.setStringProperty(null);
        testDataObject.setDateProperty(null);
        wrapper.fetchRelationship("anotherReferencedObject");
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
    }

    private Date newDateWithTimeAtStartOfDay() {
        return DateTime.now().withTimeAtStartOfDay().toDate();
    }

    @Test
    public void testRefreshRelationship_OneToOne_SingleForeignKey() {
        TestDataObject testDataObject = new TestDataObject();
        testDataObject.setPrimaryKeyProperty("abc");
        testDataObject = (TestDataObject)this.getDataObjectService().save((Object)testDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"abc", (Object)testDataObject.getPrimaryKeyProperty());
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
        DataObjectWrapper wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        wrapper.fetchRelationship("yetAnotherReferencedObject");
        Assert.assertNull((Object)testDataObject.getAnotherReferencedObject());
        YetAnotherReferencedDataObject referencedDataObject = new YetAnotherReferencedDataObject();
        referencedDataObject.setId("abc");
        referencedDataObject.setSomeOtherStringProperty("efg");
        referencedDataObject = (YetAnotherReferencedDataObject)this.getDataObjectService().save((Object)referencedDataObject, new PersistenceOption[0]);
        Assert.assertNull((Object)testDataObject.getYetAnotherReferencedObject());
        wrapper.fetchRelationship("yetAnotherReferencedObject");
        Assert.assertNotNull((Object)testDataObject.getYetAnotherReferencedObject());
        Assert.assertEquals((Object)"efg", (Object)testDataObject.getYetAnotherReferencedObject().getSomeOtherStringProperty());
        referencedDataObject = (YetAnotherReferencedDataObject)this.getDataObjectService().find(YetAnotherReferencedDataObject.class, (Object)"abc");
        Assert.assertEquals((Object)"efg", (Object)referencedDataObject.getSomeOtherStringProperty());
        referencedDataObject.setSomeOtherStringProperty("efg2");
        referencedDataObject = (YetAnotherReferencedDataObject)this.getDataObjectService().save((Object)referencedDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"efg", (Object)testDataObject.getYetAnotherReferencedObject().getSomeOtherStringProperty());
        wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        wrapper.fetchRelationship("yetAnotherReferencedObject");
        Assert.assertEquals((Object)"efg2", (Object)testDataObject.getYetAnotherReferencedObject().getSomeOtherStringProperty());
        Assert.assertEquals((Object)"abc", (Object)testDataObject.getPrimaryKeyProperty());
    }

    @Test
    public void testRefreshRelationship_ErrorCases() {
        TestDataObject testDataObject = new TestDataObject();
        testDataObject.setPrimaryKeyProperty("abc");
        testDataObject = (TestDataObject)this.getDataObjectService().save((Object)testDataObject, new PersistenceOption[0]);
        Assert.assertEquals((Object)"abc", (Object)testDataObject.getPrimaryKeyProperty());
        DataObjectWrapper wrapper = this.getDataObjectService().wrap((Object)testDataObject);
        try {
            wrapper.fetchRelationship("badReferenceName");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            wrapper.fetchRelationship("");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        testDataObject.setStringProperty("thisDontPointToNuthin!");
        Assert.assertEquals((Object)"thisDontPointToNuthin!", (Object)testDataObject.getStringProperty());
        Assert.assertNull((Object)testDataObject.getReferencedObject());
    }

    private DataObjectService getDataObjectService() {
        return KradDataServiceLocator.getDataObjectService();
    }
}

