/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class FilterGeneratorCoersionTest
extends KRADTestCase {
    @Test
    public void testPrimitiveCharacterMatch() throws Exception {
        PrimitiveCharacterFilterGeneratorParent parent = new PrimitiveCharacterFilterGeneratorParent();
        parent.setCharProp('Y');
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveCharacterFilterGeneratorChild child = new PrimitiveCharacterFilterGeneratorChild();
        child.setCharProp(parent.getCharProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveCharacterFilterGeneratorParent)this.getDataObjectService().find(PrimitiveCharacterFilterGeneratorParent.class, (Object)Character.valueOf(parent.getCharProp()));
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getCharPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveCharacterNoMatch() throws Exception {
        PrimitiveCharacterFilterGeneratorParent parent = new PrimitiveCharacterFilterGeneratorParent();
        parent.setCharProp('N');
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveCharacterFilterGeneratorChild child = new PrimitiveCharacterFilterGeneratorChild();
        child.setCharProp(parent.getCharProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveCharacterFilterGeneratorParent)this.getDataObjectService().find(PrimitiveCharacterFilterGeneratorParent.class, (Object)Character.valueOf(parent.getCharProp()));
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getCharPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperCharacterMatch() throws Exception {
        WrapperCharacterFilterGeneratorParent parent = new WrapperCharacterFilterGeneratorParent();
        parent.setCharProp(Character.valueOf('Y'));
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperCharacterFilterGeneratorChild child = new WrapperCharacterFilterGeneratorChild();
        child.setCharProp(parent.getCharProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperCharacterFilterGeneratorParent)this.getDataObjectService().find(WrapperCharacterFilterGeneratorParent.class, (Object)parent.getCharProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getCharPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperCharacterNoMatch() throws Exception {
        WrapperCharacterFilterGeneratorParent parent = new WrapperCharacterFilterGeneratorParent();
        parent.setCharProp(Character.valueOf('N'));
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperCharacterFilterGeneratorChild child = new WrapperCharacterFilterGeneratorChild();
        child.setCharProp(parent.getCharProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperCharacterFilterGeneratorParent)this.getDataObjectService().find(WrapperCharacterFilterGeneratorParent.class, (Object)parent.getCharProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getCharPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveBooleanMatch() throws Exception {
        PrimitiveBooleanFilterGeneratorParent parent = new PrimitiveBooleanFilterGeneratorParent();
        parent.setBoolProp(true);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveBooleanFilterGeneratorChild child = new PrimitiveBooleanFilterGeneratorChild();
        child.setBoolProp(parent.getBoolProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveBooleanFilterGeneratorParent)this.getDataObjectService().find(PrimitiveBooleanFilterGeneratorParent.class, (Object)parent.getBoolProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getBoolPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveBooleanNoMatch() throws Exception {
        PrimitiveBooleanFilterGeneratorParent parent = new PrimitiveBooleanFilterGeneratorParent();
        parent.setBoolProp(false);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveBooleanFilterGeneratorChild child = new PrimitiveBooleanFilterGeneratorChild();
        child.setBoolProp(parent.getBoolProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveBooleanFilterGeneratorParent)this.getDataObjectService().find(PrimitiveBooleanFilterGeneratorParent.class, (Object)parent.getBoolProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getBoolPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperBooleanMatch() throws Exception {
        WrapperBooleanFilterGeneratorParent parent = new WrapperBooleanFilterGeneratorParent();
        parent.setBoolProp(Boolean.TRUE);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperBooleanFilterGeneratorChild child = new WrapperBooleanFilterGeneratorChild();
        child.setBoolProp(parent.getBoolProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperBooleanFilterGeneratorParent)this.getDataObjectService().find(WrapperBooleanFilterGeneratorParent.class, (Object)parent.getBoolProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getBoolPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperBooleanNoMatch() throws Exception {
        WrapperBooleanFilterGeneratorParent parent = new WrapperBooleanFilterGeneratorParent();
        parent.setBoolProp(Boolean.FALSE);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperBooleanFilterGeneratorChild child = new WrapperBooleanFilterGeneratorChild();
        child.setBoolProp(parent.getBoolProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperBooleanFilterGeneratorParent)this.getDataObjectService().find(WrapperBooleanFilterGeneratorParent.class, (Object)parent.getBoolProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getBoolPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveShortMatch() throws Exception {
        PrimitiveShortFilterGeneratorParent parent = new PrimitiveShortFilterGeneratorParent();
        parent.setShortProp((short)10);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveShortFilterGeneratorChild child = new PrimitiveShortFilterGeneratorChild();
        child.setShortProp(parent.getShortProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveShortFilterGeneratorParent)this.getDataObjectService().find(PrimitiveShortFilterGeneratorParent.class, (Object)parent.getShortProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getShortPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveShortNoMatch() throws Exception {
        PrimitiveShortFilterGeneratorParent parent = new PrimitiveShortFilterGeneratorParent();
        parent.setShortProp((short)20);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveShortFilterGeneratorChild child = new PrimitiveShortFilterGeneratorChild();
        child.setShortProp(parent.getShortProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveShortFilterGeneratorParent)this.getDataObjectService().find(PrimitiveShortFilterGeneratorParent.class, (Object)parent.getShortProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getShortPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperShortMatch() throws Exception {
        WrapperShortFilterGeneratorParent parent = new WrapperShortFilterGeneratorParent();
        parent.setShortProp((short)10);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperShortFilterGeneratorChild child = new WrapperShortFilterGeneratorChild();
        child.setShortProp(parent.getShortProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperShortFilterGeneratorParent)this.getDataObjectService().find(WrapperShortFilterGeneratorParent.class, (Object)parent.getShortProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getShortPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperShortNoMatch() throws Exception {
        WrapperShortFilterGeneratorParent parent = new WrapperShortFilterGeneratorParent();
        parent.setShortProp((short)20);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperShortFilterGeneratorChild child = new WrapperShortFilterGeneratorChild();
        child.setShortProp(parent.getShortProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperShortFilterGeneratorParent)this.getDataObjectService().find(WrapperShortFilterGeneratorParent.class, (Object)parent.getShortProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getShortPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveIntegerMatch() throws Exception {
        PrimitiveIntegerFilterGeneratorParent parent = new PrimitiveIntegerFilterGeneratorParent();
        parent.setIntProp(10);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveIntegerFilterGeneratorChild child = new PrimitiveIntegerFilterGeneratorChild();
        child.setIntProp(parent.getIntProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveIntegerFilterGeneratorParent)this.getDataObjectService().find(PrimitiveIntegerFilterGeneratorParent.class, (Object)parent.getIntProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getIntPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveIntegerNoMatch() throws Exception {
        PrimitiveIntegerFilterGeneratorParent parent = new PrimitiveIntegerFilterGeneratorParent();
        parent.setIntProp(20);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveIntegerFilterGeneratorChild child = new PrimitiveIntegerFilterGeneratorChild();
        child.setIntProp(parent.getIntProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveIntegerFilterGeneratorParent)this.getDataObjectService().find(PrimitiveIntegerFilterGeneratorParent.class, (Object)parent.getIntProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getIntPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperIntegerMatch() throws Exception {
        WrapperIntegerFilterGeneratorParent parent = new WrapperIntegerFilterGeneratorParent();
        parent.setIntProp(10);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperIntegerFilterGeneratorChild child = new WrapperIntegerFilterGeneratorChild();
        child.setIntProp(parent.getIntProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperIntegerFilterGeneratorParent)this.getDataObjectService().find(WrapperIntegerFilterGeneratorParent.class, (Object)parent.getIntProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getIntPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperIntegerNoMatch() throws Exception {
        WrapperIntegerFilterGeneratorParent parent = new WrapperIntegerFilterGeneratorParent();
        parent.setIntProp(20);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperIntegerFilterGeneratorChild child = new WrapperIntegerFilterGeneratorChild();
        child.setIntProp(parent.getIntProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperIntegerFilterGeneratorParent)this.getDataObjectService().find(WrapperIntegerFilterGeneratorParent.class, (Object)parent.getIntProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getIntPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveLongMatch() throws Exception {
        PrimitiveLongFilterGeneratorParent parent = new PrimitiveLongFilterGeneratorParent();
        parent.setLongProp(10L);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveLongFilterGeneratorChild child = new PrimitiveLongFilterGeneratorChild();
        child.setLongProp(parent.getLongProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveLongFilterGeneratorParent)this.getDataObjectService().find(PrimitiveLongFilterGeneratorParent.class, (Object)parent.getLongProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getLongPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveLongNoMatch() throws Exception {
        PrimitiveLongFilterGeneratorParent parent = new PrimitiveLongFilterGeneratorParent();
        parent.setLongProp(20L);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveLongFilterGeneratorChild child = new PrimitiveLongFilterGeneratorChild();
        child.setLongProp(parent.getLongProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveLongFilterGeneratorParent)this.getDataObjectService().find(PrimitiveLongFilterGeneratorParent.class, (Object)parent.getLongProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getLongPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperLongMatch() throws Exception {
        WrapperLongFilterGeneratorParent parent = new WrapperLongFilterGeneratorParent();
        parent.setLongProp(10L);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperLongFilterGeneratorChild child = new WrapperLongFilterGeneratorChild();
        child.setLongProp(parent.getLongProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperLongFilterGeneratorParent)this.getDataObjectService().find(WrapperLongFilterGeneratorParent.class, (Object)parent.getLongProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getLongPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperLongNoMatch() throws Exception {
        WrapperLongFilterGeneratorParent parent = new WrapperLongFilterGeneratorParent();
        parent.setLongProp(20L);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperLongFilterGeneratorChild child = new WrapperLongFilterGeneratorChild();
        child.setLongProp(parent.getLongProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperLongFilterGeneratorParent)this.getDataObjectService().find(WrapperLongFilterGeneratorParent.class, (Object)parent.getLongProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getLongPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveFloatMatch() throws Exception {
        PrimitiveFloatFilterGeneratorParent parent = new PrimitiveFloatFilterGeneratorParent();
        parent.setFloatProp(10.0f);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveFloatFilterGeneratorChild child = new PrimitiveFloatFilterGeneratorChild();
        child.setFloatProp(parent.getFloatProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveFloatFilterGeneratorParent)this.getDataObjectService().find(PrimitiveFloatFilterGeneratorParent.class, (Object)Float.valueOf(parent.getFloatProp()));
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getFloatPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveFloatNoMatch() throws Exception {
        PrimitiveFloatFilterGeneratorParent parent = new PrimitiveFloatFilterGeneratorParent();
        parent.setFloatProp(20.0f);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveFloatFilterGeneratorChild child = new PrimitiveFloatFilterGeneratorChild();
        child.setFloatProp(parent.getFloatProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveFloatFilterGeneratorParent)this.getDataObjectService().find(PrimitiveFloatFilterGeneratorParent.class, (Object)Float.valueOf(parent.getFloatProp()));
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getFloatPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperFloatMatch() throws Exception {
        WrapperFloatFilterGeneratorParent parent = new WrapperFloatFilterGeneratorParent();
        parent.setFloatProp(Float.valueOf(10.0f));
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperFloatFilterGeneratorChild child = new WrapperFloatFilterGeneratorChild();
        child.setFloatProp(parent.getFloatProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperFloatFilterGeneratorParent)this.getDataObjectService().find(WrapperFloatFilterGeneratorParent.class, (Object)parent.getFloatProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getFloatPropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperFloatNoMatch() throws Exception {
        WrapperFloatFilterGeneratorParent parent = new WrapperFloatFilterGeneratorParent();
        parent.setFloatProp(Float.valueOf(20.0f));
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperFloatFilterGeneratorChild child = new WrapperFloatFilterGeneratorChild();
        child.setFloatProp(parent.getFloatProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperFloatFilterGeneratorParent)this.getDataObjectService().find(WrapperFloatFilterGeneratorParent.class, (Object)parent.getFloatProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getFloatPropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveDoubleMatch() throws Exception {
        PrimitiveDoubleFilterGeneratorParent parent = new PrimitiveDoubleFilterGeneratorParent();
        parent.setDoubleProp(10.0);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveDoubleFilterGeneratorChild child = new PrimitiveDoubleFilterGeneratorChild();
        child.setDoubleProp(parent.getDoubleProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveDoubleFilterGeneratorParent)this.getDataObjectService().find(PrimitiveDoubleFilterGeneratorParent.class, (Object)parent.getDoubleProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getDoublePropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testPrimitiveDoubleNoMatch() throws Exception {
        PrimitiveDoubleFilterGeneratorParent parent = new PrimitiveDoubleFilterGeneratorParent();
        parent.setDoubleProp(20.0);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        PrimitiveDoubleFilterGeneratorChild child = new PrimitiveDoubleFilterGeneratorChild();
        child.setDoubleProp(parent.getDoubleProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (PrimitiveDoubleFilterGeneratorParent)this.getDataObjectService().find(PrimitiveDoubleFilterGeneratorParent.class, (Object)parent.getDoubleProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getDoublePropChild() == null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperDoubleMatch() throws Exception {
        WrapperDoubleFilterGeneratorParent parent = new WrapperDoubleFilterGeneratorParent();
        parent.setDoubleProp(10.0);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperDoubleFilterGeneratorChild child = new WrapperDoubleFilterGeneratorChild();
        child.setDoubleProp(parent.getDoubleProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperDoubleFilterGeneratorParent)this.getDataObjectService().find(WrapperDoubleFilterGeneratorParent.class, (Object)parent.getDoubleProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"No matching child found", (parent.getDoublePropChild() != null ? 1 : 0) != 0);
    }

    @Test
    public void testWrapperDoubleNoMatch() throws Exception {
        WrapperDoubleFilterGeneratorParent parent = new WrapperDoubleFilterGeneratorParent();
        parent.setDoubleProp(20.0);
        this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        WrapperDoubleFilterGeneratorChild child = new WrapperDoubleFilterGeneratorChild();
        child.setDoubleProp(parent.getDoubleProp());
        this.getDataObjectService().save((Object)child, new PersistenceOption[0]);
        parent = (WrapperDoubleFilterGeneratorParent)this.getDataObjectService().find(WrapperDoubleFilterGeneratorParent.class, (Object)parent.getDoubleProp());
        Assert.assertTrue((String)"No parent found", (parent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Matching child found", (parent.getDoublePropChild() == null ? 1 : 0) != 0);
    }

    private DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperDoubleFilterGeneratorChild {
        @Id
        @Column(name="DOUBLE_PROP")
        private Double doubleProp;

        public Double getDoubleProp() {
            return this.doubleProp;
        }

        public void setDoubleProp(Double doubleProp) {
            this.doubleProp = doubleProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperDoubleFilterGeneratorParent {
        @Id
        @Column(name="DOUBLE_PROP")
        private Double doubleProp;
        @ManyToOne(targetEntity=WrapperDoubleFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="DOUBLE_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="doubleProp", attributeValue="10")
        private WrapperDoubleFilterGeneratorChild doublePropChild;

        public Double getDoubleProp() {
            return this.doubleProp;
        }

        public void setDoubleProp(Double doubleProp) {
            this.doubleProp = doubleProp;
        }

        public WrapperDoubleFilterGeneratorChild getDoublePropChild() {
            return this.doublePropChild;
        }

        public void setDoublePropChild(WrapperDoubleFilterGeneratorChild doublePropChild) {
            this.doublePropChild = doublePropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveDoubleFilterGeneratorChild {
        @Id
        @Column(name="DOUBLE_PROP")
        private double doubleProp;

        public double getDoubleProp() {
            return this.doubleProp;
        }

        public void setDoubleProp(double doubleProp) {
            this.doubleProp = doubleProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveDoubleFilterGeneratorParent {
        @Id
        @Column(name="DOUBLE_PROP")
        private double doubleProp;
        @ManyToOne(targetEntity=PrimitiveDoubleFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="DOUBLE_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="doubleProp", attributeValue="10")
        private PrimitiveDoubleFilterGeneratorChild doublePropChild;

        public double getDoubleProp() {
            return this.doubleProp;
        }

        public void setDoubleProp(double doubleProp) {
            this.doubleProp = doubleProp;
        }

        public PrimitiveDoubleFilterGeneratorChild getDoublePropChild() {
            return this.doublePropChild;
        }

        public void setDoublePropChild(PrimitiveDoubleFilterGeneratorChild doublePropChild) {
            this.doublePropChild = doublePropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperFloatFilterGeneratorChild {
        @Id
        @Column(name="FLOAT_PROP")
        private Float floatProp;

        public Float getFloatProp() {
            return this.floatProp;
        }

        public void setFloatProp(Float floatProp) {
            this.floatProp = floatProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperFloatFilterGeneratorParent {
        @Id
        @Column(name="FLOAT_PROP")
        private Float floatProp;
        @ManyToOne(targetEntity=WrapperFloatFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="FLOAT_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="floatProp", attributeValue="10")
        private WrapperFloatFilterGeneratorChild floatPropChild;

        public Float getFloatProp() {
            return this.floatProp;
        }

        public void setFloatProp(Float floatProp) {
            this.floatProp = floatProp;
        }

        public WrapperFloatFilterGeneratorChild getFloatPropChild() {
            return this.floatPropChild;
        }

        public void setFloatPropChild(WrapperFloatFilterGeneratorChild floatPropChild) {
            this.floatPropChild = floatPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveFloatFilterGeneratorChild {
        @Id
        @Column(name="FLOAT_PROP")
        private float floatProp;

        public float getFloatProp() {
            return this.floatProp;
        }

        public void setFloatProp(float floatProp) {
            this.floatProp = floatProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveFloatFilterGeneratorParent {
        @Id
        @Column(name="FLOAT_PROP")
        private float floatProp;
        @ManyToOne(targetEntity=PrimitiveFloatFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="FLOAT_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="floatProp", attributeValue="10")
        private PrimitiveFloatFilterGeneratorChild floatPropChild;

        public float getFloatProp() {
            return this.floatProp;
        }

        public void setFloatProp(float floatProp) {
            this.floatProp = floatProp;
        }

        public PrimitiveFloatFilterGeneratorChild getFloatPropChild() {
            return this.floatPropChild;
        }

        public void setFloatPropChild(PrimitiveFloatFilterGeneratorChild floatPropChild) {
            this.floatPropChild = floatPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperLongFilterGeneratorChild {
        @Id
        @Column(name="LONG_PROP")
        private Long longProp;

        public Long getLongProp() {
            return this.longProp;
        }

        public void setLongProp(Long longProp) {
            this.longProp = longProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperLongFilterGeneratorParent {
        @Id
        @Column(name="LONG_PROP")
        private Long longProp;
        @ManyToOne(targetEntity=WrapperLongFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="LONG_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="longProp", attributeValue="10")
        private WrapperLongFilterGeneratorChild longPropChild;

        public Long getLongProp() {
            return this.longProp;
        }

        public void setLongProp(Long longProp) {
            this.longProp = longProp;
        }

        public WrapperLongFilterGeneratorChild getLongPropChild() {
            return this.longPropChild;
        }

        public void setLongPropChild(WrapperLongFilterGeneratorChild longPropChild) {
            this.longPropChild = longPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveLongFilterGeneratorChild {
        @Id
        @Column(name="LONG_PROP")
        private long longProp;

        public long getLongProp() {
            return this.longProp;
        }

        public void setLongProp(long longProp) {
            this.longProp = longProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveLongFilterGeneratorParent {
        @Id
        @Column(name="LONG_PROP")
        private long longProp;
        @ManyToOne(targetEntity=PrimitiveLongFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="LONG_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="longProp", attributeValue="10")
        private PrimitiveLongFilterGeneratorChild longPropChild;

        public long getLongProp() {
            return this.longProp;
        }

        public void setLongProp(long longProp) {
            this.longProp = longProp;
        }

        public PrimitiveLongFilterGeneratorChild getLongPropChild() {
            return this.longPropChild;
        }

        public void setLongPropChild(PrimitiveLongFilterGeneratorChild longPropChild) {
            this.longPropChild = longPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperIntegerFilterGeneratorChild {
        @Id
        @Column(name="INT_PROP")
        private Integer intProp;

        public Integer getIntProp() {
            return this.intProp;
        }

        public void setIntProp(Integer intProp) {
            this.intProp = intProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperIntegerFilterGeneratorParent {
        @Id
        @Column(name="INT_PROP")
        private Integer intProp;
        @ManyToOne(targetEntity=WrapperIntegerFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="INT_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="intProp", attributeValue="10")
        private WrapperIntegerFilterGeneratorChild intPropChild;

        public Integer getIntProp() {
            return this.intProp;
        }

        public void setIntProp(Integer intProp) {
            this.intProp = intProp;
        }

        public WrapperIntegerFilterGeneratorChild getIntPropChild() {
            return this.intPropChild;
        }

        public void setIntPropChild(WrapperIntegerFilterGeneratorChild intPropChild) {
            this.intPropChild = intPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveIntegerFilterGeneratorChild {
        @Id
        @Column(name="INT_PROP")
        private int intProp;

        public int getIntProp() {
            return this.intProp;
        }

        public void setIntProp(int intProp) {
            this.intProp = intProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveIntegerFilterGeneratorParent {
        @Id
        @Column(name="INT_PROP")
        private int intProp;
        @ManyToOne(targetEntity=PrimitiveIntegerFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="INT_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="intProp", attributeValue="10")
        private PrimitiveIntegerFilterGeneratorChild intPropChild;

        public int getIntProp() {
            return this.intProp;
        }

        public void setIntProp(int intProp) {
            this.intProp = intProp;
        }

        public PrimitiveIntegerFilterGeneratorChild getIntPropChild() {
            return this.intPropChild;
        }

        public void setIntPropChild(PrimitiveIntegerFilterGeneratorChild intPropChild) {
            this.intPropChild = intPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperShortFilterGeneratorChild {
        @Id
        @Column(name="SHORT_PROP")
        private Short shortProp;

        public Short getShortProp() {
            return this.shortProp;
        }

        public void setShortProp(Short shortProp) {
            this.shortProp = shortProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperShortFilterGeneratorParent {
        @Id
        @Column(name="SHORT_PROP")
        private Short shortProp;
        @ManyToOne(targetEntity=WrapperShortFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="SHORT_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="shortProp", attributeValue="10")
        private WrapperShortFilterGeneratorChild shortPropChild;

        public Short getShortProp() {
            return this.shortProp;
        }

        public void setShortProp(Short shortProp) {
            this.shortProp = shortProp;
        }

        public WrapperShortFilterGeneratorChild getShortPropChild() {
            return this.shortPropChild;
        }

        public void setShortPropChild(WrapperShortFilterGeneratorChild shortPropChild) {
            this.shortPropChild = shortPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveShortFilterGeneratorChild {
        @Id
        @Column(name="SHORT_PROP")
        private short shortProp;

        public short getShortProp() {
            return this.shortProp;
        }

        public void setShortProp(short shortProp) {
            this.shortProp = shortProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveShortFilterGeneratorParent {
        @Id
        @Column(name="SHORT_PROP")
        private short shortProp;
        @ManyToOne(targetEntity=PrimitiveShortFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="SHORT_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="shortProp", attributeValue="10")
        private PrimitiveShortFilterGeneratorChild shortPropChild;

        public short getShortProp() {
            return this.shortProp;
        }

        public void setShortProp(short shortProp) {
            this.shortProp = shortProp;
        }

        public PrimitiveShortFilterGeneratorChild getShortPropChild() {
            return this.shortPropChild;
        }

        public void setShortPropChild(PrimitiveShortFilterGeneratorChild shortPropChild) {
            this.shortPropChild = shortPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperBooleanFilterGeneratorChild {
        @Id
        @Column(name="BOOL_PROP")
        @Convert(converter=BooleanYNConverter.class)
        private Boolean boolProp;

        public Boolean getBoolProp() {
            return this.boolProp;
        }

        public void setBoolProp(Boolean boolProp) {
            this.boolProp = boolProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperBooleanFilterGeneratorParent {
        @Id
        @Column(name="BOOL_PROP")
        @Convert(converter=BooleanYNConverter.class)
        private Boolean boolProp;
        @ManyToOne(targetEntity=WrapperBooleanFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="BOOL_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="boolProp", attributeValue="true")
        private WrapperBooleanFilterGeneratorChild boolPropChild;

        public Boolean getBoolProp() {
            return this.boolProp;
        }

        public void setBoolProp(Boolean boolProp) {
            this.boolProp = boolProp;
        }

        public WrapperBooleanFilterGeneratorChild getBoolPropChild() {
            return this.boolPropChild;
        }

        public void setBooleanPropChild(WrapperBooleanFilterGeneratorChild boolPropChild) {
            this.boolPropChild = boolPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveBooleanFilterGeneratorChild {
        @Id
        @Column(name="BOOL_PROP")
        @Convert(converter=BooleanYNConverter.class)
        private boolean boolProp;

        public boolean getBoolProp() {
            return this.boolProp;
        }

        public void setBoolProp(boolean boolProp) {
            this.boolProp = boolProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveBooleanFilterGeneratorParent {
        @Id
        @Column(name="BOOL_PROP")
        @Convert(converter=BooleanYNConverter.class)
        private boolean boolProp;
        @ManyToOne(targetEntity=PrimitiveBooleanFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="BOOL_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="boolProp", attributeValue="true")
        private PrimitiveBooleanFilterGeneratorChild boolPropChild;

        public boolean getBoolProp() {
            return this.boolProp;
        }

        public void setBoolProp(boolean boolProp) {
            this.boolProp = boolProp;
        }

        public PrimitiveBooleanFilterGeneratorChild getBoolPropChild() {
            return this.boolPropChild;
        }

        public void setBoolPropChild(PrimitiveBooleanFilterGeneratorChild boolPropChild) {
            this.boolPropChild = boolPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class WrapperCharacterFilterGeneratorChild {
        @Id
        @Column(name="CHAR_PROP")
        private Character charProp;

        public Character getCharProp() {
            return this.charProp;
        }

        public void setCharProp(Character charProp) {
            this.charProp = charProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class WrapperCharacterFilterGeneratorParent {
        @Id
        @Column(name="CHAR_PROP")
        private Character charProp;
        @ManyToOne(targetEntity=WrapperCharacterFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="CHAR_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="charProp", attributeValue="Y")
        private WrapperCharacterFilterGeneratorChild charPropChild;

        public Character getCharProp() {
            return this.charProp;
        }

        public void setCharProp(Character charProp) {
            this.charProp = charProp;
        }

        public WrapperCharacterFilterGeneratorChild getCharPropChild() {
            return this.charPropChild;
        }

        public void setCharPropChild(WrapperCharacterFilterGeneratorChild charPropChild) {
            this.charPropChild = charPropChild;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_CHILD_T")
    public static class PrimitiveCharacterFilterGeneratorChild {
        @Id
        @Column(name="CHAR_PROP")
        private char charProp;

        public char getCharProp() {
            return this.charProp;
        }

        public void setCharProp(char charProp) {
            this.charProp = charProp;
        }
    }

    @Entity
    @Table(name="KRTST_TYP_PARENT_T")
    public static class PrimitiveCharacterFilterGeneratorParent {
        @Id
        @Column(name="CHAR_PROP")
        private char charProp;
        @ManyToOne(targetEntity=PrimitiveCharacterFilterGeneratorChild.class, fetch=FetchType.EAGER)
        @JoinColumn(name="CHAR_PROP", insertable=false, updatable=false)
        @FilterGenerator(attributeName="charProp", attributeValue="Y")
        private PrimitiveCharacterFilterGeneratorChild charPropChild;

        public char getCharProp() {
            return this.charProp;
        }

        public void setCharProp(char charProp) {
            this.charProp = charProp;
        }

        public PrimitiveCharacterFilterGeneratorChild getCharPropChild() {
            return this.charPropChild;
        }

        public void setCharPropChild(PrimitiveCharacterFilterGeneratorChild charPropChild) {
            this.charPropChild = charPropChild;
        }
    }
}

