/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.eclipselink;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.FilterGenerators;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.testbo.TestQueryCustomizerValue;
import org.kuali.rice.krad.data.provider.annotation.ExtensionFor;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.SimpleAccount;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KradEclipseLinkCustomizerTest
extends KRADTestCase {
    private ConfigurableApplicationContext context;

    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.context = new ClassPathXmlApplicationContext("KradEclipseLinkCustomizerTest.xml", ((Object)((Object)this)).getClass());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.context != null) {
            this.context.close();
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequences_AnnotationAtClassLevel() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity testEntity1 = new TestEntity();
        testEntity1.setName("MyAwesomeTestEntity1");
        Assert.assertNull((Object)testEntity1.getNumber());
        try (EntityManager entityManager = factory.createEntityManager();){
            entityManager.persist((Object)testEntity1);
            Assert.assertNotNull((Object)testEntity1.getNumber());
        }
        TestEntity testEntity2 = new TestEntity();
        testEntity2.setName("MyAwesomeTestEntity2");
        Assert.assertNull((Object)testEntity2.getNumber());
        entityManager = factory.createEntityManager();
        try {
            testEntity2 = (TestEntity)((Object)entityManager.merge((Object)testEntity2));
            Assert.assertNotNull((Object)testEntity2.getNumber());
            Assert.assertEquals((Object)(Integer.valueOf(testEntity1.getNumber()) + 1), (Object)Integer.valueOf(testEntity2.getNumber()));
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequences_AnnotationAtFieldLevel() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity2 testEntity1 = new TestEntity2();
        testEntity1.setName("MyAwesomeTestEntity1");
        Assert.assertNull((Object)testEntity1.getNumber());
        try (EntityManager entityManager = factory.createEntityManager();){
            entityManager.persist((Object)testEntity1);
            Assert.assertNotNull((Object)testEntity1.getNumber());
        }
        TestEntity2 testEntity2 = new TestEntity2();
        testEntity2.setName("MyAwesomeTestEntity2");
        Assert.assertNull((Object)testEntity2.getNumber());
        entityManager = factory.createEntityManager();
        try {
            testEntity2 = (TestEntity2)((Object)entityManager.merge((Object)testEntity2));
            Assert.assertNotNull((Object)testEntity2.getNumber());
            Assert.assertEquals((Object)(Integer.valueOf(testEntity1.getNumber()) + 1), (Object)Integer.valueOf(testEntity2.getNumber()));
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequences_AnnotationAtFieldLevel_MappedSuperClass() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity5 testEntity1 = new TestEntity5();
        testEntity1.setName("MyAwesomeTestEntity1");
        Assert.assertNull((Object)testEntity1.getNumber());
        try (EntityManager entityManager = factory.createEntityManager();){
            entityManager.persist((Object)testEntity1);
            Assert.assertNotNull((Object)testEntity1.getNumber());
        }
        TestEntity5 testEntity2 = new TestEntity5();
        testEntity2.setName("MyAwesomeTestEntity2");
        Assert.assertNull((Object)testEntity2.getNumber());
        entityManager = factory.createEntityManager();
        try {
            testEntity2 = (TestEntity5)((Object)entityManager.merge((Object)testEntity2));
            Assert.assertNotNull((Object)testEntity2.getNumber());
            Assert.assertEquals((Object)(Integer.valueOf(testEntity1.getNumber()) + 1), (Object)Integer.valueOf(testEntity2.getNumber()));
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequences_AnnotationAtMethodLevel() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity3 testEntity1 = new TestEntity3();
        testEntity1.setName("MyAwesomeTestEntity1");
        Assert.assertNull((Object)testEntity1.getNumber());
        try (EntityManager entityManager = factory.createEntityManager();){
            entityManager.persist((Object)testEntity1);
            Assert.assertNotNull((Object)testEntity1.getNumber());
        }
        TestEntity3 testEntity2 = new TestEntity3();
        testEntity2.setName("MyAwesomeTestEntity2");
        Assert.assertNull((Object)testEntity2.getNumber());
        entityManager = factory.createEntityManager();
        try {
            testEntity2 = (TestEntity3)((Object)entityManager.merge((Object)testEntity2));
            Assert.assertNotNull((Object)testEntity2.getNumber());
            Assert.assertEquals((Object)(Integer.valueOf(testEntity1.getNumber()) + 1), (Object)Integer.valueOf(testEntity2.getNumber()));
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequences_MappedSuperClass() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity4 testEntity1 = new TestEntity4();
        testEntity1.setName("MyAwesomeTestEntity1");
        Assert.assertNull((Object)testEntity1.getNumber());
        try (EntityManager entityManager = factory.createEntityManager();){
            entityManager.persist((Object)testEntity1);
            Assert.assertNotNull((Object)testEntity1.getNumber());
        }
        TestEntity4 testEntity2 = new TestEntity4();
        testEntity2.setName("MyAwesomeTestEntity2");
        Assert.assertNull((Object)testEntity2.getNumber());
        entityManager = factory.createEntityManager();
        try {
            testEntity2 = (TestEntity4)((Object)entityManager.merge((Object)testEntity2));
            Assert.assertNotNull((Object)testEntity2.getNumber());
            Assert.assertEquals((Object)(Integer.valueOf(testEntity1.getNumber()) + 1), (Object)Integer.valueOf(testEntity2.getNumber()));
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCustomizerMatch() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity6 testEntity1 = new TestEntity6();
        testEntity1.setName("MyAwesomeTestEntity1");
        TestRelatedExtension extension = new TestRelatedExtension();
        extension.setAccountTypeCode("TS");
        try (EntityManager entityManager = factory.createEntityManager();){
            testEntity1 = new TestEntity6();
            testEntity1.setName("MyCustomFilter");
            entityManager.persist((Object)testEntity1);
            extension.setNumber(testEntity1.getNumber());
            entityManager.persist((Object)extension);
            entityManager.flush();
        }
        try {
            entityManager = factory.createEntityManager();
            testEntity1 = (TestEntity6)((Object)entityManager.find(TestEntity6.class, (Object)testEntity1.getNumber()));
            Assert.assertTrue((String)"Match found for base entity", (testEntity1 != null && StringUtils.equals((String)"MyCustomFilter", (String)testEntity1.getName()) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Found matching travel extension that matches", (testEntity1.getAccountExtension() != null ? 1 : 0) != 0);
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCustomizerNoMatch() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity6 testEntity1 = new TestEntity6();
        testEntity1.setName("MyAwesomeTestEntity1");
        TestRelatedExtension extension = new TestRelatedExtension();
        extension.setAccountTypeCode("NM");
        try (EntityManager entityManager = factory.createEntityManager();){
            testEntity1 = new TestEntity6();
            testEntity1.setName("MyCustomFilter");
            entityManager.persist((Object)testEntity1);
            extension.setNumber(testEntity1.getNumber());
            entityManager.persist((Object)extension);
            entityManager.flush();
        }
        try {
            entityManager = factory.createEntityManager();
            testEntity1 = (TestEntity6)((Object)entityManager.find(TestEntity6.class, (Object)testEntity1.getNumber()));
            Assert.assertTrue((String)"Matched found for base entity", (testEntity1 != null && StringUtils.equals((String)"MyCustomFilter", (String)testEntity1.getName()) ? 1 : 0) != 0);
            Assert.assertTrue((String)"No matching travel extension", (testEntity1.getAccountExtension() == null ? 1 : 0) != 0);
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCustomizerSort() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity7 testEntity1 = new TestEntity7();
        testEntity1.setName("MyAwesomeTestEntity1");
        TestRelatedExtension2 extension2 = new TestRelatedExtension2();
        extension2.setAccountTypeCode("ZZ");
        TestRelatedExtension2 extension = new TestRelatedExtension2();
        extension.setAccountTypeCode("NM");
        try (EntityManager entityManager = factory.createEntityManager();){
            testEntity1 = new TestEntity7();
            testEntity1.setName("MyCustomFilter");
            entityManager.persist((Object)testEntity1);
            extension.setNumber(testEntity1.getNumber());
            entityManager.persist((Object)extension);
            entityManager.flush();
        }
        try {
            entityManager = factory.createEntityManager();
            extension2.setNumber(testEntity1.getNumber());
            entityManager.persist((Object)extension2);
            entityManager.flush();
        }
        finally {
            entityManager.close();
        }
        entityManager = factory.createEntityManager();
        try {
            entityManager = factory.createEntityManager();
            testEntity1 = (TestEntity7)((Object)entityManager.find(TestEntity7.class, (Object)testEntity1.getNumber()));
            Assert.assertTrue((String)"Matched found for base entity", (testEntity1 != null && StringUtils.equals((String)"MyCustomFilter", (String)testEntity1.getName()) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Fetching 2 extensions", (testEntity1.getAccountExtension() != null && testEntity1.getAccountExtension().size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Fetched ZZ extension first ", (boolean)StringUtils.equals((String)testEntity1.getAccountExtension().get(0).getAccountTypeCode(), (String)"ZZ"));
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCustomizerValueClass() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity8 testEntity1 = new TestEntity8();
        testEntity1.setName("MyAwesomeTestEntity1");
        TestRelatedExtension extension = new TestRelatedExtension();
        extension.setAccountTypeCode("NM");
        try (EntityManager entityManager = factory.createEntityManager();){
            testEntity1 = new TestEntity8();
            testEntity1.setName("MyCustomFilter");
            entityManager.persist((Object)testEntity1);
            extension.setNumber(testEntity1.getNumber());
            entityManager.persist((Object)extension);
            entityManager.flush();
        }
        try {
            entityManager = factory.createEntityManager();
            testEntity1 = (TestEntity8)((Object)entityManager.find(TestEntity8.class, (Object)testEntity1.getNumber()));
            Assert.assertTrue((String)"Matched found for base entity", (testEntity1 != null && StringUtils.equals((String)"MyCustomFilter", (String)testEntity1.getName()) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Matching travel extension", (testEntity1.getAccountExtension() == null ? 1 : 0) != 0);
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCustomizerNoMatchMultipleCustomizers() throws Exception {
        EntityManagerFactory factory = (EntityManagerFactory)this.context.getBean("entityManagerFactory");
        Assert.assertNotNull((Object)factory);
        TestEntity9 testEntity1 = new TestEntity9();
        testEntity1.setName("MyAwesomeTestEntity1");
        TestRelatedExtension extension = new TestRelatedExtension();
        extension.setAccountTypeCode("TS");
        try (EntityManager entityManager = factory.createEntityManager();){
            testEntity1 = new TestEntity9();
            testEntity1.setName("MyCustomFilter");
            entityManager.persist((Object)testEntity1);
            extension.setNumber(testEntity1.getNumber());
            entityManager.persist((Object)extension);
            entityManager.flush();
        }
        try {
            entityManager = factory.createEntityManager();
            testEntity1 = (TestEntity9)((Object)entityManager.find(TestEntity9.class, (Object)testEntity1.getNumber()));
            Assert.assertTrue((String)"Match found for base entity", (testEntity1 != null && StringUtils.equals((String)"MyCustomFilter", (String)testEntity1.getName()) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Found no travel extension that matches", (testEntity1.getAccountExtension() == null ? 1 : 0) != 0);
        }
        finally {
            entityManager.close();
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity9
    extends ParentTestEntity2 {
        @ManyToOne(targetEntity=TestRelatedExtension.class, fetch=FetchType.EAGER)
        @JoinColumn(name="ACCT_NUM", insertable=false, updatable=false)
        @FilterGenerators(value={@FilterGenerator(attributeName="accountTypeCode", attributeValue="TS"), @FilterGenerator(attributeName="accountTypeCode", attributeValue="NM")})
        private TestRelatedExtension accountExtension;
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TestRelatedExtension getAccountExtension() {
            return this.accountExtension;
        }

        public void setAccountExtension(TestRelatedExtension accountExtension) {
            this.accountExtension = accountExtension;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity8
    extends ParentTestEntity2 {
        @ManyToOne(targetEntity=TestRelatedExtension.class, fetch=FetchType.EAGER)
        @JoinColumn(name="ACCT_NUM", insertable=false, updatable=false)
        @FilterGenerator(attributeName="accountTypeCode", attributeResolverClass=TestQueryCustomizerValue.class)
        private TestRelatedExtension accountExtension;
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TestRelatedExtension getAccountExtension() {
            return this.accountExtension;
        }

        public void setAccountExtension(TestRelatedExtension accountExtension) {
            this.accountExtension = accountExtension;
        }
    }

    @Entity
    @Table(name="TRV_ACCT_EXT")
    public static class TestRelatedExtension2
    extends DataObjectBase {
        @Id
        @Column(name="ACCT_NUM")
        private String number;
        @Id
        @Column(name="ACCT_TYPE")
        private String accountTypeCode;
        @ManyToOne(targetEntity=TestEntity7.class, fetch=FetchType.EAGER)
        @JoinColumn(name="ACCT_NUM", insertable=false, updatable=false)
        private TestEntity7 testEntity7;

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getAccountTypeCode() {
            return this.accountTypeCode;
        }

        public void setAccountTypeCode(String accountTypeCode) {
            this.accountTypeCode = accountTypeCode;
        }

        public TestEntity7 getTestEntity7() {
            return this.testEntity7;
        }

        public void setTestEntity7(TestEntity7 testEntity7) {
            this.testEntity7 = testEntity7;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity7
    extends ParentTestEntity2 {
        @OneToMany(targetEntity=TestRelatedExtension2.class, fetch=FetchType.EAGER)
        @JoinColumn(name="ACCT_NUM")
        @OrderBy(value="accountTypeCode DESC")
        private List<TestRelatedExtension2> accountExtension = new ArrayList<TestRelatedExtension2>();
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<TestRelatedExtension2> getAccountExtension() {
            return this.accountExtension;
        }

        public void setAccountExtension(List<TestRelatedExtension2> accountExtension) {
            this.accountExtension = accountExtension;
        }
    }

    @Entity
    @Table(name="TRV_ACCT_EXT")
    @ExtensionFor(value=SimpleAccount.class)
    public static class TestRelatedExtension
    extends DataObjectBase {
        @Id
        @Column(name="ACCT_NUM")
        private String number;
        @Column(name="ACCT_TYPE")
        private String accountTypeCode;

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getAccountTypeCode() {
            return this.accountTypeCode;
        }

        public void setAccountTypeCode(String accountTypeCode) {
            this.accountTypeCode = accountTypeCode;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity6
    extends ParentTestEntity2 {
        @ManyToOne(targetEntity=TestRelatedExtension.class, fetch=FetchType.EAGER)
        @JoinColumn(name="ACCT_NUM", insertable=false, updatable=false)
        @FilterGenerator(attributeName="accountTypeCode", attributeValue="TS")
        private TestRelatedExtension accountExtension;
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TestRelatedExtension getAccountExtension() {
            return this.accountExtension;
        }

        public void setAccountExtension(TestRelatedExtension accountExtension) {
            this.accountExtension = accountExtension;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity5
    extends ParentTestEntity2 {
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @MappedSuperclass
    public static abstract class ParentTestEntity2
    extends DataObjectBase {
        @Id
        @GeneratedValue(generator="TRVL_ID_SEQ_5")
        @PortableSequenceGenerator(name="TRVL_ID_SEQ_5", sequenceName="TRVL_ID_SEQ", initialValue=1000)
        @Column(name="ACCT_NUM")
        private String number;

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity4
    extends ParentTestEntity {
        @Id
        @GeneratedValue(generator="TRVL_ID_SEQ_4")
        @Column(name="ACCT_NUM")
        private String number;
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        @Override
        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @MappedSuperclass
    @PortableSequenceGenerator(name="TRVL_ID_SEQ_4", sequenceName="TRVL_ID_SEQ", initialValue=1000)
    public static abstract class ParentTestEntity
    extends DataObjectBase {
        public abstract String getNumber();
    }

    @Entity
    @Table(name="TRV_ACCT")
    @Access(value=AccessType.PROPERTY)
    public static class TestEntity3
    extends DataObjectBase {
        private String number;
        private String name;
        private Long amId;

        @Column(name="ACCT_FO_ID")
        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        @Column(name="ACCT_NAME")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Id
        @GeneratedValue(generator="TRVL_ID_SEQ_3")
        @PortableSequenceGenerator(name="TRVL_ID_SEQ_3", sequenceName="TRVL_ID_SEQ")
        @Column(name="ACCT_NUM")
        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    public static class TestEntity2
    extends DataObjectBase {
        @Id
        @GeneratedValue(generator="TRVL_ID_SEQ_2")
        @PortableSequenceGenerator(name="TRVL_ID_SEQ_2", sequenceName="TRVL_ID_SEQ")
        @Column(name="ACCT_NUM")
        private String number;
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    @Entity
    @Table(name="TRV_ACCT")
    @PortableSequenceGenerator(name="TRVL_ID_SEQ")
    public static class TestEntity
    extends DataObjectBase {
        @Id
        @Column(name="ACCT_NUM")
        @GeneratedValue(generator="TRVL_ID_SEQ")
        private String number;
        @Column(name="ACCT_NAME")
        private String name;
        @Column(name="ACCT_FO_ID")
        private Long amId;

        public Long getAmId() {
            return this.amId;
        }

        public void setAmId(Long amId) {
            this.amId = amId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }
}

