/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MaxValueIncrementerFactoryIntegrationTest
extends KRADTestCase {
    private static final String ARBITRARY_SEQUENCE = "TRVL_ID_SEQ";

    @Test
    public void testGetIncrementer_nextValues() {
        DataSource dataSource = TestHarnessServiceLocator.getDataSource();
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)dataSource, (String)ARBITRARY_SEQUENCE);
        Assert.assertNotNull((Object)incrementer);
        int nextIntValue = incrementer.nextIntValue();
        Assert.assertTrue((String)"nextIntValue should be greater than 0", (nextIntValue > 0 ? 1 : 0) != 0);
        int nextNextIntValue = incrementer.nextIntValue();
        Assert.assertEquals((String)"Next value should be one higher", (long)(nextIntValue + 1), (long)nextNextIntValue);
        long nextLongValue = incrementer.nextLongValue();
        Assert.assertEquals((long)(nextNextIntValue + 1), (long)nextLongValue);
        String nextStringValue = incrementer.nextStringValue();
        Assert.assertEquals((long)(nextLongValue + 1L), (long)Long.parseLong(nextStringValue));
    }

    @Test
    public void testGetIncrementer_CaseInsensitive() {
        DataSource dataSource = TestHarnessServiceLocator.getDataSource();
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)dataSource, (String)ARBITRARY_SEQUENCE.toLowerCase());
        Assert.assertNotNull((Object)incrementer);
        int nextIntValue = incrementer.nextIntValue();
        Assert.assertTrue((String)"nextIntValue should be greater than 0", (nextIntValue > 0 ? 1 : 0) != 0);
    }

    @Test(expected=DataAccessException.class)
    public void testGetIncrementer_BadSequence() {
        DataSource dataSource = TestHarnessServiceLocator.getDataSource();
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)dataSource, (String)"OH_NO_YOU_DIDNT!");
        Assert.assertNotNull((Object)incrementer);
        incrementer.nextLongValue();
    }
}

