/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider;

import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.eclipse.persistence.exceptions.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.AccountType;
import org.kuali.rice.test.data.PerSuiteUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.springframework.orm.jpa.JpaSystemException;

@PerSuiteUnitTestData(value={@UnitTestData(sqlFiles={@UnitTestFile(filename="classpath:testAccountType.sql", delimiter=";")})})
public class RollbackExceptionErrorReportingTest
extends KRADTestCase {
    private static final Logger LOG = Logger.getLogger(RollbackExceptionErrorReportingTest.class);

    protected DataObjectService getDataObjectService() {
        return KradDataServiceLocator.getDataObjectService();
    }

    @Test
    public void changePrimaryKeyValue_Exception() {
        AccountType acctType = (AccountType)this.getDataObjectService().find(AccountType.class, (Object)"CAT");
        Assert.assertNotNull((String)"Error retrieving CAT account type from data object service", (Object)acctType);
        acctType.setAccountTypeCode("CLR");
        try {
            this.getDataObjectService().save((Object)acctType, new PersistenceOption[]{PersistenceOption.FLUSH});
            Assert.fail((String)"The save method should have failed.");
        }
        catch (JpaSystemException ex) {
            LOG.info((Object)ex, (Throwable)ex);
            Assert.assertNotNull((String)"The thrown rollback exception should have had a cause", (Object)ex.getCause());
            Assert.assertTrue((String)("Embedded error should have been a javax.persistence.PersistenceException.  But was: " + ex.getCause()), (boolean)(ex.getCause() instanceof PersistenceException));
            Assert.assertNotNull((String)"The embedded rollback exception should have had a cause", (Object)ex.getCause().getCause());
            Assert.assertTrue((String)("The embedded rollback exception should have been a validation exception, but was: " + ex.getCause().getCause()), (boolean)(ex.getCause().getCause() instanceof ValidationException));
        }
        catch (Exception ex) {
            Assert.fail((String)"It should have failed with JpaSystemException");
        }
    }
}

