/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObjectExtension;
import org.kuali.rice.krad.data.jpa.testbo.YetAnotherReferencedDataObject;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class ExtensionForAnnotationTest
extends KRADTestCase {
    protected PersistenceProvider getPersistenceProvider() {
        return (PersistenceProvider)this.getKRADTestHarnessContext().getBean("kradTestJpaPersistenceProvider", PersistenceProvider.class);
    }

    protected List<String> getPerTestTablesToClear() {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("KRTST_TEST_TABLE_T");
        tables.add("KRTST_TEST_TABLE_EXT_T");
        tables.add("KRTST_TEST_YARDO_T");
        return tables;
    }

    protected TestDataObject createTestDataObject(String key) {
        TestDataObject dataObject = new TestDataObject();
        dataObject.setPrimaryKeyProperty(key);
        dataObject.setStringProperty("aString");
        TestDataObjectExtension extension = new TestDataObjectExtension();
        extension.setPrimaryKeyProperty(dataObject);
        extension.setExtensionProperty("extraData");
        dataObject.setExtension((Object)extension);
        YetAnotherReferencedDataObject yardo = new YetAnotherReferencedDataObject();
        yardo.setId(key);
        yardo.setSomeOtherStringProperty("otherString");
        dataObject.setYetAnotherReferencedObject(yardo);
        return dataObject;
    }

    @Test
    public void testCreateDataObjectWithExtension() {
        TestDataObject dataObject = this.createTestDataObject("1");
        this.getPersistenceProvider().save((Object)dataObject, new PersistenceOption[0]);
        ((EntityManagerFactory)this.getKRADTestHarnessContext().getBean("kradTestEntityManagerFactory", EntityManagerFactory.class)).getCache().evictAll();
        dataObject = (TestDataObject)this.getPersistenceProvider().find(TestDataObject.class, (Object)"1");
        TestDataObjectExtension extension = (TestDataObjectExtension)this.getPersistenceProvider().find(TestDataObjectExtension.class, (Object)"1");
        YetAnotherReferencedDataObject yardo = (YetAnotherReferencedDataObject)this.getPersistenceProvider().find(YetAnotherReferencedDataObject.class, (Object)"1");
        Assert.assertNotNull((String)"TestDataObject 1 not saved", (Object)dataObject);
        Assert.assertNotNull((String)"TestDataObjectExtension 1 not saved", (Object)extension);
        Assert.assertNotNull((String)"YetAnotherReferencedDataObject 1 not saved", (Object)yardo);
    }

    @Test
    public void testRetrieveDataObjectWithExtension() {
        TestDataObject dataObject = this.createTestDataObject("2");
        this.getPersistenceProvider().save((Object)dataObject, new PersistenceOption[0]);
        ((EntityManagerFactory)this.getKRADTestHarnessContext().getBean("kradTestEntityManagerFactory", EntityManagerFactory.class)).getCache().evictAll();
        dataObject = (TestDataObject)this.getPersistenceProvider().find(TestDataObject.class, (Object)"2");
        YetAnotherReferencedDataObject yardo = dataObject.getYetAnotherReferencedObject();
        Assert.assertNotNull((String)"yardo reference was null - not loaded automatically", (Object)yardo);
        Assert.assertNotNull((String)"Extension reference was null - extension not loaded automatically", (Object)dataObject.getExtension());
        Assert.assertTrue((String)("extension was not a TestDataObjectExtension: " + dataObject.getExtension().getClass()), (boolean)(dataObject.getExtension() instanceof TestDataObjectExtension));
    }
}

