/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;

public class DataDictionaryTest
extends KRADTestCase {
    private DataDictionaryService ddService;
    private DocumentTypeService dtService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ddService = KRADServiceLocatorWeb.getDataDictionaryService();
        this.dtService = KEWServiceLocator.getDocumentTypeService();
    }

    @Test
    public void testDocumentTypeEBO() throws Exception {
        DataDictionary dataDictionary = this.ddService.getDataDictionary();
        Map documentEntry = dataDictionary.getDocumentEntries();
        DocumentEntry entry = (DocumentEntry)documentEntry.get("DocumentTypeEBO");
        DocumentType documentType = this.dtService.findByName(entry.getDocumentTypeName());
        Assert.assertNotNull((Object)documentType);
        Assert.assertNotNull((Object)documentType.getDocTypeParentId());
        Assert.assertNotNull((Object)documentType.getDocumentTypeId());
        Assert.assertEquals((Object)"Travel Authorization Document", (Object)documentType.getLabel());
        Assert.assertEquals((Object)"DocumentTypeEBO", (Object)documentType.getName());
        Assert.assertEquals((Object)"Create a New Travel Authorization Document", (Object)documentType.getDescription());
        Assert.assertTrue((boolean)documentType.isActive());
    }
}

