/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.TestDictionaryBean;
import org.kuali.rice.krad.test.TestDictionaryConfig;
import org.kuali.rice.test.data.PerSuiteUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;

@PerSuiteUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlFiles={@UnitTestFile(filename="classpath:testExternalMessages.sql", delimiter=";")})})
@TestDictionaryConfig(namespaceCode="TEST", dataDictionaryFiles="classpath:org/kuali/rice/krad/datadictionary/MessageProcessorTestBeans.xml")
public class MessageBeanProcessorTest
extends KRADTestCase {
    @Test
    public void testMatchBeanIdSimpleKey() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesSimpleProperty"));
        Assert.assertEquals((String)"Property1 was not overridden with external message", (Object)"ext p1 value", (Object)tObject.getProperty1());
        Assert.assertEquals((String)"Property2 was not overridden with external message", (Object)"ext p2 value", (Object)tObject.getProperty2());
    }

    @Test
    public void testMatchExplicitKey() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesMessageKey"));
        Assert.assertEquals((String)"Property1 was not overridden with explicit message key (with default)", (Object)"ext key p1 value", (Object)tObject.getProperty1());
        Assert.assertEquals((String)"Property2 was not overridden with explicit message key (without default)", (Object)"ext key p2 value", (Object)tObject.getProperty2());
    }

    @Test
    public void testMatchExplicitListKey() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesListMessageKey"));
        Assert.assertEquals((String)"List1 entry 2 was not overridden with explicit message key", (Object)"ext list key value", (Object)tObject.getList1().get(1));
    }

    @Test
    public void testMatchExplicitMapKey() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesMapMessageKey"));
        Assert.assertEquals((String)"Map1 key 'k2' was not overridden with explicit message key", (Object)"ext map key value", (Object)tObject.getMap1().get("k2"));
    }

    @Test
    public void testMessageExpressionMerge() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesExpressionMerge"));
        Assert.assertEquals((String)"Expression for property 1 was not merged", (Object)"Value '@{expr1}' is invalid", tObject.getExpressionGraph().get("property1"));
        Assert.assertEquals((String)"Expression for property 2 was not merged", (Object)"The @{expr1} code should not equal @{expr2 + 3}", tObject.getExpressionGraph().get("property2"));
        tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesKeyExprMerge"));
        Assert.assertEquals((String)"Expression for property 1 was not merged with explicit message key", (Object)"Expr @{expr1} then expr @{expr2}", tObject.getExpressionGraph().get("property1"));
    }

    @Test
    public void testMessagesForListBean() throws Exception {
        List keyValues = (List)this.getTestDictionaryObject("TestMessagesOptions");
        Assert.assertEquals((String)"First key value not overridden by message", (Object)"Ext Summer", (Object)((KeyValue)keyValues.get(0)).getValue());
        Assert.assertEquals((String)"Second key value was overriden and should not be", (Object)"Fall", (Object)((KeyValue)keyValues.get(1)).getValue());
        Assert.assertEquals((String)"Third key value not overridden by message", (Object)"Ext Spring", (Object)((KeyValue)keyValues.get(2)).getValue());
    }

    @Test
    public void testModuleResourcesMessages() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestMessagesResources"));
        Assert.assertEquals((String)"Property 1 value was not overridden with message resource", (Object)"Message for Property 1", (Object)tObject.getProperty1());
        Assert.assertEquals((String)"Property 2 value with explicit key was not overridden with message resource", (Object)"Message for explicit message key", (Object)tObject.getProperty2());
        String messageText = this.getMessageService().getMessageText("TEST", "", "validation.test.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"Error found for {0}", (Object)messageText);
    }

    @Test
    public void testApplicationResourcesMessages() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestApplicationMessagesResources"));
        Assert.assertEquals((String)"Property 1 value was not overridden with message resource", (Object)"App Message for Property 1", (Object)tObject.getProperty1());
        Assert.assertEquals((String)"Property 2 value with explicit key was not overridden with message resource", (Object)"App Message for explicit message key", (Object)tObject.getProperty2());
        String messageText = this.getMessageService().getMessageText("KUALI", "", "validation.test.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"App Error found for {0}", (Object)messageText);
    }

    @Test
    public void testExpressionMessages() throws Exception {
        TestDictionaryBean tObject = (TestDictionaryBean)((Object)this.getTestDictionaryObject("TestExpressionMessages"));
        Assert.assertEquals((String)"Messages in expression for property 1 not replaced", (Object)"@{foo eq '1' ? 'ext key p1 value' : 'ext key p2 value'}", tObject.getExpressionGraph().get("property1"));
    }

    public MessageService getMessageService() {
        return KRADServiceLocatorWeb.getMessageService();
    }
}

