/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation;

import org.junit.Assert;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;

public final class ValidationTestUtils {
    private static final String[] TEST_INPUTS = new String[]{"", "!!!", "[a-9]", "^A-Z", "abc", "a bc", "a_bc", "123", "12 3", "12_3", "a1b2c3", "a1b2_c3", "a 1b2c3", "a 1b2_c3", "foo.bar", "foo.bar_baz", ".bar_foo baz"};

    private ValidationTestUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static final void assertPatternMatches(ValidationPattern pattern, boolean[] expectedValues) {
        if (expectedValues.length != TEST_INPUTS.length) {
            Assert.fail((String)("expectedValues length was " + expectedValues.length + ", expected TEST_INPUTS.length of " + TEST_INPUTS.length));
        }
        for (int i = 0; i < TEST_INPUTS.length; ++i) {
            String testInput = TEST_INPUTS[i];
            boolean expectedResult = expectedValues[i];
            boolean actualResult = pattern.matches(testInput);
            if (actualResult == expectedResult) continue;
            Assert.fail((String)("for input '" + testInput + "', expected " + expectedResult + " but got " + actualResult));
        }
    }
}

