/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.fieldlevel;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.EmailAddressValidationPattern;
import org.kuali.rice.krad.test.KRADTestCase;

public class EmailAddressValidationPatternTest
extends KRADTestCase {
    private EmailAddressValidationPattern pattern;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.pattern = new EmailAddressValidationPattern();
    }

    @Test
    public final void testMatches_valid1() {
        Assert.assertTrue((String)"Valid email address did not pass the validation pattern", (boolean)this.pattern.matches("ww5@a.b.c.org"));
    }

    @Test
    public final void testMatches_valid2() {
        Assert.assertTrue((String)"Valid email address did not pass the validation pattern", (boolean)this.pattern.matches("something.else@a2.com"));
    }

    @Test
    public final void testMatches_valid3() {
        Assert.assertTrue((String)"Valid email address did not pass the validation pattern", (boolean)this.pattern.matches("something_else@something.else.com"));
    }

    @Test
    public final void testMatches_valid4() {
        Assert.assertTrue((String)"Valid email address did not pass the validation pattern", (boolean)this.pattern.matches("something-else@et-tu.com"));
    }

    @Test
    public final void testMatches_invalid1() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("@a.b.c.org"));
    }

    @Test
    public final void testMatches_invalid2() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("a"));
    }

    @Test
    public final void testMatches_invalid3() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("1@org"));
    }

    @Test
    public final void testMatches_invalid4() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("1@a"));
    }

    @Test
    public final void testMatches_invalid5() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("_@a"));
    }

    @Test
    public final void testMatches_invalid6() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches(".@a.org"));
    }

    @Test
    public final void testMatches_invalid7() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("-@a.org"));
    }

    @Test
    public final void testMatches_invalid8() {
        Assert.assertFalse((String)"Invalid email address passed the validation pattern", (boolean)this.pattern.matches("something@a.o-rg"));
    }
}

