/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.AccountRequestDocument;
import org.kuali.rice.krad.test.document.AccountRequestDocument2;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestSql;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class PessimisticLockServiceTest
extends KRADTestCase {
    String sessionId = "ad4d6c83-4d0f-4309-a528-c2f81ec00396";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.getUserSession().setKualiSessionId(this.sessionId);
    }

    @UnitTestData(sqlStatements={@UnitTestSql(value="DELETE FROM KRNS_PESSIMISTIC_LOCK_T"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1111, '4f6bc9e2-7df8-102c-97b6-ed716fdaf540', 0, NULL, '1234', {d '2007-07-01'}, 'employee', 'aa5d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1112, '5add9cba-7df8-102c-97b6-ed716fdaf540', 0, NULL, '1235', {d '2007-10-01'}, 'frank', 'dd4d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1113, '69e42b8e-7df8-102c-97b6-ed716fdaf540', 0, NULL, '1236', {d '2007-08-01'}, 'fred', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1114, '76504650-7df8-102c-97b6-ed716fdaf540', 0, NULL, '1237', {d '2007-08-01'}, 'fred', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')")})
    @Test
    public void testDeleteLocks() throws Exception {
        List locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be 4 locks in DB", (long)4L, (long)locks.size());
        String userId = "employee";
        String[] lockIdsToVerify = new String[]{"1112", "1113"};
        Assert.assertFalse((String)("User " + userId + " should not be member of pessimistic lock admin permission"), (boolean)KimApiServiceLocator.getPermissionService().isAuthorized(new UserSession(userId).getPerson().getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap()));
        this.verifyDelete(userId, Arrays.asList(lockIdsToVerify), AuthorizationException.class, true);
        userId = "frank";
        lockIdsToVerify = new String[]{"1111", "1113"};
        Assert.assertFalse((String)("User " + userId + " should not be member of pessimistic lock admin permission"), (boolean)KimApiServiceLocator.getPermissionService().isAuthorized(new UserSession(userId).getPerson().getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap()));
        this.verifyDelete(userId, Arrays.asList(lockIdsToVerify), AuthorizationException.class, true);
        userId = "fred";
        lockIdsToVerify = new String[]{"1111", "1112"};
        Assert.assertFalse((String)("User " + userId + " should not be member of pessimistic lock admin permission"), (boolean)KimApiServiceLocator.getPermissionService().isAuthorized(new UserSession(userId).getPerson().getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap()));
        this.verifyDelete(userId, Arrays.asList(lockIdsToVerify), AuthorizationException.class, true);
        this.verifyDelete("employee", Arrays.asList("1111"), null, false);
        this.verifyDelete("frank", Arrays.asList("1112"), null, false);
        this.verifyDelete("fred", Arrays.asList("1113"), null, false);
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be 1 lock left in DB", (long)1L, (long)locks.size());
        userId = "fran";
        Assert.assertTrue((String)("User " + userId + " should be member of pessimistic lock admin permission"), (boolean)KimApiServiceLocator.getPermissionService().isAuthorized(new UserSession(userId).getPerson().getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap()));
        userId = "admin";
        Assert.assertTrue((String)("User " + userId + " should be member of pessimistic lock admin permission"), (boolean)KimApiServiceLocator.getPermissionService().isAuthorized(new UserSession(userId).getPerson().getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap()));
        this.verifyDelete(userId, Arrays.asList("1114"), null, false);
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be 0 locks left in DB", (long)0L, (long)locks.size());
    }

    private void verifyDelete(String userId, List<String> lockIds, Class expectedException, boolean expectException) throws WorkflowException {
        GlobalVariables.setUserSession((UserSession)new UserSession(userId));
        for (String lockId : lockIds) {
            try {
                KRADServiceLocatorWeb.getPessimisticLockService().delete(lockId);
                if (!expectException) continue;
                Assert.fail((String)("Expected exception when deleting lock with id '" + lockId + "' for user '" + userId + "'"));
            }
            catch (Exception e) {
                if (!expectException) {
                    Assert.fail((String)("Did not expect exception when deleting lock with id '" + lockId + "' for user '" + userId + "' but got exception of type '" + e.getClass().getName() + "'"));
                }
                if (expectedException == null || expectedException.isAssignableFrom(e.getClass())) continue;
                Assert.fail((String)("Expected exception of type '" + expectedException.getName() + "' when deleting lock with id '" + lockId + "' for user '" + userId + "' but got exception of type '" + e.getClass().getName() + "'"));
            }
        }
    }

    @Test
    public void testGenerateNewLocks() throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        String documentNumber = "1243";
        PessimisticLock lock = lockService.generateNewLock(documentNumber);
        Assert.assertNotNull((String)"Generated lock should have id", (Object)lock.getId());
        Assert.assertEquals((String)"Document Number should match", (Object)documentNumber, (Object)lock.getDocumentNumber());
        Assert.assertNotNull((String)"Generated lock should have a generated timestamp ", (Object)lock.getGeneratedTimestamp());
        Assert.assertEquals((String)"Generated lock should have default lock descriptor", (Object)PessimisticLock.DEFAULT_LOCK_DESCRIPTOR, (Object)lock.getLockDescriptor());
        Assert.assertEquals((String)"Generated lock should be owned by current user", (Object)GlobalVariables.getUserSession().getPerson().getPrincipalName(), (Object)lock.getOwnedByUser().getPrincipalName());
        lock = (PessimisticLock)KRADServiceLocator.getDataObjectService().find(PessimisticLock.class, (Object)lock.getId());
        Assert.assertNotNull((String)"Generated lock should be available from BO Service", (Object)lock);
        Assert.assertNotNull((String)"Generated lock should have id", (Object)lock.getId());
        Assert.assertEquals((String)"Document Number should match", (Object)documentNumber, (Object)lock.getDocumentNumber());
        Assert.assertNotNull((String)"Generated lock should have a generated timestamp ", (Object)lock.getGeneratedTimestamp());
        Assert.assertEquals((String)"Generated lock should have default lock descriptor", (Object)PessimisticLock.DEFAULT_LOCK_DESCRIPTOR, (Object)lock.getLockDescriptor());
        Assert.assertEquals((String)"Generated lock should be owned by current user", (Object)GlobalVariables.getUserSession().getPerson().getPrincipalName(), (Object)lock.getOwnedByUser().getPrincipalName());
        documentNumber = "4321";
        String lockDescriptor = "this is a test lock descriptor";
        lock = lockService.generateNewLock(documentNumber, lockDescriptor);
        Assert.assertNotNull((String)"Generated lock should have id", (Object)lock.getId());
        Assert.assertEquals((String)"Document Number should match", (Object)documentNumber, (Object)lock.getDocumentNumber());
        Assert.assertNotNull((String)"Generated lock should have a generated timestamp ", (Object)lock.getGeneratedTimestamp());
        Assert.assertEquals((String)"Generated lock should have lock descriptor set", (Object)lockDescriptor, (Object)lock.getLockDescriptor());
        Assert.assertEquals((String)"Generated lock should be owned by current user", (Object)GlobalVariables.getUserSession().getPerson().getPrincipalName(), (Object)lock.getOwnedByUser().getPrincipalName());
        lock = (PessimisticLock)KRADServiceLocator.getDataObjectService().find(PessimisticLock.class, (Object)lock.getId());
        Assert.assertNotNull((String)"Generated lock should be available from BO Service", (Object)lock);
        Assert.assertNotNull((String)"Generated lock should have id", (Object)lock.getId());
        Assert.assertEquals((String)"Document Number should match", (Object)documentNumber, (Object)lock.getDocumentNumber());
        Assert.assertNotNull((String)"Generated lock should have a generated timestamp ", (Object)lock.getGeneratedTimestamp());
        Assert.assertEquals((String)"Generated lock should have lock descriptor set", (Object)lockDescriptor, (Object)lock.getLockDescriptor());
        Assert.assertEquals((String)"Generated lock should be owned by current user", (Object)GlobalVariables.getUserSession().getPerson().getPrincipalName(), (Object)lock.getOwnedByUser().getPrincipalName());
    }

    @UnitTestData(sqlStatements={@UnitTestSql(value="DELETE FROM KRNS_PESSIMISTIC_LOCK_T"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1111, 'fbcb0362-7dfb-102c-97b6-ed716fdaf540', 0, NULL, '1234', {d '2007-07-01'}, 'fran', 'aa5d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1112, '055bef4a-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1237', {d '2007-10-01'}, 'frank', 'dd5d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1113, '0e0144ec-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1236', {d '2007-10-01'}, 'frank', 'dd5d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1114, '1891526c-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1237', {d '2007-08-01'}, 'fred', 'ab4d6c83-4d0f-4309-a528-c2f81ec00396')")})
    @Test
    public void testGetPessimisticLocksForDocument() throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        String docId = "1234";
        Assert.assertEquals((String)("Document " + docId + " expected lock count incorrect"), (long)1L, (long)lockService.getPessimisticLocksForDocument(docId).size());
        docId = "1237";
        Assert.assertEquals((String)("Document " + docId + " expected lock count incorrect"), (long)2L, (long)lockService.getPessimisticLocksForDocument(docId).size());
        docId = "1236";
        Assert.assertEquals((String)("Document " + docId + " expected lock count incorrect"), (long)1L, (long)lockService.getPessimisticLocksForDocument(docId).size());
        docId = "3948";
        Assert.assertEquals((String)("Document " + docId + " expected lock count incorrect"), (long)0L, (long)lockService.getPessimisticLocksForDocument(docId).size());
    }

    @UnitTestData(sqlStatements={@UnitTestSql(value="DELETE FROM KRNS_PESSIMISTIC_LOCK_T"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1111, '24c40cd2-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1234', {d '2007-07-01'}, 'fran', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1112, '32602e8e-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1235', {d '2007-10-01'}, 'fran', 'bc5d6c66-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1113, '3acfc1ce-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1236', {d '2007-10-01'}, 'fran', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1114, '463cc642-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1237', {d '2007-08-01'}, 'fran', 'bc5d6c66-4d0f-4309-a528-c2f81ec00396')")})
    @Test
    public void testGetPessimisticLocksForSession() throws Exception {
        List locks = KRADServiceLocatorWeb.getPessimisticLockService().getPessimisticLocksForSession(this.sessionId);
        Assert.assertEquals((String)("Should return 2 locks for session " + this.sessionId), (long)2L, (long)locks.size());
        ArrayList<String> documentNumbers = new ArrayList<String>();
        for (PessimisticLock lock : locks) {
            documentNumbers.add(lock.getDocumentNumber());
        }
        Assert.assertTrue((String)("Locks should contain a lock for document number 1234 but contained " + documentNumbers), (boolean)documentNumbers.contains("1234"));
        Assert.assertTrue((String)("Locks should contain a lock for document number 1236 but contained " + documentNumbers), (boolean)documentNumbers.contains("1236"));
    }

    @UnitTestData(sqlStatements={@UnitTestSql(value="DELETE FROM KRNS_PESSIMISTIC_LOCK_T"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1111, '24c40cd2-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1234', {d '2007-07-01'}, 'fran', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1112, '32602e8e-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1235', {d '2007-10-01'}, 'frank', 'bc5d6c66-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1113, '3acfc1ce-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1236', {d '2007-10-01'}, 'frank', 'bc5d6c66-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1114, '463cc642-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1237', {d '2007-08-01'}, 'fred', 'dd5d6c66-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1115, '4e66c4b2-7dfc-102c-97b6-ed716fdaf540', 0, 'Temporary Lock', '1234', {d '2007-07-01'}, 'fran', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1116, '55d99b02-7dfc-102c-97b6-ed716fdaf540', 0, 'Temporary Lock', '1235', {d '2007-10-01'}, 'frank', 'bc5d6c66-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1117, '5e47fb26-7dfc-102c-97b6-ed716fdaf540', 0, 'Temporary Lock', '1236', {d '2007-10-01'}, 'frank', 'bc5d6c66-4d0f-4309-a528-c2f81ec00396')"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1118, '65c366d8-7dfc-102c-97b6-ed716fdaf540', 0, 'Temporary Lock', '1237', {d '2007-08-01'}, 'fred', 'dd5d6c66-4d0f-4309-a528-c2f81ec00396')")})
    @Test
    public void testReleaseAllLocksForUser() throws Exception {
        String lockDescriptor = "Temporary Lock";
        List locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be 8 manually inserted locks", (long)8L, (long)locks.size());
        KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, KimApiServiceLocator.getPersonService().getPerson("fran"), lockDescriptor);
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)("Should be 7 locks left after releasing locks for fran using lock descriptor " + lockDescriptor), (long)7L, (long)locks.size());
        KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, KimApiServiceLocator.getPersonService().getPerson("frank"), lockDescriptor);
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)("Should be 5 locks left after releasing locks for fran and frank using lock descriptor " + lockDescriptor), (long)5L, (long)locks.size());
        KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, KimApiServiceLocator.getPersonService().getPerson("fred"), lockDescriptor);
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)("Should be 4 locks left after releasing locks for fran, frank, and fred using lock descriptor " + lockDescriptor), (long)4L, (long)locks.size());
        KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, KimApiServiceLocator.getPersonService().getPerson("fran"));
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be 3 locks left after releasing locks for fran with no lock descriptor", (long)3L, (long)locks.size());
        KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, KimApiServiceLocator.getPersonService().getPerson("frank"));
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be 1 lock left after releasing locks for fran and frank with no lock descriptor", (long)1L, (long)locks.size());
        KRADServiceLocatorWeb.getPessimisticLockService().releaseAllLocksForUser(locks, KimApiServiceLocator.getPersonService().getPerson("fred"));
        locks = KRADServiceLocator.getDataObjectService().findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
        Assert.assertEquals((String)"Should be no locks left after releasing locks for fran, frank, and fred with no lock descriptor", (long)0L, (long)locks.size());
    }

    @UnitTestData(sqlStatements={@UnitTestSql(value="DELETE FROM KRNS_PESSIMISTIC_LOCK_T"), @UnitTestSql(value="INSERT INTO KRNS_PESSIMISTIC_LOCK_T (PESSIMISTIC_LOCK_ID,OBJ_ID,VER_NBR,LOCK_DESC_TXT,DOC_HDR_ID,GNRT_DT,PRNCPL_ID,SESN_ID) VALUES (1111, '73f340de-7dfc-102c-97b6-ed716fdaf540', 0, NULL, '1234', {d '2007-07-01'}, 'fran', 'ad4d6c83-4d0f-4309-a528-c2f81ec00396')")})
    @Test
    public void testSaveLock() throws Exception {
        String lockDescriptor = "new test lock descriptor";
        PessimisticLock lock = (PessimisticLock)KRADServiceLocator.getDataObjectService().find(PessimisticLock.class, (Object)1111L);
        lock.setLockDescriptor(lockDescriptor);
        KRADServiceLocatorWeb.getPessimisticLockService().save(lock);
        PessimisticLock savedLock = (PessimisticLock)KRADServiceLocator.getDataObjectService().find(PessimisticLock.class, (Object)1111L);
        Assert.assertEquals((String)"Lock descriptor is not correct from lock that was saved", (Object)lockDescriptor, (Object)savedLock.getLockDescriptor());
    }

    @Test
    public void testEstablishPessimisticLocks() throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        AccountRequestDocument accountDoc = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        Assert.assertTrue((String)"The AccountRequestDocument should be using pessimistic locking", (boolean)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(accountDoc.getClass().getName()).getUsePessimisticLocking());
        UserSession quickstartSession = new UserSession("quickstart");
        boolean canEdit = lockService.establishPessimisticLocks((Document)accountDoc, quickstartSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc.getPessimisticLocks().size());
        PessimisticLock quickstartPessimisticLock = (PessimisticLock)accountDoc.getPessimisticLocks().get(0);
        Assert.assertTrue((String)"quickstart pessimistic lock was not established", (boolean)quickstartPessimisticLock.isOwnedByUser(quickstartSession.getPerson()));
        Assert.assertTrue((String)"quickstart cannot edit", (boolean)canEdit);
        UserSession adminSession = new UserSession("admin");
        canEdit = lockService.establishPessimisticLocks((Document)accountDoc, adminSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc.getPessimisticLocks().size());
        PessimisticLock adminPessimisticLock = (PessimisticLock)accountDoc.getPessimisticLocks().get(0);
        Assert.assertFalse((String)"admin pessimistic lock was established", (boolean)adminPessimisticLock.isOwnedByUser(adminSession.getPerson()));
        Assert.assertFalse((String)"admin can edit", (boolean)canEdit);
        canEdit = lockService.establishPessimisticLocks((Document)accountDoc, quickstartSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc.getPessimisticLocks().size());
        Assert.assertTrue((String)"quickstart cannot edit", (boolean)canEdit);
    }

    @Test
    public void testCustomLockDescriptors() throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        AccountRequestDocument2 accountDoc2 = (AccountRequestDocument2)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest2");
        Assert.assertTrue((String)"The AccountRequestDocument2 should be using pessimistic locking", (boolean)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(accountDoc2.getClass().getName()).getUsePessimisticLocking());
        Assert.assertTrue((String)"The AccountRequestDocument2 should be using custom lock descriptors", (boolean)accountDoc2.useCustomLockDescriptors());
        String LOCK_KEY = "acctReqDoc2EditableFields";
        UserSession quickstartSession = new UserSession("quickstart");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)"editAllButReasons");
        String quickstartLockDescriptor = accountDoc2.getCustomLockDescriptor(quickstartSession.getPerson());
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)quickstartLockDescriptor);
        boolean canQuickstartEdit = lockService.establishPessimisticLocks((Document)accountDoc2, quickstartSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc2.getPessimisticLocks().size());
        PessimisticLock quickstartPessimisticLock = (PessimisticLock)accountDoc2.getPessimisticLocks().get(0);
        Assert.assertEquals((String)"quickstart pessimistic lock was established with wrong lock descriptor", (Object)quickstartLockDescriptor, (Object)quickstartPessimisticLock.getLockDescriptor());
        Assert.assertTrue((String)"quickstart cannot edit", (boolean)canQuickstartEdit);
        UserSession adminSession = new UserSession("admin");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)"editAllButReasons");
        String adminLockDescriptor = accountDoc2.getCustomLockDescriptor(adminSession.getPerson());
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)adminLockDescriptor);
        Assert.assertEquals((String)"Different lock descriptor generated for admin", (Object)quickstartLockDescriptor, (Object)adminLockDescriptor);
        boolean canAdminEdit = lockService.establishPessimisticLocks((Document)accountDoc2, adminSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc2.getPessimisticLocks().size());
        PessimisticLock adminPessimisticLock = (PessimisticLock)accountDoc2.getPessimisticLocks().get(0);
        Assert.assertFalse((String)"admin pessimistic lock was established", (boolean)adminPessimisticLock.isOwnedByUser(adminSession.getPerson()));
        Assert.assertFalse((String)"admin can edit", (boolean)canAdminEdit);
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)"editReasonsOnly");
        adminLockDescriptor = accountDoc2.getCustomLockDescriptor(quickstartSession.getPerson());
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)adminLockDescriptor);
        Assert.assertNotEquals((String)"Same lock descriptor generated for admin", (Object)quickstartLockDescriptor, (Object)adminLockDescriptor);
        canAdminEdit = lockService.establishPessimisticLocks((Document)accountDoc2, adminSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)2L, (long)accountDoc2.getPessimisticLocks().size());
        for (PessimisticLock pessimisticLock : accountDoc2.getPessimisticLocks()) {
            if (pessimisticLock.isOwnedByUser(quickstartSession.getPerson())) {
                Assert.assertEquals((String)"quickstart pessimistic lock was established with wrong lock descriptor", (Object)quickstartLockDescriptor, (Object)pessimisticLock.getLockDescriptor());
                continue;
            }
            if (!pessimisticLock.isOwnedByUser(adminSession.getPerson())) continue;
            Assert.assertEquals((String)"admin pessimistic lock was established with wrong lock descriptor", (Object)adminLockDescriptor, (Object)pessimisticLock.getLockDescriptor());
        }
        Assert.assertTrue((String)"admin cannot edit", (boolean)canAdminEdit);
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)"editReasonsOnly");
        lockService.establishPessimisticLocks((Document)accountDoc2, quickstartSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)2L, (long)accountDoc2.getPessimisticLocks().size());
        for (PessimisticLock pessimisticLock : accountDoc2.getPessimisticLocks()) {
            if (pessimisticLock.isOwnedByUser(quickstartSession.getPerson())) {
                Assert.assertEquals((String)"quickstart pessimistic lock was established with wrong lock descriptor", (Object)quickstartLockDescriptor, (Object)pessimisticLock.getLockDescriptor());
                continue;
            }
            if (!pessimisticLock.isOwnedByUser(adminSession.getPerson())) continue;
            Assert.assertEquals((String)"admin pessimistic lock was established with wrong lock descriptor", (Object)adminLockDescriptor, (Object)pessimisticLock.getLockDescriptor());
        }
        lockService.releaseAllLocksForUser(accountDoc2.getPessimisticLocks(), adminSession.getPerson(), adminLockDescriptor);
        accountDoc2.refreshPessimisticLocks();
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)"editReasonsOnly");
        accountDoc2.getCustomLockDescriptor(quickstartSession.getPerson());
        lockService.establishPessimisticLocks((Document)accountDoc2, quickstartSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)2L, (long)accountDoc2.getPessimisticLocks().size());
        for (PessimisticLock pessimisticLock : accountDoc2.getPessimisticLocks()) {
            Assert.assertTrue((String)"quickstart pessimistic lock was not established", (boolean)pessimisticLock.isOwnedByUser(quickstartSession.getPerson()));
        }
        GlobalVariables.getUserSession().removeObject(LOCK_KEY);
        lockService.releaseAllLocksForUser(accountDoc2.getPessimisticLocks(), quickstartSession.getPerson());
        accountDoc2.refreshPessimisticLocks();
        Assert.assertTrue((String)"There is a pessimistic lock established", (boolean)accountDoc2.getPessimisticLocks().isEmpty());
    }

    @Test
    @Deprecated
    public void testEstablishLocks() throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        AccountRequestDocument accountDoc = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        Assert.assertTrue((String)"The AccountRequestDocument should be using pessimistic locking", (boolean)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(accountDoc.getClass().getName()).getUsePessimisticLocking());
        UserSession quickstartSession = new UserSession("quickstart");
        Person[] quickstartPerson = new Person[]{quickstartSession.getPerson()};
        HashMap<String, String> editMode = new HashMap<String, String>();
        editMode.put("fullEntry", "true");
        Map finalModes = lockService.establishLocks((Document)accountDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 1, accountDoc.getPessimisticLocks(), quickstartPerson, null);
        UserSession adminSession = new UserSession("admin");
        HashSet<String> documentActions = new HashSet<String>(Arrays.asList("canCancel", "canSave", "canRoute", "canBlanketApprove"));
        Set finalActions = lockService.getDocumentActions((Document)accountDoc, adminSession.getPerson(), documentActions);
        Assert.assertFalse((String)"'admin' should not be able to cancel the locked document", (boolean)finalActions.contains("canCancel"));
        Assert.assertFalse((String)"'admin' should not be able to save the locked document", (boolean)finalActions.contains("canSave"));
        Assert.assertFalse((String)"'admin' should not be able to route the locked document", (boolean)finalActions.contains("canRoute"));
        Assert.assertFalse((String)"'admin' should not be able to blanket approve the locked document", (boolean)finalActions.contains("canBlanketApprove"));
        documentActions = new HashSet<String>(Arrays.asList("canCancel", "canSave", "canRoute"));
        finalActions = lockService.getDocumentActions((Document)accountDoc, quickstartSession.getPerson(), documentActions);
        Assert.assertTrue((String)"'quickstart' should have had cancel privileges", (boolean)finalActions.contains("canCancel"));
        Assert.assertTrue((String)"'quickstart' should have had save privileges", (boolean)finalActions.contains("canSave"));
        Assert.assertTrue((String)"'quickstart' should have had route privileges", (boolean)finalActions.contains("canRoute"));
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        finalModes = lockService.establishLocks((Document)accountDoc, editMode, adminSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, finalModes, 1, accountDoc.getPessimisticLocks(), quickstartPerson, null);
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        finalModes = lockService.establishLocks((Document)accountDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 1, accountDoc.getPessimisticLocks(), quickstartPerson, null);
        lockService.releaseAllLocksForUser(accountDoc.getPessimisticLocks(), quickstartSession.getPerson());
        accountDoc.refreshPessimisticLocks();
        UserSession systemSession = new UserSession("kr");
        Person[] systemPerson = new Person[]{systemSession.getPerson()};
        lockService.establishWorkflowPessimisticLocking((Document)accountDoc);
        this.assertCorrectLocksAreInPlace(false, null, 1, accountDoc.getPessimisticLocks(), systemPerson, null);
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        finalModes = lockService.establishLocks((Document)accountDoc, editMode, adminSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, finalModes, 1, accountDoc.getPessimisticLocks(), systemPerson, null);
        lockService.releaseWorkflowPessimisticLocking((Document)accountDoc);
        Assert.assertTrue((String)"There should not be any pessimistic locks present on the document", (boolean)accountDoc.getPessimisticLocks().isEmpty());
    }

    @Test
    public void testWorkflowPessimisticLocking() throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        AccountRequestDocument accountDoc = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        Assert.assertTrue((String)"The AccountRequestDocument should be using pessimistic locking", (boolean)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(accountDoc.getClass().getName()).getUsePessimisticLocking());
        UserSession systemSession = new UserSession("kr");
        lockService.establishWorkflowPessimisticLocking((Document)accountDoc);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc.getPessimisticLocks().size());
        PessimisticLock krPessimisticLock = (PessimisticLock)accountDoc.getPessimisticLocks().get(0);
        Assert.assertTrue((String)"kr pessimistic lock was not established", (boolean)krPessimisticLock.isOwnedByUser(systemSession.getPerson()));
        UserSession adminSession = new UserSession("admin");
        lockService.establishPessimisticLocks((Document)accountDoc, adminSession.getPerson(), true);
        Assert.assertEquals((String)"The wrong number of pessimistic locks are established", (long)1L, (long)accountDoc.getPessimisticLocks().size());
        PessimisticLock adminPessimisticLock = (PessimisticLock)accountDoc.getPessimisticLocks().get(0);
        Assert.assertFalse((String)"admin pessimistic lock was not established", (boolean)adminPessimisticLock.isOwnedByUser(adminSession.getPerson()));
        lockService.releaseWorkflowPessimisticLocking((Document)accountDoc);
        Assert.assertTrue((String)"There is a pessimistic lock established", (boolean)accountDoc.getPessimisticLocks().isEmpty());
    }

    @Test
    @Deprecated
    public void testPessimisticLockingWithCustomDocumentLockDescriptors() throws Exception {
        AccountRequestDocument2 accountDoc2 = (AccountRequestDocument2)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest2");
        Assert.assertTrue((String)"The AccountRequestDocument2 should be using pessimistic locking", (boolean)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(accountDoc2.getClass().getName()).getUsePessimisticLocking());
        Assert.assertTrue((String)"The AccountRequestDocument2 should be using custom lock descriptors", (boolean)accountDoc2.useCustomLockDescriptors());
        this.assertCustomLockDescriptorsAreWorking((Document)accountDoc2, "acctReqDoc2EditableFields", (Serializable)((Object)"editAllButReasons"), (Serializable)((Object)"editReasonsOnly"));
    }

    private void assertCustomLockDescriptorsAreWorking(Document testDoc, String LOCK_KEY, Serializable LOCK_VALUE1, Serializable LOCK_VALUE2) throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        UserSession quickstartSession = new UserSession("quickstart");
        Person[] allPersons = new Person[]{quickstartSession.getPerson(), null};
        HashMap<String, String> editMode = new HashMap<String, String>();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE1);
        String[] allDescriptors = new String[]{testDoc.getCustomLockDescriptor(quickstartSession.getPerson()), null};
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)allDescriptors[0]);
        Map finalModes = lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE1);
        lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, null, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        UserSession adminSession = new UserSession("admin");
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE1);
        Assert.assertEquals((String)"The document should have generated the same lock descriptors for both 'quickstart' and 'admin'", (Object)allDescriptors[0], (Object)testDoc.getCustomLockDescriptor(adminSession.getPerson()));
        finalModes = lockService.establishLocks(testDoc, editMode, adminSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, finalModes, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        allPersons[1] = adminSession.getPerson();
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE2);
        allDescriptors[1] = testDoc.getCustomLockDescriptor(adminSession.getPerson());
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)allDescriptors[1]);
        Assert.assertNotSame((String)"'quickstart' and 'admin' should have different custom lock descriptors now", (Object)allDescriptors[0], (Object)allDescriptors[1]);
        finalModes = lockService.establishLocks(testDoc, editMode, adminSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 2, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE2);
        lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, null, 2, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        lockService.releaseAllLocksForUser(testDoc.getPessimisticLocks(), allPersons[1], allDescriptors[1]);
        testDoc.refreshPessimisticLocks();
        this.assertCorrectLocksAreInPlace(false, null, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        allPersons[1] = allPersons[0];
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE2);
        finalModes = lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 2, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        GlobalVariables.getUserSession().removeObject(LOCK_KEY);
        lockService.releaseAllLocksForUser(testDoc.getPessimisticLocks(), allPersons[0]);
        testDoc.refreshPessimisticLocks();
        Assert.assertTrue((String)"There should not be any pessimistic locks present on the document", (boolean)testDoc.getPessimisticLocks().isEmpty());
    }

    private void assertCorrectLocksAreInPlace(boolean latestUserHasFullEntry, Map<?, ?> finalModes, int expectedLockQuantity, List<PessimisticLock> pessimisticLocks, Person[] expectedOwners, String[] expectedDescriptors) throws Exception {
        if (finalModes != null) {
            Assert.assertEquals((String)"The last user that tried to establish locks does not have the expected status on their full entry privileges", (Object)latestUserHasFullEntry, (Object)StringUtils.equalsIgnoreCase((String)"true", (String)((String)finalModes.get("fullEntry"))));
        }
        Assert.assertEquals((String)"The wrong number of pessimistic locks are in place", (long)expectedLockQuantity, (long)pessimisticLocks.size());
        for (int i = pessimisticLocks.size() - 1; i > -1; --i) {
            Assert.assertTrue((String)("The lock at index " + i + " did not have the expected owner of " + expectedOwners[i].getPrincipalName()), (boolean)pessimisticLocks.get(i).isOwnedByUser(expectedOwners[i]));
            if (expectedDescriptors == null) continue;
            Assert.assertTrue((String)("The lock at index " + i + " did not have the expected lock descriptor of " + expectedDescriptors[i]), (boolean)pessimisticLocks.get(i).getLockDescriptor().equals(expectedDescriptors[i]));
        }
    }
}

