/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.OjbAndJpa;
import org.kuali.rice.krad.test.document.OjbOnly;
import org.kuali.rice.krad.test.document.bo.JPADataObject;

public class SequenceAccessorServiceTest
extends KRADTestCase {
    private static final String ARBITRARY_SEQUENCE = "trvl_id_seq";

    @Test
    public void testExceptionForKradData() {
        try {
            KNSServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(ARBITRARY_SEQUENCE, JPADataObject.class);
            Assert.fail((String)"Using Legacy SequenceAccessorService in non-Legacy Context - should have failed.");
        }
        catch (ConfigurationException configurationException) {
        }
        catch (Exception ex) {
            Assert.fail((String)("We should have failed with a configuration Exception - but intead got a: " + ex.getClass().getName() + " : " + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    @Test
    public void testOjbOnlyWorks() {
        Long nextAvailableSequenceNumber = KNSServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(ARBITRARY_SEQUENCE, OjbOnly.class);
        Assert.assertNotNull((String)"Next sequence number should not have been null", (Object)nextAvailableSequenceNumber);
        Assert.assertTrue((String)("Nest sequence number should have been created than zero.  Was: " + nextAvailableSequenceNumber), (nextAvailableSequenceNumber > 0L ? 1 : 0) != 0);
    }

    @Test
    @KRADTestCase.Legacy
    public void testNoExceptionForBothKradDataAndOjb_InLegacyContext() {
        Long nextAvailableSequenceNumber = KNSServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(ARBITRARY_SEQUENCE, OjbAndJpa.class);
        Assert.assertNotNull((String)"Next sequence number should not have been null", (Object)nextAvailableSequenceNumber);
        Assert.assertTrue((String)("Nest sequence number should have been created than zero.  Was: " + nextAvailableSequenceNumber), (nextAvailableSequenceNumber > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testExceptionForBothKradDataAndOjb_NotInLegacyContext() {
        try {
            KNSServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(ARBITRARY_SEQUENCE, OjbAndJpa.class);
            Assert.fail((String)"Using Legacy SequenceAccessorService in non-Legacy Context - should have failed.");
        }
        catch (ConfigurationException configurationException) {
        }
        catch (Exception ex) {
            Assert.fail((String)("We should have failed with a configuration Exception - but intead got a: " + ex.getClass().getName() + " : " + ex.getMessage()));
            ex.printStackTrace();
        }
    }
}

