/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.Company;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.Person;
import org.kuali.rice.krad.datadictionary.validation.constraint.provider.CollectionDefinitionConstraintProvider;
import org.kuali.rice.krad.datadictionary.validation.processor.MustOccurConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.impl.DataDictionaryServiceImpl;
import org.kuali.rice.krad.service.impl.DictionaryValidationServiceImpl;
import org.kuali.rice.krad.test.KRADTestCase;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DictionaryValidationServiceImplTest
extends KRADTestCase {
    ClassPathXmlApplicationContext context;
    private DictionaryValidationServiceImpl service;
    DataDictionary dataDictionary = new DataDictionary();
    protected DataObjectEntry addressEntry;
    private Address validLondonAddress = new Address("8129 Maiden Lane", "", "London", "", "SE1 0P3", "UK", null);
    private Address validUSAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "USA", null);
    private Address invalidUSAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "", "92342-123456", "USA", null);
    private Address noZipNoCityUSAddress = new Address("893 Presidential Ave", "Suite 800", null, "DC", null, "USA", null);
    private Address validNonDCUSAddress = new Address("89 11th Street", "Suite 800", "Seattle", "WA", "", "USA", null);
    private Address invalidDCUSAddress = new Address("89 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "USA", null);
    private Address invalidHKAddress = new Address("182 Lin Pai Road", "", "Hong Kong", "N.T.", "", "CN", null);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = new ClassPathXmlApplicationContext("classpath:DictionaryValidationServiceSpringBeans.xml");
        this.service = (DictionaryValidationServiceImpl)this.context.getBean("dictionaryValidationService");
        this.dataDictionary.addConfigFileLocation("KR-NS", "classpath:org/kuali/rice/krad/datadictionary/DataDictionaryBaseTypes.xml");
        this.dataDictionary.addConfigFileLocation("KR-NS", "classpath:org/kuali/rice/kns/bo/datadictionary/DataDictionaryBaseTypes.xml");
        this.dataDictionary.addConfigFileLocation("KR-NS", "classpath:org/kuali/rice/krad/test/datadictionary/validation/Company.xml");
        this.dataDictionary.addConfigFileLocation("KR-NS", "classpath:org/kuali/rice/krad/test/datadictionary/validation/Address.xml");
        this.dataDictionary.addConfigFileLocation("KR-NS", "classpath:org/kuali/rice/krad/test/datadictionary/validation/Employee.xml");
        this.dataDictionary.addConfigFileLocation("KR-NS", "classpath:org/kuali/rice/krad/test/datadictionary/validation/Person.xml");
        this.dataDictionary.parseDataDictionaryConfigurationFiles(false);
        this.addressEntry = this.dataDictionary.getDataObjectEntry("org.kuali.rice.krad.datadictionary.validation.Address");
    }

    @Test
    public void testValidNonUSAddress() {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.validLondonAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testValidUSAddress() {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.validUSAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testInvalidUSAddress() {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.invalidUSAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "country", "error.requiresField"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "postalCode", "error.outOfRange"));
    }

    @Test
    public void testValidNonDCAddress() {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.validNonDCUSAddress, "org.kuali.rice.krad.datadictionary.validation.Address", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testInvalidDCAddress() {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.invalidDCUSAddress, "org.kuali.rice.krad.datadictionary.validation.Address", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "street1", "error.invalidFormat"));
    }

    @Test
    public void testNoStateNoZipUSAddress() {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.noZipNoCityUSAddress, "org.kuali.rice.krad.datadictionary.validation.Address", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        if (dictionaryValidationResult.getNumberOfErrors() > 0) {
            for (ConstraintValidationResult constraintValidationResult : dictionaryValidationResult) {
                if (constraintValidationResult.getStatus().getLevel() < ErrorLevel.WARN.getLevel()) continue;
                Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)constraintValidationResult.getStatus());
                Assert.assertEquals((Object)"error.occurs", (Object)constraintValidationResult.getErrorKey());
                List children = constraintValidationResult.getChildren();
                Assert.assertNotNull((Object)children);
                Assert.assertEquals((long)2L, (long)children.size());
                ConstraintValidationResult child1 = (ConstraintValidationResult)children.get(0);
                ConstraintValidationResult child2 = (ConstraintValidationResult)children.get(1);
                Assert.assertEquals((Object)"error.requiresField", (Object)child1.getErrorKey());
                Assert.assertArrayEquals((Object[])new String[]{"postalCode"}, (Object[])child1.getErrorParameters());
                List grandchildren = child2.getChildren();
                Assert.assertNotNull((Object)grandchildren);
                Assert.assertEquals((long)2L, (long)grandchildren.size());
                ConstraintValidationResult grandchild1 = (ConstraintValidationResult)grandchildren.get(0);
                Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)grandchild1.getStatus());
                Assert.assertEquals((Object)"error.requiresField", (Object)grandchild1.getErrorKey());
                Assert.assertArrayEquals((Object[])new String[]{"city"}, (Object[])grandchild1.getErrorParameters());
                ConstraintValidationResult grandchild2 = (ConstraintValidationResult)grandchildren.get(1);
                Assert.assertEquals((Object)ErrorLevel.OK, (Object)grandchild2.getStatus());
                Assert.assertEquals((Object)new MustOccurConstraintProcessor().getName(), (Object)grandchild2.getConstraintName());
            }
        }
    }

    @Test
    public void testSimpleCaseConstraints() throws IOException {
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)this.invalidHKAddress, "org.kuali.rice.krad.datadictionary.validation.Address", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "street2", "error.required"));
    }

    @Test
    public void testRequiredNestedAttribute() throws IOException {
        DataDictionaryServiceImpl dataDictionaryService = new DataDictionaryServiceImpl(this.dataDictionary);
        this.service.setDataDictionaryService((DataDictionaryService)dataDictionaryService);
        DataObjectEntry addressEntry = this.dataDictionary.getDataObjectEntry("org.kuali.rice.krad.datadictionary.validation.Address");
        DataObjectEntry companyEntry = this.dataDictionary.getDataObjectEntry("org.kuali.rice.krad.datadictionary.validation.Company");
        addressEntry.completeValidation();
        companyEntry.completeValidation();
        Company acmeCompany = new Company();
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "mainAddress", "error.required"));
        Address acmeMainAddress = new Address();
        acmeCompany.setMainAddress(acmeMainAddress);
        dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "mainAddress.country", "error.required"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "mainAddress", "error.occurs"));
        acmeMainAddress.setCountry("US");
        acmeMainAddress.setPostalCode("11111");
        dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Employee companyContact = new Employee();
        acmeCompany.setMainContact(companyContact);
        Person mainContactPerson = new Person();
        companyContact.setEmployeeDetails(mainContactPerson);
        companyContact.setEmployeeId("companyContact");
        dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "mainContact.employeeDetails.gender", "error.required"));
    }

    @Test
    public void testCollectionConstraints() throws IOException {
        DataDictionaryServiceImpl dataDictionaryService = new DataDictionaryServiceImpl(this.dataDictionary);
        this.service.setDataDictionaryService((DataDictionaryService)dataDictionaryService);
        DataObjectEntry companyEntry = this.dataDictionary.getDataObjectEntry("org.kuali.rice.krad.datadictionary.validation.Company");
        this.service.getConstraintProviders().add(new CollectionDefinitionConstraintProvider());
        Company acmeCompany = new Company();
        Address acmeMainAddress = new Address();
        acmeMainAddress.setCountry("US");
        acmeMainAddress.setPostalCode("11111");
        acmeCompany.setMainAddress(acmeMainAddress);
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "employees", "error.quantityRange"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "slogans", "error.minOccurs"));
        Employee employee1 = new Employee();
        Person person = new Person();
        person.setBirthDate(new Date());
        person.setGender("M");
        employee1.setEmployeeDetails(person);
        employee1.setEmployeeId("123456789");
        ArrayList<Employee> employees = new ArrayList<Employee>();
        employees.add(employee1);
        acmeCompany.setEmployees(employees);
        ArrayList<String> slogans = new ArrayList<String>();
        slogans.add("Slogan One");
        acmeCompany.setSlogans(slogans);
        dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "employees", "error.quantityRange"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "slogans", "error.minOccurs"));
        employees.add(new Employee());
        employees.add(new Employee());
        slogans.add("Slogan Two");
        dictionaryValidationResult = this.service.validate((Object)acmeCompany, "org.kuali.rice.krad.datadictionary.validation.Company", (DataDictionaryEntry)companyEntry, true);
        Assert.assertEquals((long)5L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "employees[1].employeeId", "error.required"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "employees[1].employeeDetails", "error.required"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "employees[2].employeeId", "error.required"));
        Assert.assertTrue((boolean)this.hasError(dictionaryValidationResult, "employees[2].employeeDetails", "error.required"));
    }

    @Test
    public void testStateValidation() throws IOException {
        Address testAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "USA", null);
        testAddress.setValidationState("state1");
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state1");
        testAddress.setStreet2("@");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        testAddress.setCountry("CN");
        testAddress.setStreet2("Apt 122");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state1");
        testAddress.setStreet2("");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        testAddress.setCountry("USA");
        testAddress.setStreet2("");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testStateValidationForMustOccurs() throws IOException {
        Address testAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "Country", null);
        testAddress.setValidationState("state1");
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setPostalCode("");
        testAddress.setState("");
        testAddress.setValidationState("state1");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setPostalCode("");
        testAddress.setState("CA");
        testAddress.setValidationState("state1");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setPostalCode("23456");
        testAddress.setState("");
        testAddress.setValidationState("state1");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testStateValidationConstraintOverrides() throws IOException {
        Address testAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "USA", null);
        testAddress.setStreet2("123AAAAA123");
        testAddress.setValidationState("state2");
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state3");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state4");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setStreet2("1111");
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state3");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state4");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setStreet2("BBBB");
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state3");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state4");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setStreet2("$%@");
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testStateRangeValidationForPrerequisite() throws IOException {
        Address testAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "USA", null);
        testAddress.setValidationState("state1");
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setCity("City");
        testAddress.setCountry("");
        testAddress.setValidationState("state1");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state3");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)3L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state4");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)3L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setCity("");
        testAddress.setCountry("");
        testAddress.setValidationState("state1");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state2");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state3");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state4");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    @Test
    public void testStateValidationSimpleConstraintWithOverrides() {
        Address testAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "12031", "USA", null);
        testAddress.setValidationState("state1");
        DictionaryValidationResult dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setState("1234567890123456789012345678901234567");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setValidationState("state5");
        testAddress.setState("DC");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setState("");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)2L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setState("fff");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        testAddress.setState("f");
        dictionaryValidationResult = this.service.validate((Object)testAddress, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry, true);
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
    }

    protected boolean hasError(DictionaryValidationResult dvr, String attributeName, String errorKey) {
        Iterator dvrIterator = dvr.iterator();
        boolean containsError = false;
        while (dvrIterator.hasNext() && !containsError) {
            ConstraintValidationResult cvr = (ConstraintValidationResult)dvrIterator.next();
            if (attributeName.contains("[")) {
                containsError = attributeName.equals(cvr.getAttributePath()) && errorKey.equals(cvr.getErrorKey()) && ErrorLevel.ERROR == cvr.getStatus();
                continue;
            }
            containsError = attributeName.equals(cvr.getAttributeName()) && errorKey.equals(cvr.getErrorKey()) && ErrorLevel.ERROR == cvr.getStatus();
        }
        return containsError;
    }
}

